/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import org.jfree.report.modules.misc.tablemodel.CloseableTableModel;
import org.jfree.report.modules.misc.tablemodel.TypeMapper;
import org.jfree.util.Log;

public class ScrollableResultSetTableModel
extends AbstractTableModel
implements CloseableTableModel {
    private ResultSet resultset;
    private ResultSetMetaData dbmd;
    private int rowCount;
    private final boolean labelMapMode;
    private Class[] types;
    static /* synthetic */ Class class$java$lang$Object;

    public ScrollableResultSetTableModel(ResultSet resultset, boolean labelMapMode) throws SQLException {
        this.labelMapMode = labelMapMode;
        if (resultset != null) {
            this.updateResultSet(resultset);
        } else {
            this.close();
        }
    }

    protected ScrollableResultSetTableModel(boolean labelMapMode) {
        this.labelMapMode = labelMapMode;
    }

    public boolean isLabelMapMode() {
        return this.labelMapMode;
    }

    public void updateResultSet(ResultSet resultset) throws SQLException {
        if (this.resultset != null) {
            this.close();
        }
        this.resultset = resultset;
        this.dbmd = resultset.getMetaData();
        this.rowCount = resultset.last() ? resultset.getRow() : 0;
        this.fireTableStructureChanged();
    }

    public void close() {
        if (this.resultset != null) {
            try {
                this.resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.resultset = null;
        this.dbmd = null;
        this.rowCount = 0;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.resultset == null) {
            return 0;
        }
        try {
            if (this.resultset.last()) {
                this.rowCount = this.resultset.getRow();
                if (this.rowCount == -1) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        catch (SQLException sqle) {
            return 0;
        }
        return this.rowCount;
    }

    public int getColumnCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.dbmd != null) {
            try {
                return this.dbmd.getColumnCount();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getColumnName(int column) {
        if (this.dbmd != null) {
            try {
                if (this.isLabelMapMode()) {
                    return this.dbmd.getColumnLabel(column + 1);
                }
                return this.dbmd.getColumnName(column + 1);
            }
            catch (SQLException e) {
                Log.info((Object)"ScrollableResultSetTableModel.getColumnName: SQLException.");
            }
        }
        return null;
    }

    public Object getValueAt(int row, int column) {
        if (this.resultset != null) {
            try {
                this.resultset.absolute(row + 1);
                return this.resultset.getObject(column + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        if (this.types != null) {
            return this.types[column];
        }
        if (this.dbmd != null) {
            try {
                this.types = TypeMapper.mapTypes(this.dbmd);
                return this.types[column];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ScrollableResultSetTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public String getColumnClassName(int column) {
        if (this.dbmd != null) {
            return this.mckoiDBFixClassName(this.getColumnClass(column).getName());
        }
        return (class$java$lang$Object == null ? (class$java$lang$Object = ScrollableResultSetTableModel.class$("java.lang.Object")) : class$java$lang$Object).getName();
    }

    private String mckoiDBFixClassName(String classname) {
        if (classname.startsWith("class ")) {
            return classname.substring(6).trim();
        }
        return classname;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

