/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.preferences.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.report.modules.preferences.base.ConfigFactory;
import org.jfree.report.modules.preferences.base.ConfigStorage;
import org.jfree.report.modules.preferences.base.ConfigStoreException;
import org.jfree.util.Configuration;

public class FileConfigStorage
implements ConfigStorage {
    private final File baseDirectory;
    private static final String CONFIGHEADER = "part of the jfreereport filesystem config store";

    public FileConfigStorage(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void store(String configPath, Configuration config) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        Enumeration keys = config.getConfigProperties();
        Properties properties = new Properties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = config.getConfigProperty(key);
            if (value == null || key == null) continue;
            properties.put(key, value);
        }
        File target = new File(this.baseDirectory, configPath);
        if (target.exists() && !target.canWrite()) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            properties.store(out, CONFIGHEADER);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to write config " + configPath, e);
        }
    }

    public Configuration load(String configPath, Configuration defaults) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The given path is not valid.");
        }
        try {
            Properties properties = new Properties();
            File target = new File(this.baseDirectory, configPath);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(target));
            properties.load(in);
            ((InputStream)in).close();
            HierarchicalConfiguration config = new HierarchicalConfiguration(defaults);
            Iterator<Object> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                config.setConfigProperty(key, properties.getProperty(key));
            }
            return config;
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to read config" + configPath, e);
        }
    }

    public boolean isAvailable(String configPath) {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        File target = new File(this.baseDirectory, configPath);
        return target.exists() && target.canRead();
    }

    public String toString() {
        return "FileConfigStorage={baseDir=" + this.baseDirectory + "}";
    }
}

