/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.preferences.filesystem;

import java.io.File;
import org.jfree.base.modules.ModuleInitializeException;
import org.jfree.base.modules.ModuleInitializer;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.preferences.base.ConfigFactory;
import org.jfree.report.modules.preferences.filesystem.FileConfigStorage;

public class FileConfigStoreModuleInitializer
implements ModuleInitializer {
    public static final String USER_BASEDIR_CONFIG_KEY = "org.jfree.report.modules.misc.configstore.filesystem.UserTargetDir";
    public static final String SYSTEM_BASEDIR_CONFIG_KEY = "org.jfree.report.modules.misc.configstore.filesystem.SystemTargetDir";

    public void performInit() throws ModuleInitializeException {
        String userBaseDirectory = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(USER_BASEDIR_CONFIG_KEY, "~/.jfreereport/user");
        String systemBaseDirectory = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(SYSTEM_BASEDIR_CONFIG_KEY, "~/.jfreereport/system");
        ConfigFactory factory = ConfigFactory.getInstance();
        factory.defineUserStorage(new FileConfigStorage(this.getStoragePath(userBaseDirectory)));
        factory.defineSystemStorage(new FileConfigStorage(this.getStoragePath(systemBaseDirectory)));
    }

    private File getStoragePath(String baseDirectory) throws ModuleInitializeException {
        File baseDirectoryFile;
        if (!baseDirectory.startsWith("~/")) {
            baseDirectoryFile = new File(baseDirectory);
        } else {
            try {
                String homeDirectory = System.getProperty("user.home");
                if (baseDirectory.equals("~/")) {
                    baseDirectoryFile = new File(homeDirectory);
                } else {
                    baseDirectory = "." + baseDirectory.substring(1);
                    baseDirectoryFile = new File(homeDirectory, baseDirectory);
                }
            }
            catch (Exception e) {
                throw new ModuleInitializeException("Failed to create the file config storage.", e);
            }
        }
        if (!baseDirectoryFile.exists()) {
            if (!baseDirectoryFile.mkdirs()) {
                throw new ModuleInitializeException("Unable to create the specified directory.");
            }
        } else if (!baseDirectoryFile.canRead() || !baseDirectoryFile.canWrite()) {
            throw new ModuleInitializeException("Unable to access the specified directory.");
        }
        return baseDirectoryFile;
    }
}

