/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.structure;

import java.util.HashMap;
import java.util.Map;
import org.jfree.report.flow.ParameterMapping;
import org.jfree.report.structure.ReportDefinition;

public class SubReport
extends ReportDefinition {
    private HashMap exportParameters;
    private HashMap inputParameters;

    public SubReport() {
        this.setType("sub-report");
        this.exportParameters = new HashMap();
        this.inputParameters = new HashMap();
    }

    public void addExportParameter(String outerName, String innerName) {
        this.exportParameters.put(outerName, innerName);
    }

    public void removeExportParameter(String outerName) {
        this.exportParameters.remove(outerName);
    }

    public String getExportParameter(String outerName) {
        return (String)this.exportParameters.get(outerName);
    }

    public String[] getExportParameters() {
        return this.exportParameters.keySet().toArray(new String[this.exportParameters.size()]);
    }

    public String[] getPeerExportParameters() {
        return this.exportParameters.values().toArray(new String[this.exportParameters.size()]);
    }

    public ParameterMapping[] getExportMappings() {
        Map.Entry[] inputEntries = this.exportParameters.entrySet().toArray(new Map.Entry[this.exportParameters.size()]);
        ParameterMapping[] mapping = new ParameterMapping[this.exportParameters.size()];
        for (int i = 0; i < inputEntries.length; ++i) {
            Map.Entry entry = inputEntries[i];
            mapping[i] = new ParameterMapping((String)entry.getKey(), (String)entry.getValue());
        }
        return mapping;
    }

    public void addInputParameter(String outerName, String innerName) {
        this.inputParameters.put(outerName, innerName);
    }

    public void removeInputParameter(String outerName) {
        this.inputParameters.remove(outerName);
    }

    public String getInnerParameter(String outerName) {
        return (String)this.inputParameters.get(outerName);
    }

    public String[] getInputParameters() {
        return this.inputParameters.keySet().toArray(new String[this.inputParameters.size()]);
    }

    public String[] getPeerInputParameters() {
        return this.inputParameters.values().toArray(new String[this.inputParameters.size()]);
    }

    public ParameterMapping[] getInputMappings() {
        Map.Entry[] inputEntries = this.inputParameters.entrySet().toArray(new Map.Entry[this.inputParameters.size()]);
        ParameterMapping[] mapping = new ParameterMapping[this.inputParameters.size()];
        for (int i = 0; i < inputEntries.length; ++i) {
            Map.Entry entry = inputEntries[i];
            mapping[i] = new ParameterMapping((String)entry.getKey(), (String)entry.getValue());
        }
        return mapping;
    }

    public boolean isGlobalImport() {
        return "*".equals(this.inputParameters.get("*"));
    }

    public boolean isGlobalExport() {
        return "*".equals(this.exportParameters.get("*"));
    }

    public Object clone() throws CloneNotSupportedException {
        SubReport report = (SubReport)super.clone();
        report.inputParameters = (HashMap)this.inputParameters.clone();
        report.exportParameters = (HashMap)this.exportParameters.clone();
        return report;
    }
}

