/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

public class CSVQuoter {
    private char separator;
    private char quate;
    private String doubleQuate;

    public CSVQuoter() {
        this(',', '\"');
    }

    public CSVQuoter(char separator) {
        this(separator, '\"');
    }

    public CSVQuoter(char separator, char quate) {
        this.separator = separator;
        this.quate = quate;
        this.doubleQuate = "" + quate + quate;
    }

    public String doQuoting(String original) {
        if (this.isQuotingNeeded(original)) {
            StringBuffer retval = new StringBuffer();
            retval.append(this.quate);
            this.applyQuote(retval, original);
            retval.append(this.quate);
            return retval.toString();
        }
        return original;
    }

    public String undoQuoting(String nativeString) {
        if (this.isQuotingNeeded(nativeString)) {
            int start;
            StringBuffer b = new StringBuffer(nativeString.length());
            int length = nativeString.length() - 1;
            int pos = start = 1;
            while (pos != -1) {
                pos = nativeString.indexOf(this.doubleQuate, start);
                if (pos == -1) {
                    b.append(nativeString.substring(start, length));
                    continue;
                }
                b.append(nativeString.substring(start, pos));
                start = pos + 1;
            }
            return b.toString();
        }
        return nativeString;
    }

    private boolean isQuotingNeeded(String str) {
        if (str.indexOf(this.separator) != -1) {
            return true;
        }
        if (str.indexOf(10) != -1) {
            return true;
        }
        return str.indexOf(this.quate, 1) != -1;
    }

    private void applyQuote(StringBuffer b, String original) {
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == this.quate) {
                b.append(this.doubleQuate);
                continue;
            }
            b.append(c);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuate() {
        return this.quate;
    }
}

