/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.ArrayList;
import java.util.HashMap;

public class LazyNameMap
implements Cloneable {
    private HashMap map = new HashMap();
    private ArrayList names = new ArrayList();
    private boolean clean = false;

    public boolean isClean() {
        return this.clean;
    }

    public void setValue(String key, int value) {
        if (this.clean) {
            this.map = (HashMap)this.map.clone();
            this.names = (ArrayList)this.names.clone();
            this.clean = false;
        }
        this.map.put(key, new NameCarrier(value));
    }

    public NameCarrier get(String key) {
        return (NameCarrier)this.map.get(key);
    }

    public NameCarrier remove(String key) {
        NameCarrier nc = (NameCarrier)this.map.get(key);
        if (nc == null) {
            return null;
        }
        if (this.clean) {
            this.map = (HashMap)this.map.clone();
            this.names = (ArrayList)this.names.clone();
            this.clean = false;
        }
        return (NameCarrier)this.map.remove(key);
    }

    public Object clone() {
        try {
            LazyNameMap lm = (LazyNameMap)super.clone();
            lm.clean = true;
            this.clean = true;
            return lm;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason");
        }
    }

    public static class NameCarrier {
        private int value;
        private int counter;

        public NameCarrier(int value) {
            this.value = value;
            this.counter = 1;
        }

        public int getValue() {
            return this.value;
        }

        public int getInstanceCount() {
            return this.counter;
        }

        public void increase() {
            ++this.counter;
        }

        public void decrease() {
            --this.counter;
        }
    }
}

