/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jfree.util.Log;

public class MemoryByteArrayOutputStream
extends OutputStream {
    private int initialBufferSize;
    private int maximumBufferIncrement;
    private int cursor;
    private byte[] buffer;
    private byte[] singleIntArray;

    public MemoryByteArrayOutputStream() {
        this(4096, 65536);
    }

    public MemoryByteArrayOutputStream(int bufferSize, int maximumBufferIncrement) {
        this.initialBufferSize = bufferSize;
        this.maximumBufferIncrement = maximumBufferIncrement;
        this.buffer = new byte[bufferSize];
        this.singleIntArray = new byte[1];
    }

    public synchronized void write(byte[] cbuf, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (len + off > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(this.cursor + len);
        System.arraycopy(cbuf, off, this.buffer, this.cursor, len);
        this.cursor += len;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(int b) throws IOException {
        this.singleIntArray[0] = (byte)(0xFF & b);
        this.write(this.singleIntArray, 0, 1);
    }

    private void ensureSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        int computedSize = (int)Math.min((double)(this.buffer.length + 1) * 1.5, (double)(this.buffer.length + this.maximumBufferIncrement));
        int newSize = Math.max(size, computedSize);
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.cursor);
        this.buffer = newBuffer;
    }

    public void flush() throws IOException {
        if (this.buffer.length - this.cursor > 50000) {
            Log.debug((Object)("WASTED: " + (this.buffer.length - this.cursor)));
        }
    }

    public void close() throws IOException {
    }

    public synchronized byte[] toByteArray() {
        byte[] retval = new byte[this.cursor];
        System.arraycopy(this.buffer, 0, retval, 0, this.cursor);
        return retval;
    }

    public int getLength() {
        return this.cursor;
    }

    public byte[] getRaw() {
        if (this.buffer.length - this.cursor > 50000) {
            Log.debug((Object)("WASTED: " + (this.buffer.length - this.cursor) + " Length: " + this.buffer.length));
        }
        return this.buffer;
    }
}

