/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.PropertyLookupParser;

public class MessageFormatSupport
implements Serializable,
Cloneable {
    private String[] fields;
    private MessageFormat format;
    private String formatString;
    private String compiledFormat;
    private String nullString;

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        MessageCompiler compiler = new MessageCompiler();
        if (formatString == null) {
            throw new NullPointerException("Format must not be null");
        }
        this.compiledFormat = compiler.translateAndLookup(formatString);
        this.fields = compiler.getFields();
        this.format = new MessageFormat(this.compiledFormat);
        this.formatString = formatString;
    }

    public String performFormat(DataRow dataRow) throws DataSourceException {
        return MessageFormatSupport.formatWithReplace(dataRow, this.format, this.fields, this.nullString);
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public String getCompiledFormat() {
        return this.compiledFormat;
    }

    public void setLocale(Locale locale) {
        this.format.setLocale(locale);
        this.format.applyPattern(this.compiledFormat);
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageFormatSupport support = (MessageFormatSupport)super.clone();
        if (this.format != null) {
            support.format = (MessageFormat)this.format.clone();
        }
        return support;
    }

    public String[] getFields() {
        return (String[])this.fields.clone();
    }

    public static String formatWithReplace(DataRow dataRow, MessageFormat format, String[] fields, String nullString) throws DataSourceException {
        if (fields == null || format == null) {
            return null;
        }
        boolean fastProcessingPossible = nullString == null;
        Format[] formats = format.getFormats();
        boolean fastProcessing = true;
        Object[] parameters = new Object[fields.length];
        boolean[] replaced = new boolean[fields.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object value = dataRow.get(fields[i]);
            Format currentFormat = formats[i];
            if (value == null) {
                parameters[i] = nullString;
                replaced[i] = currentFormat != null;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            if (currentFormat instanceof DateFormat) {
                if (value instanceof Date) {
                    parameters[i] = value;
                    replaced[i] = false;
                    continue;
                }
                parameters[i] = nullString;
                replaced[i] = true;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            if (currentFormat instanceof NumberFormat) {
                if (value instanceof Number) {
                    parameters[i] = value;
                    replaced[i] = false;
                    continue;
                }
                parameters[i] = nullString;
                replaced[i] = true;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            parameters[i] = value;
            replaced[i] = false;
        }
        if (fastProcessing) {
            return format.format(parameters);
        }
        MessageFormat effectiveFormat = (MessageFormat)format.clone();
        for (int i = 0; i < replaced.length; ++i) {
            boolean b = replaced[i];
            if (!b) continue;
            effectiveFormat.setFormat(i, null);
        }
        return effectiveFormat.format(parameters);
    }

    public static String formatWithReplace(MessageFormat format, Object[] inputValues, String nullString) {
        if (inputValues == null || format == null) {
            return null;
        }
        Object[] values = (Object[])inputValues.clone();
        boolean fastProcessingPossible = nullString == null;
        Format[] formats = format.getFormats();
        boolean fastProcessing = true;
        boolean[] replaced = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            Format currentFormat = formats[i];
            if (value == null) {
                values[i] = nullString;
                replaced[i] = currentFormat != null;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            if (currentFormat instanceof DateFormat) {
                if (value instanceof Date) {
                    values[i] = value;
                    replaced[i] = false;
                    continue;
                }
                values[i] = nullString;
                replaced[i] = true;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            if (currentFormat instanceof NumberFormat) {
                if (value instanceof Number) {
                    values[i] = value;
                    replaced[i] = false;
                    continue;
                }
                values[i] = nullString;
                replaced[i] = true;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                continue;
            }
            values[i] = value;
            replaced[i] = false;
        }
        if (fastProcessing) {
            return format.format(values);
        }
        MessageFormat effectiveFormat = (MessageFormat)format.clone();
        for (int i = 0; i < replaced.length; ++i) {
            boolean b = replaced[i];
            if (!b) continue;
            effectiveFormat.setFormat(i, null);
        }
        return effectiveFormat.format(values);
    }

    protected static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();
        private ArrayList completeFormatString = new ArrayList();

        public MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, ",", "\"");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String varName = tokenizer.nextToken();
            StringBuffer b = new StringBuffer();
            b.append("{");
            b.append(String.valueOf(this.fields.size()));
            while (tokenizer.hasMoreTokens()) {
                b.append(",");
                b.append(tokenizer.nextToken());
            }
            b.append("}");
            String formatString = b.toString();
            this.completeFormatString.add(formatString);
            this.fields.add(varName);
            return formatString;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }
    }
}

