/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.WorkerPool;
import org.jfree.util.Log;

public final class Worker
extends Thread {
    private Runnable workload;
    private volatile boolean finish;
    private WorkerPool workerPool;

    public Worker() {
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkload(Runnable r) {
        if (this.workload != null) {
            throw new IllegalStateException("This worker is not idle.");
        }
        Worker worker = this;
        synchronized (worker) {
            this.workload = r;
            this.notifyAll();
        }
    }

    public synchronized Runnable getWorkload() {
        return this.workload;
    }

    public void finish() {
        this.finish = true;
        try {
            this.interrupt();
            this.notifyAll();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.workerPool != null) {
            this.workerPool.workerFinished(this);
        }
    }

    public boolean isAvailable() {
        return this.workload == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (!this.finish) {
            if (this.workload != null) {
                try {
                    this.workload.run();
                }
                catch (Exception e) {
                    Log.error((Object)"Worker caught exception on run: ", (Exception)e);
                }
                this.workload = null;
                if (this.workerPool != null) {
                    this.workerPool.workerAvailable(this);
                }
            }
            Worker worker = this;
            synchronized (worker) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isFinish() {
        return this.finish;
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }
}

