/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ValueConverter;

public class ArrayValueConverter
implements ValueConverter {
    private ValueConverter elementConverter;
    private Class elementType;

    public ArrayValueConverter(Class arrayClass, ValueConverter elementConverter) {
        if (elementConverter == null) {
            throw new NullPointerException("elementConverter must not be null");
        }
        if (arrayClass == null) {
            throw new NullPointerException("arrayClass must not be null");
        }
        this.elementType = arrayClass;
        this.elementConverter = elementConverter;
    }

    public String toAttributeValue(Object o) throws BeanException {
        int size = Array.getLength(o);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(this.elementConverter.toAttributeValue(Array.get(o, i)));
        }
        return buffer.toString();
    }

    public Object toPropertyValue(String s) throws BeanException {
        CSVTokenizer tokenizer = new CSVTokenizer(s);
        ArrayList<Object> elements = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            elements.add(this.elementConverter.toPropertyValue(token));
        }
        Object retval = Array.newInstance(this.elementType, elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Object o = elements.get(i);
            Array.set(retval, i, o);
        }
        return retval;
    }
}

