/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;
import org.jfree.report.util.beans.ValueConverter;

public final class BeanUtility {
    private BeanInfo beanInfo;
    private Object bean;
    private HashMap properties;

    private BeanUtility() {
    }

    public BeanUtility(Object o) throws IntrospectionException {
        this.bean = o;
        this.beanInfo = Introspector.getBeanInfo(o.getClass());
        this.properties = new HashMap();
        PropertyDescriptor[] propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            this.properties.put(propertyDescriptors[i].getName(), propertyDescriptors[i]);
        }
    }

    public BeanUtility derive(Object o) {
        if (!o.getClass().equals(this.bean.getClass())) {
            throw new IllegalArgumentException();
        }
        BeanUtility bu = new BeanUtility();
        bu.bean = o;
        return bu;
    }

    public PropertyDescriptor[] getPropertyInfos() {
        return this.beanInfo.getPropertyDescriptors();
    }

    public Object getProperty(String name) throws BeanException {
        return this.getPropertyForSpecification(new PropertySpecification(name));
    }

    private Object getPropertyForSpecification(PropertySpecification name) throws BeanException {
        PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(name.getName());
        if (pd == null) {
            throw new BeanException("No such property:" + name);
        }
        if (pd instanceof IndexedPropertyDescriptor && name.getIndex() != null) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method readMethod = ipd.getIndexedReadMethod();
            if (readMethod == null) {
                throw new BeanException("Property is not readable: " + name);
            }
            try {
                return readMethod.invoke(this.bean, new Integer(name.getIndex()));
            }
            catch (Exception e) {
                throw new BeanException("InvokationError", e);
            }
        }
        Method readMethod = pd.getReadMethod();
        if (readMethod == null) {
            throw new BeanException("Property is not readable: " + name);
        }
        if (name.getIndex() != null) {
            try {
                Object value = readMethod.invoke(this.bean, null);
                if (value == null) {
                    throw new IndexOutOfBoundsException("No such index, property is null");
                }
                if (!value.getClass().isArray()) {
                    throw new BeanException("The property contains no array.");
                }
                int index = Integer.parseInt(name.getIndex());
                return Array.get(value, index);
            }
            catch (BeanException be) {
                throw be;
            }
            catch (IndexOutOfBoundsException iob) {
                throw iob;
            }
            catch (Exception e) {
                throw new BeanException("Failed to read indexed property.");
            }
        }
        try {
            return readMethod.invoke(this.bean, null);
        }
        catch (Exception e) {
            throw new BeanException("InvokationError", e);
        }
    }

    public String getPropertyAsString(String name) throws BeanException {
        PropertySpecification ps = new PropertySpecification(name);
        PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(ps.getName());
        if (pd == null) {
            throw new BeanException("No such property:" + name);
        }
        Object o = this.getPropertyForSpecification(ps);
        if (o == null) {
            return null;
        }
        ValueConverter vc = ConverterRegistry.getInstance().getValueConverter(o.getClass());
        if (vc == null) {
            throw new BeanException("Unable to handle property of type " + o.getClass().getName());
        }
        return vc.toAttributeValue(o);
    }

    public void setProperty(String name, Object o) throws BeanException {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.setProperty(new PropertySpecification(name), o);
    }

    private void setProperty(PropertySpecification name, Object o) throws BeanException {
        IndexedPropertyDescriptor ipd;
        Method writeMethod;
        PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(name.getName());
        if (pd == null) {
            throw new BeanException("No such property:" + name);
        }
        if (pd instanceof IndexedPropertyDescriptor && name.getIndex() != null && (writeMethod = (ipd = (IndexedPropertyDescriptor)pd).getIndexedWriteMethod()) != null) {
            try {
                writeMethod.invoke(this.bean, new Integer(name.getIndex()), o);
            }
            catch (Exception e) {
                throw new BeanException("InvokationError", e);
            }
            return;
        }
        Method writeMethod2 = pd.getWriteMethod();
        if (writeMethod2 == null) {
            throw new BeanException("Property is not writeable: " + name);
        }
        if (name.getIndex() != null) {
            this.updateArrayProperty(pd, name, o);
        } else {
            try {
                writeMethod2.invoke(this.bean, o);
            }
            catch (Exception e) {
                throw new BeanException("InvokationError", e);
            }
        }
    }

    private void updateArrayProperty(PropertyDescriptor pd, PropertySpecification name, Object o) throws BeanException {
        Method readMethod = pd.getReadMethod();
        if (readMethod == null) {
            throw new BeanException("Property is not readable, cannot perform array update: " + name);
        }
        try {
            Object value = readMethod.invoke(this.bean, null);
            int index = Integer.parseInt(name.getIndex());
            Object array = this.validateArray(BeanUtility.getPropertyType(pd), value, index);
            Array.set(array, index, o);
            Method writeMethod = pd.getWriteMethod();
            writeMethod.invoke(this.bean, array);
        }
        catch (BeanException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanException("Failed to read property, cannot perform array update: " + name);
        }
    }

    private Object validateArray(Class propertyType, Object o, int size) throws BeanException {
        if (!propertyType.isArray()) {
            throw new BeanException("The property's value is no array.");
        }
        if (o == null) {
            return Array.newInstance(propertyType.getComponentType(), size + 1);
        }
        if (!o.getClass().isArray()) {
            throw new BeanException("The property's value is no array.");
        }
        int length = Array.getLength(o);
        if (length > size) {
            return o;
        }
        Object retval = Array.newInstance(o.getClass().getComponentType(), size + 1);
        System.arraycopy(o, 0, retval, 0, length);
        return o;
    }

    public void setPropertyAsString(String name, String txt) throws BeanException {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (txt == null) {
            throw new NullPointerException("Text must not be null");
        }
        PropertySpecification ps = new PropertySpecification(name);
        PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(ps.getName());
        if (pd == null) {
            throw new BeanException("No such property:" + name);
        }
        this.setPropertyAsString(name, BeanUtility.getPropertyType(pd), txt);
    }

    public Class getPropertyType(String name) throws BeanException {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        PropertySpecification ps = new PropertySpecification(name);
        PropertyDescriptor pd = (PropertyDescriptor)this.properties.get(ps.getName());
        if (pd == null) {
            throw new BeanException("No such property:" + name);
        }
        return BeanUtility.getPropertyType(pd);
    }

    public static Class getPropertyType(PropertyDescriptor pd) throws BeanException {
        Class<?> typeFromDescriptor = pd.getPropertyType();
        if (typeFromDescriptor != null) {
            return typeFromDescriptor;
        }
        if (pd instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor idx = (IndexedPropertyDescriptor)pd;
            return idx.getIndexedPropertyType();
        }
        throw new BeanException("Unable to determine the property type.");
    }

    public void setPropertyAsString(String name, Class type, String txt) throws BeanException {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        if (txt == null) {
            throw new NullPointerException("Text must not be null");
        }
        PropertySpecification ps = new PropertySpecification(name);
        ValueConverter vc = ps.getIndex() != null && type.isArray() ? ConverterRegistry.getInstance().getValueConverter(type.getComponentType()) : ConverterRegistry.getInstance().getValueConverter(type);
        if (vc == null) {
            throw new BeanException("Unable to handle '" + type + "' for property '" + name + "'");
        }
        Object o = vc.toPropertyValue(txt);
        this.setProperty(ps, o);
    }

    public String[] getProperties() throws BeanException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        PropertyDescriptor[] pd = this.getPropertyInfos();
        for (int i = 0; i < pd.length; ++i) {
            PropertyDescriptor property = pd[i];
            if (property.isHidden() || property.getReadMethod() == null || property.getWriteMethod() == null) continue;
            if (BeanUtility.getPropertyType(property).isArray()) {
                int max = this.findMaximumIndex(property);
                for (int idx = 0; idx < max; ++idx) {
                    propertyNames.add(property.getName() + "[" + idx + "]");
                }
                continue;
            }
            propertyNames.add(property.getName());
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    private int findMaximumIndex(PropertyDescriptor id) {
        try {
            Object o = this.getPropertyForSpecification(new PropertySpecification(id.getName()));
            return Array.getLength(o);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static class PropertySpecification {
        private String raw;
        private String name;
        private String index;

        public PropertySpecification(String raw) {
            this.raw = raw;
            this.name = this.getNormalizedName(raw);
            this.index = this.getIndex(raw);
        }

        private String getNormalizedName(String property) {
            int idx = property.indexOf(91);
            if (idx < 0) {
                return property;
            }
            return property.substring(0, idx);
        }

        private String getIndex(String property) {
            int idx = property.indexOf(91);
            if (idx < 0) {
                return null;
            }
            int end = property.indexOf(93, idx + 1);
            if (end < 0) {
                return null;
            }
            return property.substring(idx + 1, end);
        }

        public String getRaw() {
            return this.raw;
        }

        public String getName() {
            return this.name;
        }

        public String getIndex() {
            return this.index;
        }

        public String toString() {
            StringBuffer b = new StringBuffer("PropertySpecification={");
            b.append("raw=");
            b.append(this.raw);
            b.append("}");
            return b.toString();
        }
    }
}

