/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int LINE_ICODE = 147;
    private static final int SOURCEFILE_ICODE = 148;
    private static final int SHORTNUMBER_ICODE = 149;
    private static final int INTNUMBER_ICODE = 150;
    private static final int RETURN_UNDEF_ICODE = 151;
    private static final int END_ICODE = 152;
    static PrintWriter out;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private VariableTable itsVariableTable;
    private int itsTryDepth = 0;
    private int itsStackDepth = 0;
    private String itsSourceFile;
    private int itsLineNumber = 0;
    private LabelTable itsLabels = new LabelTable();
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private String lastAddString;
    private int version;
    private boolean inLineStepMode;
    private String debugSource;
    private static final Object DBL_MRK;

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        return new NodeTransformer().transform(node, null, tokenStream, scriptable);
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecurityController securityController, ClassNameHelper classNameHelper) {
        this.version = context.getLanguageVersion();
        this.itsData = new InterpreterData(object);
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            this.itsData.itsFunctionType = functionNode.getFunctionType();
            this.generateFunctionICode(context, scriptable, functionNode);
            return Interpreter.createFunction(context, scriptable, this.itsData, false);
        }
        this.generateScriptICode(context, scriptable, node);
        return new InterpretedScript(context, this.itsData);
    }

    private void generateScriptICode(Context context, Scriptable scriptable, Node node) {
        this.itsData.itsSourceFile = this.itsSourceFile = (String)node.getProp(16);
        this.debugSource = (String)node.getProp(31);
        this.generateNestedFunctions(context, scriptable, node);
        this.generateRegExpLiterals(context, scriptable, node);
        this.itsVariableTable = (VariableTable)node.getProp(10);
        this.generateICodeFromTree(node);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, this.itsData, this.debugSource);
        }
    }

    private void generateFunctionICode(Context context, Scriptable scriptable, FunctionNode functionNode) {
        String string = this.debugSource;
        this.debugSource = (String)functionNode.getProp(31);
        if (this.debugSource == null) {
            this.debugSource = string;
        }
        this.generateNestedFunctions(context, scriptable, functionNode);
        this.generateRegExpLiterals(context, scriptable, functionNode);
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsVariableTable = functionNode.getVariableTable();
        this.generateICodeFromTree(functionNode.getLastChild());
        this.itsData.itsName = functionNode.getFunctionName();
        this.itsData.itsSourceFile = (String)functionNode.getProp(16);
        this.itsData.itsSource = (String)functionNode.getProp(17);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, this.itsData, this.debugSource);
        }
        this.debugSource = string;
    }

    private void generateNestedFunctions(Context context, Scriptable scriptable, Node node) {
        ObjArray objArray = (ObjArray)node.getProp(5);
        if (objArray == null) {
            return;
        }
        int n = objArray.size();
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = (FunctionNode)objArray.get(i);
            Interpreter interpreter = new Interpreter();
            interpreter.itsSourceFile = this.itsSourceFile;
            interpreter.itsData = new InterpreterData(this.itsData.securityDomain);
            interpreter.itsData.itsCheckThis = functionNode.getCheckThis();
            interpreter.itsData.itsFunctionType = functionNode.getFunctionType();
            interpreter.itsInFunctionFlag = true;
            interpreter.debugSource = this.debugSource;
            interpreter.generateFunctionICode(context, scriptable, functionNode);
            interpreterDataArray[i] = interpreter.itsData;
            functionNode.putIntProp(5, i);
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals(Context context, Scriptable scriptable, Node node) {
        ObjArray objArray = (ObjArray)node.getProp(12);
        if (objArray == null) {
            return;
        }
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        int n = objArray.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            Node node2 = (Node)objArray.get(i);
            Node node3 = node2.getFirstChild();
            Node node4 = node2.getLastChild();
            String string = node3.getString();
            String string2 = node3 != node4 ? node4.getString() : null;
            objectArray[i] = regExpProxy.newRegExp(context, scriptable, string, string2, false);
            node2.putIntProp(12, i);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        int n = 0;
        n = this.generateICode(node, n);
        this.itsLabels.fixLabelGotos(this.itsData.itsICode);
        if (this.itsData.itsFunctionType == 0) {
            n = this.addByte(152, n);
        }
        this.itsData.itsICodeTop = n;
        if (this.itsData.itsICode.length != n) {
            object = new byte[n];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, n);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n2 = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n2] != null) {
                    Context.codeBug();
                }
                this.itsData.itsStringTable[n2] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        this.itsData.itsMaxVars = this.itsVariableTable.size();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxTryDepth + this.itsData.itsMaxStack;
        this.itsData.argNames = new String[this.itsVariableTable.size()];
        this.itsVariableTable.getAllVariables(this.itsData.argNames);
        this.itsData.argCount = this.itsVariableTable.getParameterCount();
    }

    private int updateLineNumber(Node node, int n) {
        int n2 = node.getLineno();
        if (n2 != this.itsLineNumber && n2 >= 0) {
            this.itsLineNumber = n2;
            n = this.addByte(147, n);
            n = this.addShort(n2, n);
        }
        return n;
    }

    private void badTree(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    private int generateICode(Node node, int n) {
        Node node2;
        int n2 = node.getType();
        Node node3 = node2 = node.getFirstChild();
        block0 : switch (n2) {
            case 110: {
                FunctionNode functionNode = (FunctionNode)node.getProp(5);
                if (functionNode.itsFunctionType == 1) break;
                int n3 = functionNode.getExistingIntProp(5);
                n = this.addByte(55, n);
                n = this.addIndex(n3, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 146: {
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    if (node2.getType() != 110) {
                        n = this.generateICode(node2, n);
                    }
                    node2 = node2.getNext();
                }
                break;
            }
            case 116: {
                n = this.updateLineNumber(node, n);
                for (node2 = node2.getNext(); node2 != null; node2 = node2.getNext()) {
                    n = this.generateICode(node2, n);
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 96: {
                n = this.generateICode(node2, n);
                while (null != (node2 = node2.getNext())) {
                    n = this.addByte(57, n);
                    --this.itsStackDepth;
                    n = this.generateICode(node2, n);
                }
                break;
            }
            case 115: {
                Node node4;
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                int n4 = this.itsData.itsMaxLocals++;
                n = this.addByte(69, n);
                n = this.addByte(n4, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                ObjArray objArray = (ObjArray)node.getProp(13);
                for (int i = 0; i < objArray.size(); ++i) {
                    node4 = (Node)objArray.get(i);
                    Node node5 = node4.getFirstChild();
                    n = this.generateICode(node5, n);
                    n = this.addByte(70, n);
                    n = this.addByte(n4, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte(53, n);
                    --this.itsStackDepth;
                    Node node6 = new Node(137);
                    node4.addChildAfter(node6, node5);
                    n = this.addGoto(node6, 7, n);
                }
                Node node7 = (Node)node.getProp(14);
                if (node7 != null) {
                    node4 = new Node(137);
                    node7.getFirstChild().addChildToFront(node4);
                    n = this.addGoto(node4, 6, n);
                }
                node4 = (Node)node.getProp(2);
                n = this.addGoto(node4, 6, n);
                break;
            }
            case 137: {
                this.markTargetLabel(node, n);
                if (node.getProp(21) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 102: 
            case 103: {
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                int n5 = node.getOperation();
                if (this.version == 120) {
                    if (n5 == 14) {
                        n5 = 53;
                    } else if (n5 == 15) {
                        n5 = 54;
                    }
                }
                n = this.addByte(n5, n);
                --this.itsStackDepth;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.itsSourceFile == null || this.itsData.itsSourceFile != null && this.itsSourceFile.equals(this.itsData.itsSourceFile))) {
                    this.itsData.itsSourceFile = this.itsSourceFile;
                }
                n = this.addByte(148, n);
                int n6 = 0;
                String string = null;
                while (node2 != null) {
                    int n7;
                    n = this.generateICode(node2, n);
                    if (string == null && ((n7 = node2.getType()) == 44 || n7 == 39)) {
                        string = this.lastAddString;
                    }
                    node2 = node2.getNext();
                    ++n6;
                }
                if (node.getProp(30) != null) {
                    n = this.addByte(67, n);
                    n = this.addShort(this.itsLineNumber, n);
                    n = this.addString(this.itsSourceFile, n);
                } else {
                    n = this.addByte(n2, n);
                    n = this.addString(string, n);
                }
                this.itsStackDepth -= n6 - 1;
                n6 = n2 == 30 ? --n6 : (n6 -= 2);
                n = this.addIndex(n6, n);
                if (n6 > this.itsData.itsMaxCalleeArgs) {
                    this.itsData.itsMaxCalleeArgs = n6;
                }
                n = this.addByte(148, n);
                break;
            }
            case 69: 
            case 144: {
                n = this.generateICode(node2, n);
                n = this.addByte(69, n);
                n = this.addLocalRef(node, n);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    n = this.addByte(66, n);
                } else {
                    n = this.addByte(70, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node node8 = (Node)node.getProp(7);
                n = this.addLocalRef(node8, n);
                break;
            }
            case 70: {
                n = this.addByte(70, n);
                Node node9 = (Node)node.getProp(6);
                n = this.addLocalRef(node9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                n = this.generateICode(node2, n);
                --this.itsStackDepth;
            }
            case 6: {
                Node node10 = (Node)node.getProp(1);
                n = this.addGoto(node10, (byte)n2, n);
                break;
            }
            case 143: {
                Node node11 = (Node)node.getProp(1);
                node11.putProp(21, node);
                n = this.addGoto(node11, 65, n);
                break;
            }
            case 101: {
                n = this.generateICode(node2, n);
                n = this.addByte(9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n8 = n;
                n = this.addForwardGoto(8, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                this.resolveForwardGoto(n8, n);
                break;
            }
            case 100: {
                n = this.generateICode(node2, n);
                n = this.addByte(9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n9 = n;
                n = this.addForwardGoto(7, n);
                n = this.addByte(57, n);
                --this.itsStackDepth;
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                this.resolveForwardGoto(n9, n);
                break;
            }
            case 39: {
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte(81, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte(86, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addByte(39, n);
                --this.itsStackDepth;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 142: {
                n = this.generateICode(node2, n);
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    n = this.addByte(58, n);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 105: {
                n = this.generateICode(node2, n);
                switch (node.getOperation()) {
                    case 132: {
                        n = this.addByte(57, n);
                        n = this.addByte(74, n);
                        break block0;
                    }
                    case 129: {
                        int n10 = n;
                        n = this.addForwardGoto(7, n);
                        int n11 = n = this.addByte(52, n);
                        n = this.addForwardGoto(6, n);
                        this.resolveForwardGoto(n10, n);
                        n = this.addByte(51, n);
                        this.resolveForwardGoto(n11, n);
                        break block0;
                    }
                    case 28: {
                        n = this.addByte(28, n);
                        break block0;
                    }
                    case 32: {
                        n = this.addByte(32, n);
                        break block0;
                    }
                    case 24: {
                        n = this.addByte(29, n);
                        break block0;
                    }
                    case 23: {
                        n = this.addByte(58, n);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte(83, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte(84, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addByte(40, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addByte(10, n);
                n = this.addString(node3.getString(), n);
                --this.itsStackDepth;
                break;
            }
            case 32: {
                String string = node.getString();
                int n12 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n12 = this.itsVariableTable.getOrdinal(string);
                }
                if (n12 == -1) {
                    n = this.addByte(78, n);
                    n = this.addString(string, n);
                } else {
                    n = this.addByte(72, n);
                    n = this.addByte(n12, n);
                    n = this.addByte(32, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 141: {
                n = this.generateICode(node2, n);
                n = this.addByte(82, n);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                n = this.addByte(n2, n);
                n = this.addString(node.getString(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 106: 
            case 107: {
                int n13 = node2.getType();
                switch (n13) {
                    case 72: {
                        String string = node2.getString();
                        if (this.itsData.itsNeedsActivation) {
                            n = this.addByte(85, n);
                            n = this.addByte(46, n);
                            n = this.addString(string, n);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            n = this.addByte(n2 == 106 ? 34 : 37, n);
                            --this.itsStackDepth;
                            break;
                        }
                        int n14 = this.itsVariableTable.getOrdinal(string);
                        n = this.addByte(n2 == 106 ? 59 : 60, n);
                        n = this.addByte(n14, n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node node12 = node2.getFirstChild();
                        n = this.generateICode(node12, n);
                        node12 = node12.getNext();
                        n = this.generateICode(node12, n);
                        n = n13 == 39 ? this.addByte(n2 == 106 ? 34 : 37, n) : this.addByte(n2 == 106 ? 35 : 38, n);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        n = this.addByte(n2 == 106 ? 33 : 36, n);
                        n = this.addString(node2.getString(), n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double d = node.getDouble();
                int n15 = (int)d;
                if ((double)n15 == d) {
                    if (n15 == 0) {
                        n = this.addByte(47, n);
                    } else if (n15 == 1) {
                        n = this.addByte(48, n);
                    } else if ((short)n15 == n15) {
                        n = this.addByte(149, n);
                        n = this.addShort(n15, n);
                    } else {
                        n = this.addByte(150, n);
                        n = this.addInt(n15, n);
                    }
                } else {
                    n = this.addByte(45, n);
                    n = this.addDouble(d, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                n = this.updateLineNumber(node, n);
            }
            case 3: {
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 68: {
                n = this.generateICode(node2, n);
                n = this.addByte(n2, n);
                break;
            }
            case 77: {
                n = this.addByte(n2, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                n = this.addByte(n2, n);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node node13 = (Node)node.getProp(1);
                Node node14 = (Node)node.getProp(21);
                int n16 = n;
                if (node13 == null) {
                    n = this.addByte(75, n);
                    n = this.addShort(0, n);
                } else {
                    n = this.addGoto(node13, 75, n);
                }
                n = this.addShort(0, n);
                Node node15 = null;
                boolean bl = false;
                while (node2 != null) {
                    if (node13 != null && node15 == node13) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    Node node16 = node2.getNext();
                    if (!(bl || node16 == null || node16 != node13 && node16 != node14)) {
                        n = this.addByte(76, n);
                        bl = true;
                    }
                    n = this.generateICode(node2, n);
                    node15 = node2;
                    node2 = node2.getNext();
                }
                this.itsStackDepth = 0;
                if (node14 != null) {
                    int n17 = n;
                    n = this.addForwardGoto(6, n);
                    int n18 = n - n16;
                    this.recordJumpOffset(n16 + 3, n18);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int n19 = this.itsData.itsMaxLocals++;
                    n = this.addByte(69, n);
                    n = this.addByte(n19, n);
                    n = this.addByte(57, n);
                    n = this.addGoto(node14, 65, n);
                    n = this.addByte(70, n);
                    n = this.addByte(n19, n);
                    n = this.addByte(88, n);
                    this.itsStackDepth = 0;
                    this.resolveForwardGoto(n17, n);
                }
                --this.itsTryDepth;
                break;
            }
            case 62: {
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                n = this.addByte(62, n);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                n = this.updateLineNumber(node, n);
                if (node2 != null) {
                    n = this.generateICode(node2, n);
                    n = this.addByte(5, n);
                    --this.itsStackDepth;
                    break;
                }
                n = this.addByte(151, n);
                break;
            }
            case 72: {
                String string = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    n = this.addByte(85, n);
                    n = this.addByte(46, n);
                    n = this.addString(string, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte(39, n);
                    --this.itsStackDepth;
                    break;
                }
                int n20 = this.itsVariableTable.getOrdinal(string);
                n = this.addByte(72, n);
                n = this.addByte(n20, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    node2.setType(61);
                    node.setType(10);
                    n = this.generateICode(node, n);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                int n21 = this.itsVariableTable.getOrdinal(string);
                n = this.addByte(73, n);
                n = this.addByte(n21, n);
                break;
            }
            case 109: {
                n = this.addByte(node.getOperation(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                n = this.generateICode(node2, n);
                n = this.addByte(79, n);
                n = this.addLocalRef(node, n);
                --this.itsStackDepth;
                break;
            }
            case 80: {
                n = this.addByte(80, n);
                Node node17 = (Node)node.getProp(4);
                n = this.addLocalRef(node17, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                Node node18 = (Node)node.getProp(12);
                int n22 = node18.getExistingIntProp(12);
                n = this.addByte(56, n);
                n = this.addIndex(n22, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        return n;
    }

    private int addLocalRef(Node node, int n) {
        int n2 = node.getIntProp(7, -1);
        if (n2 == -1) {
            n2 = this.itsData.itsMaxLocals++;
            node.putIntProp(7, n2);
        }
        n = this.addByte(n2, n);
        if (n2 >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = n2 + 1;
        }
        return n;
    }

    private int getTargetLabel(Node node) {
        int n = node.getIntProp(20, -1);
        if (n == -1) {
            n = this.itsLabels.acquireLabel();
            node.putIntProp(20, n);
        }
        return n;
    }

    private void markTargetLabel(Node node, int n) {
        int n2 = this.getTargetLabel(node);
        this.itsLabels.markLabel(n2, n);
    }

    private int addGoto(Node node, int n, int n2) {
        int n3 = this.getTargetLabel(node);
        int n4 = n2;
        n2 = this.addByte(n, n2);
        n2 = this.addShort(0, n2);
        int n5 = this.itsLabels.getLabelPC(n3);
        if (n5 != -1) {
            this.recordJumpOffset(n4 + 1, n5 - n4);
        } else {
            this.itsLabels.addLabelFixup(n3, n4 + 1);
        }
        return n2;
    }

    private int addForwardGoto(int n, int n2) {
        n2 = this.addByte(n, n2);
        n2 = this.addShort(0, n2);
        return n2;
    }

    private void resolveForwardGoto(int n, int n2) {
        if (n + 3 > n2) {
            Context.codeBug();
        }
        int n3 = n2 - n;
        this.recordJumpOffset(n + 1, n3);
    }

    private void recordJumpOffset(int n, int n2) {
        if (n2 != (short)n2) {
            throw Context.reportRuntimeError0("msg.too.big.jump");
        }
        this.itsData.itsICode[n] = (byte)(n2 >> 8);
        this.itsData.itsICode[n + 1] = (byte)n2;
    }

    private int addByte(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 1);
        }
        byArray[n2++] = (byte)n;
        return n2;
    }

    private int addShort(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int addIndex(int n, int n2) {
        if (n < 0) {
            Context.codeBug();
        }
        if (n > 65535) {
            throw Context.reportRuntimeError0("msg.too.big.index");
        }
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int addInt(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        return n2 + 4;
    }

    private int addDouble(double d, int n) {
        int n2 = this.itsDoubleTableTop;
        if (n2 == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n2) {
            double[] dArray = new double[n2 * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n2);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n2] = d;
        this.itsDoubleTableTop = n2 + 1;
        n = this.addIndex(n2, n);
        return n;
    }

    private int addString(String string, int n) {
        int n2 = this.itsStrings.get(string, -1);
        if (n2 == -1) {
            n2 = this.itsStrings.size();
            this.itsStrings.put(string, n2);
        }
        n = this.addIndex(n2, n);
        this.lastAddString = string;
        return n;
    }

    private byte[] increaseICodeCapasity(int n, int n2) {
        int n3 = this.itsData.itsICode.length;
        if (n + n2 <= n3) {
            Context.codeBug();
        }
        if (n + n2 > (n3 *= 2)) {
            n3 = n + n2;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getTarget(byte[] byArray, int n) {
        int n2 = Interpreter.getShort(byArray, n);
        return n - 1 + n2;
    }

    private static String icodeToName(int n) {
        return "";
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int icodeTokenLength(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 74: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 148: 
            case 151: 
            case 152: {
                return 1;
            }
            case 6: 
            case 7: 
            case 8: 
            case 65: {
                return 3;
            }
            case 75: {
                return 5;
            }
            case 59: 
            case 60: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 79: 
            case 80: {
                return 2;
            }
            case 67: {
                return 7;
            }
            case 56: {
                return 3;
            }
            case 55: {
                return 3;
            }
            case 30: 
            case 43: {
                return 5;
            }
            case 149: {
                return 3;
            }
            case 150: {
                return 5;
            }
            case 45: {
                return 3;
            }
            case 10: 
            case 33: 
            case 36: 
            case 44: 
            case 46: 
            case 61: 
            case 71: 
            case 78: {
                return 3;
            }
            case 147: {
                return 3;
            }
        }
        Context.codeBug();
        return 0;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        int n2 = interpreterData.itsICodeTop;
        byte[] byArray = interpreterData.itsICode;
        for (int i = 0; i != n2; i += n) {
            int n3 = byArray[i] & 0xFF;
            n = Interpreter.icodeTokenLength(n3);
            if (n3 != 147) continue;
            if (n != 3) {
                Context.codeBug();
            }
            int n4 = Interpreter.getShort(byArray, i + 1);
            uintMap.put(n4, 0);
        }
        return uintMap.getKeys();
    }

    static Object getSourcesTree(InterpreterData interpreterData) {
        InterpreterData[] interpreterDataArray = interpreterData.itsNestedFunctions;
        if (interpreterDataArray == null || interpreterDataArray.length == 0) {
            return interpreterData.itsSource;
        }
        int n = interpreterDataArray.length;
        Object[] objectArray = new Object[n + 1];
        objectArray[0] = interpreterData.itsSource;
        for (int i = 0; i != n; ++i) {
            objectArray[1 + i] = Interpreter.getSourcesTree(interpreterDataArray[i]);
        }
        return objectArray;
    }

    private static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, boolean bl) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(context, interpreterData);
        if (context.hasCompileFunctionsWithDynamicScope() && !(scriptable instanceof NativeCall) && !(scriptable instanceof NativeWith)) {
            interpretedFunction.itsUseDynamicScope = true;
        }
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction, interpreterData.itsFunctionType, bl);
        return interpretedFunction;
    }

    static Object interpret(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, NativeFunction nativeFunction, InterpreterData interpreterData) throws JavaScriptException {
        int n3;
        Object object;
        Object object2;
        int n4;
        if (context.interpreterSecurityDomain != interpreterData.securityDomain) {
            return Interpreter.execWithNewDomain(context, scriptable, scriptable2, objectArray, dArray, n, n2, nativeFunction, interpreterData);
        }
        Object object3 = DBL_MRK;
        Scriptable scriptable3 = Undefined.instance;
        int n5 = interpreterData.itsMaxFrameArray;
        int n6 = interpreterData.itsMaxVars;
        int n7 = 0 + n6;
        int n8 = n7 + interpreterData.itsMaxLocals;
        int n9 = n8 + interpreterData.itsMaxTryDepth;
        if (n5 != n9 + interpreterData.itsMaxStack) {
            Context.codeBug();
        }
        Object[] objectArray2 = new Object[n5];
        double[] dArray2 = new double[n5];
        int n10 = n9 - 1;
        int n11 = 0;
        int n12 = nativeFunction.argCount;
        if (n12 > n2) {
            n12 = n2;
        }
        for (n4 = 0; n4 != n12; ++n4) {
            objectArray2[0 + n4] = object2 = objectArray[n + n4];
            if (object2 != object3) continue;
            dArray2[0 + n4] = dArray[n + n4];
        }
        for (n4 = n12; n4 != n6; ++n4) {
            objectArray2[0 + n4] = scriptable3;
        }
        DebugFrame debugFrame = null;
        if (context.debugger != null) {
            debugFrame = context.debugger.getFrame(context, interpreterData);
        }
        if (interpreterData.itsFunctionType != 0) {
            object2 = (InterpretedFunction)nativeFunction;
            if (!((InterpretedFunction)object2).itsUseDynamicScope) {
                scriptable = nativeFunction.getParentScope();
            }
            if (interpreterData.itsCheckThis) {
                scriptable2 = ScriptRuntime.getThis(scriptable2);
            }
            if (interpreterData.itsNeedsActivation) {
                if (dArray != null) {
                    objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
                    n = 0;
                    dArray = null;
                }
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
        } else {
            scriptable = ScriptRuntime.initScript(context, scriptable, nativeFunction, scriptable2, interpreterData.itsFromEvalCode);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Context.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                object = interpreterData.itsNestedFunctions[i];
                if (((InterpreterData)object).itsFunctionType != 1) continue;
                Interpreter.createFunction(context, scriptable, (InterpreterData)object, interpreterData.itsFromEvalCode);
            }
        }
        boolean bl = false;
        if (debugFrame != null) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
                n = 0;
                dArray = null;
            }
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                bl = true;
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
            debugFrame.onEnter(context, scriptable, scriptable2, objectArray);
        }
        object = scriptable3;
        byte[] byArray = interpreterData.itsICode;
        String[] stringArray = interpreterData.itsStringTable;
        int n13 = n3 = 0;
        int n14 = context.instructionThreshold;
        int n15 = context.instructionCount;
        block100: while (true) {
            Object object4;
            try {
                block101: while (true) {
                    switch (byArray[n3] & 0xFF) {
                        case 76: {
                            --n11;
                            break;
                        }
                        case 75: {
                            objectArray2[n8 + n11] = scriptable;
                            dArray2[n8 + n11] = n3;
                            ++n11;
                            n3 += 4;
                            break;
                        }
                        case 19: {
                            boolean bl2;
                            Object object5 = objectArray2[--n10 + 1];
                            Object object6 = objectArray2[n10];
                            if (object5 == object3 || object6 == object3) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n10 + 1);
                                double d2 = Interpreter.stack_double(objectArray2, dArray2, n10);
                                bl2 = d == d && d2 == d2 && d <= d2;
                            } else {
                                bl2 = 1 == ScriptRuntime.cmp_LE(object5, object6);
                            }
                            objectArray2[n10] = bl2 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 17: {
                            boolean bl3;
                            Object object7 = objectArray2[--n10 + 1];
                            Object object8 = objectArray2[n10];
                            if (object7 == object3 || object8 == object3) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n10 + 1);
                                double d3 = Interpreter.stack_double(objectArray2, dArray2, n10);
                                bl3 = d == d && d3 == d3 && d3 <= d;
                            } else {
                                bl3 = 1 == ScriptRuntime.cmp_LE(object8, object7);
                            }
                            objectArray2[n10] = bl3 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 18: {
                            boolean bl4;
                            Object object9 = objectArray2[--n10 + 1];
                            Object object10 = objectArray2[n10];
                            if (object9 == object3 || object10 == object3) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n10 + 1);
                                double d4 = Interpreter.stack_double(objectArray2, dArray2, n10);
                                bl4 = d == d && d4 == d4 && d < d4;
                            } else {
                                bl4 = 1 == ScriptRuntime.cmp_LT(object9, object10);
                            }
                            objectArray2[n10] = bl4 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 16: {
                            boolean bl5;
                            Object object11 = objectArray2[--n10 + 1];
                            Object object12 = objectArray2[n10];
                            if (object11 == object3 || object12 == object3) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n10 + 1);
                                double d5 = Interpreter.stack_double(objectArray2, dArray2, n10);
                                bl5 = d == d && d5 == d5 && d5 < d;
                            } else {
                                bl5 = 1 == ScriptRuntime.cmp_LT(object12, object11);
                            }
                            objectArray2[n10] = bl5 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 63: {
                            boolean bl6;
                            Object object13;
                            Object object14 = objectArray2[n10];
                            if (object14 == object3) {
                                object14 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object13 = objectArray2[--n10]) == object3) {
                                object13 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = (bl6 = ScriptRuntime.in(object13, object14, scriptable)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 64: {
                            boolean bl7;
                            Object object15;
                            Object object16 = objectArray2[n10];
                            if (object16 == object3) {
                                object16 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object15 = objectArray2[--n10]) == object3) {
                                object15 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = (bl7 = ScriptRuntime.instanceOf(scriptable, object15, object16)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 14: {
                            boolean bl8 = Interpreter.do_eq(objectArray2, dArray2, --n10);
                            objectArray2[n10] = bl8 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 15: {
                            boolean bl9 = !Interpreter.do_eq(objectArray2, dArray2, --n10);
                            objectArray2[n10] = bl9 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 53: {
                            boolean bl10 = Interpreter.do_sheq(objectArray2, dArray2, --n10);
                            objectArray2[n10] = bl10 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 54: {
                            boolean bl11 = !Interpreter.do_sheq(objectArray2, dArray2, --n10);
                            objectArray2[n10] = bl11 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 8: {
                            double d;
                            Object object17 = objectArray2[n10];
                            boolean bl12 = object17 != object3 ? !ScriptRuntime.toBoolean(object17) : (d = dArray2[n10]) != d || d == 0.0;
                            --n10;
                            if (bl12) {
                                if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                    context.observeInstructionCount(n15);
                                    n15 = 0;
                                }
                                n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                                continue block101;
                            }
                            n3 += 2;
                            break;
                        }
                        case 7: {
                            double d;
                            Object object18 = objectArray2[n10];
                            boolean bl13 = object18 != object3 ? ScriptRuntime.toBoolean(object18) : (d = dArray2[n10]) == d && d != 0.0;
                            --n10;
                            if (bl13) {
                                if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                    context.observeInstructionCount(n15);
                                    n15 = 0;
                                }
                                n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                                continue block101;
                            }
                            n3 += 2;
                            break;
                        }
                        case 6: {
                            if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                            continue block101;
                        }
                        case 65: {
                            dArray2[++n10] = n3 + 3;
                            if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                            continue block101;
                        }
                        case 66: {
                            int n16 = byArray[n3 + 1] & 0xFF;
                            if (n14 != 0 && (n15 += n3 + 2 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = (int)dArray2[n7 + n16];
                            continue block101;
                        }
                        case 57: {
                            --n10;
                            break;
                        }
                        case 9: {
                            objectArray2[n10 + 1] = objectArray2[n10];
                            dArray2[n10 + 1] = dArray2[n10];
                            ++n10;
                            break;
                        }
                        case 2: {
                            object = objectArray2[n10];
                            if (object == object3) {
                                object = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            --n10;
                            break;
                        }
                        case 5: {
                            object = objectArray2[n10];
                            if (object == object3) {
                                object = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            --n10;
                            break block100;
                        }
                        case 151: {
                            object = scriptable3;
                            break block100;
                        }
                        case 152: {
                            break block100;
                        }
                        case 28: {
                            int n17 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = ~n17;
                            break;
                        }
                        case 13: {
                            int n18 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            int n19 = Interpreter.stack_int32(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = n19 & n18;
                            break;
                        }
                        case 11: {
                            int n20 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            int n21 = Interpreter.stack_int32(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = n21 | n20;
                            break;
                        }
                        case 12: {
                            int n22 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            int n23 = Interpreter.stack_int32(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = n23 ^ n22;
                            break;
                        }
                        case 20: {
                            int n24 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            int n25 = Interpreter.stack_int32(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = n25 << n24;
                            break;
                        }
                        case 21: {
                            int n26 = Interpreter.stack_int32(objectArray2, dArray2, n10);
                            int n27 = Interpreter.stack_int32(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = n27 >> n26;
                            break;
                        }
                        case 22: {
                            int n28 = Interpreter.stack_int32(objectArray2, dArray2, n10) & 0x1F;
                            double d = Interpreter.stack_double(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = ScriptRuntime.toUint32(d) >>> n28;
                            break;
                        }
                        case 23: {
                            Interpreter.do_add(objectArray2, dArray2, --n10);
                            break;
                        }
                        case 24: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            double d6 = Interpreter.stack_double(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = d6 - d;
                            break;
                        }
                        case 29: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = -d;
                            break;
                        }
                        case 58: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = d;
                            break;
                        }
                        case 25: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            double d7 = Interpreter.stack_double(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = d7 * d;
                            break;
                        }
                        case 26: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            double d8 = Interpreter.stack_double(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = d8 / d;
                            break;
                        }
                        case 27: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n10);
                            double d9 = Interpreter.stack_double(objectArray2, dArray2, --n10);
                            objectArray2[n10] = object3;
                            dArray2[n10] = d9 % d;
                            break;
                        }
                        case 61: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.bind(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 71: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.getBase(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 10: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            Object object19 = objectArray2[n10];
                            if (object19 == object3) {
                                object19 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            Scriptable scriptable4 = (Scriptable)objectArray2[--n10];
                            objectArray2[n10] = ScriptRuntime.setName(scriptable4, object19, scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 31: {
                            Object object20;
                            Object object21 = objectArray2[n10];
                            if (object21 == object3) {
                                object21 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object20 = objectArray2[--n10]) == object3) {
                                object20 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.delete(object20, object21);
                            break;
                        }
                        case 39: {
                            String string = (String)objectArray2[n10];
                            Object object22 = objectArray2[--n10];
                            if (object22 == object3) {
                                object22 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.getProp(object22, string, scriptable);
                            break;
                        }
                        case 40: {
                            Object object23;
                            Object object24 = objectArray2[n10];
                            if (object24 == object3) {
                                object24 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            String string = (String)objectArray2[--n10];
                            if ((object23 = objectArray2[--n10]) == object3) {
                                object23 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.setProp(object23, string, object24, scriptable);
                            break;
                        }
                        case 41: {
                            Interpreter.do_getElem(context, objectArray2, dArray2, n10, scriptable);
                            --n10;
                            break;
                        }
                        case 42: {
                            Interpreter.do_setElem(context, objectArray2, dArray2, n10, scriptable);
                            n10 -= 2;
                            break;
                        }
                        case 34: {
                            String string = (String)objectArray2[n10];
                            Object object25 = objectArray2[--n10];
                            if (object25 == object3) {
                                object25 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.postIncrement(object25, string, scriptable);
                            break;
                        }
                        case 37: {
                            String string = (String)objectArray2[n10];
                            Object object26 = objectArray2[--n10];
                            if (object26 == object3) {
                                object26 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.postDecrement(object26, string, scriptable);
                            break;
                        }
                        case 35: {
                            Object object27;
                            Object object28 = objectArray2[n10];
                            if (object28 == object3) {
                                object28 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object27 = objectArray2[--n10]) == object3) {
                                object27 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.postIncrementElem(object27, object28, scriptable);
                            break;
                        }
                        case 38: {
                            Object object29;
                            Object object30 = objectArray2[n10];
                            if (object30 == object3) {
                                object30 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object29 = objectArray2[--n10]) == object3) {
                                object29 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.postDecrementElem(object29, object30, scriptable);
                            break;
                        }
                        case 68: {
                            Scriptable scriptable5 = (Scriptable)objectArray2[n10];
                            objectArray2[n10] = ScriptRuntime.getThis(scriptable5);
                            break;
                        }
                        case 69: {
                            int n29 = byArray[++n3] & 0xFF;
                            objectArray2[n7 + n29] = objectArray2[n10];
                            dArray2[n7 + n29] = dArray2[n10];
                            break;
                        }
                        case 70: {
                            int n30 = byArray[++n3] & 0xFF;
                            objectArray2[++n10] = objectArray2[n7 + n30];
                            dArray2[n10] = dArray2[n7 + n30];
                            break;
                        }
                        case 67: {
                            Object object31;
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            int n31 = Interpreter.getShort(byArray, n3 + 1);
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 3)];
                            int n32 = Interpreter.getIndex(byArray, n3 + 5);
                            Object[] objectArray3 = Interpreter.getArgsArray(objectArray2, dArray2, (n10 -= n32) + 1, n32);
                            Object object32 = objectArray2[n10];
                            if (object32 == object3) {
                                object32 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object31 = objectArray2[--n10]) == object3) {
                                object31 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.callSpecial(context, object31, object32, objectArray3, scriptable2, scriptable, string, n31);
                            n3 += 6;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 43: {
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            context.instructionCount = n15;
                            int n33 = Interpreter.getIndex(byArray, n3 + 3);
                            int n34 = (n10 -= n33) + 1;
                            Object object33 = objectArray2[n10];
                            if (object33 == object3) {
                                object33 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            Object object34 = objectArray2[--n10];
                            Object object32 = scriptable;
                            if (interpreterData.itsNeedsActivation) {
                                object32 = ScriptableObject.getTopLevelScope(scriptable);
                            }
                            Scriptable scriptable6 = object33 instanceof Scriptable || object33 == null ? (Scriptable)object33 : ScriptRuntime.toObject(context, (Scriptable)object32, object33);
                            if (object34 instanceof InterpretedFunction) {
                                object4 = (InterpretedFunction)object34;
                                objectArray2[n10] = Interpreter.interpret(context, (Scriptable)object32, scriptable6, objectArray2, dArray2, n34, n33, (NativeFunction)object4, ((InterpretedFunction)object4).itsData);
                            } else if (object34 instanceof Function) {
                                object4 = (Function)object34;
                                Object[] objectArray4 = Interpreter.getArgsArray(objectArray2, dArray2, n34, n33);
                                objectArray2[n10] = object4.call(context, (Scriptable)object32, scriptable6, objectArray4);
                            } else {
                                if (object34 == object3) {
                                    object34 = Interpreter.doubleWrap(dArray2[n10]);
                                } else if (object34 == scriptable3 && (object34 = stringArray[Interpreter.getIndex(byArray, n3 + 1)]) == null) {
                                    object34 = scriptable3;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object34), object32);
                            }
                            n3 += 4;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 30: {
                            Function function;
                            Object object32;
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            int n35 = Interpreter.getIndex(byArray, n3 + 3);
                            int n36 = (n10 -= n35) + 1;
                            Object object35 = objectArray2[n10];
                            if (object35 instanceof InterpretedFunction) {
                                function = (InterpretedFunction)object35;
                                object32 = ((BaseFunction)function).createObject(context, scriptable);
                                Object object36 = Interpreter.interpret(context, scriptable, (Scriptable)object32, objectArray2, dArray2, n36, n35, (NativeFunction)function, ((InterpretedFunction)function).itsData);
                                objectArray2[n10] = object36 instanceof Scriptable && object36 != scriptable3 ? object36 : object32;
                            } else if (object35 instanceof Function) {
                                function = (Function)object35;
                                object32 = Interpreter.getArgsArray(objectArray2, dArray2, n36, n35);
                                objectArray2[n10] = function.construct(context, scriptable, (Object[])object32);
                            } else {
                                if (object35 == object3) {
                                    object35 = Interpreter.doubleWrap(dArray2[n10]);
                                } else if (object35 == scriptable3 && (object35 = stringArray[Interpreter.getIndex(byArray, n3 + 1)]) == null) {
                                    object35 = scriptable3;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object35), scriptable);
                            }
                            n3 += 4;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 32: {
                            Object object37 = objectArray2[n10];
                            if (object37 == object3) {
                                object37 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.typeof(object37);
                            break;
                        }
                        case 78: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.typeofName(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 46: {
                            objectArray2[++n10] = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            n3 += 2;
                            break;
                        }
                        case 149: {
                            objectArray2[++n10] = object3;
                            dArray2[n10] = Interpreter.getShort(byArray, n3 + 1);
                            n3 += 2;
                            break;
                        }
                        case 150: {
                            objectArray2[++n10] = object3;
                            dArray2[n10] = Interpreter.getInt(byArray, n3 + 1);
                            n3 += 4;
                            break;
                        }
                        case 45: {
                            objectArray2[++n10] = object3;
                            dArray2[n10] = interpreterData.itsDoubleTable[Interpreter.getIndex(byArray, n3 + 1)];
                            n3 += 2;
                            break;
                        }
                        case 44: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.name(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 33: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.postIncrement(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 36: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n10] = ScriptRuntime.postDecrement(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 73: {
                            int n37 = byArray[++n3] & 0xFF;
                            if (!bl) {
                                objectArray2[0 + n37] = objectArray2[n10];
                                dArray2[0 + n37] = dArray2[n10];
                                break;
                            }
                            Object object38 = objectArray2[n10];
                            if (object38 == object3) {
                                object38 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            Interpreter.activationPut(nativeFunction, scriptable, n37, object38);
                            break;
                        }
                        case 72: {
                            int n38 = byArray[++n3] & 0xFF;
                            ++n10;
                            if (!bl) {
                                objectArray2[n10] = objectArray2[0 + n38];
                                dArray2[n10] = dArray2[0 + n38];
                                break;
                            }
                            objectArray2[n10] = Interpreter.activationGet(nativeFunction, scriptable, n38);
                            break;
                        }
                        case 59: {
                            Object object39;
                            int n39 = byArray[++n3] & 0xFF;
                            ++n10;
                            if (!bl) {
                                objectArray2[n10] = objectArray2[0 + n39];
                                dArray2[n10] = dArray2[0 + n39];
                                objectArray2[0 + n39] = object3;
                                dArray2[0 + n39] = Interpreter.stack_double(objectArray2, dArray2, n10) + 1.0;
                                break;
                            }
                            objectArray2[n10] = object39 = Interpreter.activationGet(nativeFunction, scriptable, n39);
                            object39 = Interpreter.doubleWrap(ScriptRuntime.toNumber(object39) + 1.0);
                            Interpreter.activationPut(nativeFunction, scriptable, n39, object39);
                            break;
                        }
                        case 60: {
                            Object object40;
                            int n40 = byArray[++n3] & 0xFF;
                            ++n10;
                            if (!bl) {
                                objectArray2[n10] = objectArray2[0 + n40];
                                dArray2[n10] = dArray2[0 + n40];
                                objectArray2[0 + n40] = object3;
                                dArray2[0 + n40] = Interpreter.stack_double(objectArray2, dArray2, n10) - 1.0;
                                break;
                            }
                            objectArray2[n10] = object40 = Interpreter.activationGet(nativeFunction, scriptable, n40);
                            object40 = Interpreter.doubleWrap(ScriptRuntime.toNumber(object40) - 1.0);
                            Interpreter.activationPut(nativeFunction, scriptable, n40, object40);
                            break;
                        }
                        case 47: {
                            objectArray2[++n10] = object3;
                            dArray2[n10] = 0.0;
                            break;
                        }
                        case 48: {
                            objectArray2[++n10] = object3;
                            dArray2[n10] = 1.0;
                            break;
                        }
                        case 49: {
                            objectArray2[++n10] = null;
                            break;
                        }
                        case 50: {
                            objectArray2[++n10] = scriptable2;
                            break;
                        }
                        case 87: {
                            objectArray2[++n10] = nativeFunction;
                            break;
                        }
                        case 51: {
                            objectArray2[++n10] = Boolean.FALSE;
                            break;
                        }
                        case 52: {
                            objectArray2[++n10] = Boolean.TRUE;
                            break;
                        }
                        case 74: {
                            objectArray2[++n10] = Undefined.instance;
                            break;
                        }
                        case 62: {
                            Object object41 = objectArray2[n10];
                            if (object41 == object3) {
                                object41 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            --n10;
                            throw new JavaScriptException(object41);
                        }
                        case 88: {
                            Object object42 = objectArray2[n10];
                            --n10;
                            if (object42 instanceof JavaScriptException) {
                                throw (JavaScriptException)object42;
                            }
                            throw (RuntimeException)object42;
                        }
                        case 3: {
                            Object object43 = objectArray2[n10];
                            if (object43 == object3) {
                                object43 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            --n10;
                            scriptable = ScriptRuntime.enterWith(object43, scriptable);
                            break;
                        }
                        case 4: {
                            scriptable = ScriptRuntime.leaveWith(scriptable);
                            break;
                        }
                        case 77: {
                            objectArray2[++n10] = ScriptRuntime.newScope();
                            break;
                        }
                        case 79: {
                            int n41 = byArray[++n3] & 0xFF;
                            Object object44 = objectArray2[n10];
                            if (object44 == object3) {
                                object44 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            --n10;
                            objectArray2[n7 + n41] = ScriptRuntime.initEnum(object44, scriptable);
                            break;
                        }
                        case 80: {
                            int n42 = byArray[++n3] & 0xFF;
                            Object object45 = objectArray2[n7 + n42];
                            objectArray2[++n10] = ScriptRuntime.nextEnum(object45);
                            break;
                        }
                        case 81: {
                            Object object46 = objectArray2[n10];
                            if (object46 == object3) {
                                object46 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.getProto(object46, scriptable);
                            break;
                        }
                        case 82: {
                            Object object47 = objectArray2[n10];
                            if (object47 == object3) {
                                object47 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.getParent(object47);
                            break;
                        }
                        case 86: {
                            Object object48 = objectArray2[n10];
                            if (object48 == object3) {
                                object48 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.getParent(object48, scriptable);
                            break;
                        }
                        case 83: {
                            Object object49;
                            Object object50 = objectArray2[n10];
                            if (object50 == object3) {
                                object50 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object49 = objectArray2[--n10]) == object3) {
                                object49 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.setProto(object49, object50, scriptable);
                            break;
                        }
                        case 84: {
                            Object object51;
                            Object object52 = objectArray2[n10];
                            if (object52 == object3) {
                                object52 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            if ((object51 = objectArray2[--n10]) == object3) {
                                object51 = Interpreter.doubleWrap(dArray2[n10]);
                            }
                            objectArray2[n10] = ScriptRuntime.setParent(object51, object52, scriptable);
                            break;
                        }
                        case 85: {
                            objectArray2[++n10] = scriptable;
                            break;
                        }
                        case 55: {
                            int n43 = Interpreter.getIndex(byArray, n3 + 1);
                            InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[n43];
                            objectArray2[++n10] = Interpreter.createFunction(context, scriptable, interpreterData2, interpreterData.itsFromEvalCode);
                            n3 += 2;
                            break;
                        }
                        case 56: {
                            int n44 = Interpreter.getIndex(byArray, n3 + 1);
                            objectArray2[++n10] = interpreterData.itsRegExpLiterals[n44];
                            n3 += 2;
                            break;
                        }
                        case 148: {
                            context.interpreterSourceFile = interpreterData.itsSourceFile;
                            break;
                        }
                        case 147: {
                            int n45;
                            context.interpreterLine = n45 = Interpreter.getShort(byArray, n3 + 1);
                            if (debugFrame != null) {
                                debugFrame.onLineChange(context, n45);
                            }
                            n3 += 2;
                            break;
                        }
                        default: {
                            Interpreter.dumpICode(interpreterData);
                            throw new RuntimeException("Unknown icode : " + (byArray[n3] & 0xFF) + " @ pc : " + n3);
                        }
                    }
                    ++n3;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                int n46;
                block209: {
                    block210: {
                        if (n14 != 0) {
                            if (n15 < 0) {
                                n15 = context.instructionCount;
                            } else {
                                context.instructionCount = n15 += n3 - n13;
                            }
                        }
                        object4 = throwable;
                        while (true) {
                            Object object53;
                            if (object4 instanceof JavaScriptException) {
                                object4 = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)object4);
                                n46 = 0;
                                break block209;
                            }
                            if (object4 instanceof EcmaError) {
                                object4 = ((EcmaError)object4).getErrorObject();
                                n46 = 1;
                                break block209;
                            }
                            if (!(object4 instanceof RuntimeException)) break block210;
                            if (!(object4 instanceof WrappedException) || !((object53 = ((WrappedException)object4).unwrap()) instanceof Throwable)) break;
                            throwable2 = (Throwable)object53;
                            object4 = throwable2;
                        }
                        object4 = null;
                        n46 = 2;
                        break block209;
                    }
                    object4 = null;
                    n46 = 3;
                }
                if (n46 != 3 && debugFrame != null) {
                    debugFrame.onExceptionThrown(context, throwable2);
                }
                boolean bl14 = true;
                if (n46 != 3 && n11 > 0) {
                    int n47;
                    int n48 = (int)dArray2[n8 + --n11];
                    if ((n46 == 0 || n46 == 1) && (n47 = Interpreter.getShort(byArray, n48 + 1)) != 0) {
                        bl14 = false;
                        n3 = n48 + n47;
                        n10 = n9;
                        objectArray2[n10] = object4;
                    }
                    if (bl14 && (n47 = Interpreter.getShort(byArray, n48 + 3)) != 0) {
                        bl14 = false;
                        n3 = n48 + n47;
                        n10 = n9;
                        objectArray2[n10] = throwable2;
                    }
                }
                if (bl14) {
                    if (debugFrame != null) {
                        debugFrame.onExit(context, true, throwable2);
                    }
                    if (interpreterData.itsNeedsActivation) {
                        ScriptRuntime.popActivation(context);
                    }
                    if (n46 == 0) {
                        throw (JavaScriptException)throwable2;
                    }
                    if (n46 == 1 || n46 == 2) {
                        throw (RuntimeException)throwable2;
                    }
                    throw (Error)throwable2;
                }
                if (n14 != 0 && n15 > n14) {
                    context.observeInstructionCount(n15);
                    n15 = 0;
                }
                n13 = n3;
                scriptable = (Scriptable)objectArray2[n8 + n11];
                continue;
            }
            break;
        }
        if (debugFrame != null) {
            debugFrame.onExit(context, false, object);
        }
        if (interpreterData.itsNeedsActivation) {
            ScriptRuntime.popActivation(context);
        }
        if (n14 != 0) {
            if (n15 > n14) {
                context.observeInstructionCount(n15);
                n15 = 0;
            }
            context.instructionCount = n15;
        }
        return object;
    }

    private static Object doubleWrap(double d) {
        return new Double(d);
    }

    private static int stack_int32(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toInt32(object) : ScriptRuntime.toInt32(dArray[n]);
    }

    private static double stack_double(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toNumber(object) : dArray[n];
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
            } else {
                Interpreter.do_add(object2, d, objectArray, dArray, n, true);
            }
        } else if (object2 == DBL_MRK) {
            Interpreter.do_add(object, dArray[n], objectArray, dArray, n, false);
        } else {
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(null);
            }
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            if (object2 instanceof String || object instanceof String) {
                objectArray[n] = ScriptRuntime.toString(object2) + ScriptRuntime.toString(object);
            } else {
                double d = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = DBL_MRK;
                dArray[n] = d + d2;
            }
        }
    }

    private static void do_add(Object object, double d, Object[] objectArray, double[] dArray, int n, boolean bl) {
        if (object instanceof Scriptable) {
            object = object == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)object).getDefaultValue(null);
        }
        if (object instanceof String) {
            objectArray[n] = bl ? (String)object + ScriptRuntime.toString(d) : ScriptRuntime.toString(d) + (String)object;
        } else {
            double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
            objectArray[n] = DBL_MRK;
            dArray[n] = d2 + d;
        }
    }

    private static boolean do_eq(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        boolean bl = object == DBL_MRK ? (object2 == DBL_MRK ? dArray[n] == dArray[n + 1] : Interpreter.do_eq(dArray[n + 1], object2)) : (object2 == DBL_MRK ? Interpreter.do_eq(dArray[n], object) : ScriptRuntime.eq(object2, object));
        return bl;
    }

    private static boolean do_eq(double d, Object object) {
        while (true) {
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return d == ScriptRuntime.toNumber((String)object);
            }
            if (object instanceof Boolean) {
                return d == (double)((Boolean)object != false ? 1 : 0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object == Undefined.instance) {
                return false;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    private static boolean do_sheq(Object[] objectArray, double[] dArray, int n) {
        boolean bl;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else {
            bl = ScriptRuntime.shallowEq(object2, object);
        }
        return bl;
    }

    private static void do_getElem(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 1]);
        }
        if ((object2 = objectArray[n]) != DBL_MRK) {
            object = ScriptRuntime.getElem(object3, object2, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            double d = dArray[n];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.getElem(scriptable2, n2);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.getStrIdElem(scriptable2, string);
            }
        }
        objectArray[n - 1] = object;
    }

    private static void do_setElem(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = objectArray[n];
        if (object4 == DBL_MRK) {
            object4 = Interpreter.doubleWrap(dArray[n]);
        }
        if ((object3 = objectArray[n - 2]) == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 2]);
        }
        if ((object2 = objectArray[n - 1]) != DBL_MRK) {
            object = ScriptRuntime.setElem(object3, object2, object4, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            double d = dArray[n - 1];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.setElem(scriptable2, n2, object4);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.setStrIdElem(scriptable2, string, object4, scriptable);
            }
        }
        objectArray[n - 2] = object;
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == DBL_MRK) {
                object = Interpreter.doubleWrap(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static Object activationGet(NativeFunction nativeFunction, Scriptable scriptable, int n) {
        String string = nativeFunction.argNames[n];
        Object object = scriptable.get(string, scriptable);
        if (object == Scriptable.NOT_FOUND) {
            Context.codeBug();
        }
        return object;
    }

    private static void activationPut(NativeFunction nativeFunction, Scriptable scriptable, int n, Object object) {
        String string = nativeFunction.argNames[n];
        scriptable.put(string, scriptable, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object execWithNewDomain(Context context, Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray, final double[] dArray, final int n, final int n2, final NativeFunction nativeFunction, final InterpreterData interpreterData) throws JavaScriptException {
        if (context.interpreterSecurityDomain == interpreterData.securityDomain) {
            Context.codeBug();
        }
        Script script = new Script(){

            public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
                return Interpreter.interpret(context, scriptable, scriptable2, objectArray, dArray, n, n2, nativeFunction, interpreterData);
            }
        };
        Object object = context.interpreterSecurityDomain;
        context.interpreterSecurityDomain = interpreterData.securityDomain;
        try {
            Object object2 = context.getSecurityController().execWithDomain(context, scriptable, script, interpreterData.securityDomain);
            return object2;
        }
        finally {
            context.interpreterSecurityDomain = object;
        }
    }

    static {
        DBL_MRK = new Object();
    }
}

