/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.optimizer.OptClassNameHelper;

public class OptFunctionNode
extends FunctionNode {
    private String itsClassName;
    private boolean itsIsTargetOfDirectCall;
    private boolean itsContainsCalls;
    private boolean[] itsContainsCallsCount = new boolean[4];
    private boolean itsParameterNumberContext;
    private ObjArray itsDirectCallTargets;

    public OptFunctionNode(String string, Node node, Node node2, ClassNameHelper classNameHelper) {
        super(string, node, node2);
        OptClassNameHelper optClassNameHelper = (OptClassNameHelper)classNameHelper;
        this.itsClassName = optClassNameHelper.getJavaScriptClassName(string, false);
    }

    public String getDirectCallParameterSignature() {
        StringBuffer stringBuffer = new StringBuffer("(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        int n = this.itsVariableTable.getParameterCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("Ljava/lang/Object;D");
        }
        stringBuffer.append("[Ljava/lang/Object;)");
        return stringBuffer.toString();
    }

    public String getClassName() {
        return this.itsClassName;
    }

    public boolean isTargetOfDirectCall() {
        return this.itsIsTargetOfDirectCall;
    }

    public void addDirectCallTarget(FunctionNode functionNode) {
        if (this.itsDirectCallTargets == null) {
            this.itsDirectCallTargets = new ObjArray();
        }
        for (int i = 0; i < this.itsDirectCallTargets.size(); ++i) {
            if ((FunctionNode)this.itsDirectCallTargets.get(i) != functionNode) continue;
            return;
        }
        this.itsDirectCallTargets.add(functionNode);
    }

    public ObjArray getDirectCallTargets() {
        return this.itsDirectCallTargets;
    }

    public void setIsTargetOfDirectCall() {
        this.itsIsTargetOfDirectCall = true;
    }

    public void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }

    public boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    public boolean containsCalls(int n) {
        if (n < this.itsContainsCallsCount.length && n >= 0) {
            return this.itsContainsCallsCount[n];
        }
        return this.itsContainsCalls;
    }

    public void setContainsCalls(int n) {
        if (n < this.itsContainsCallsCount.length) {
            this.itsContainsCallsCount[n] = true;
        }
        this.itsContainsCalls = true;
    }

    public void incrementLocalCount() {
        int n = this.getIntProp(22, 0);
        this.putIntProp(22, n + 1);
    }
}

