/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pastedlg.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2006/10/24 14:10:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _PASTEDLG_HXX
#define _PASTEDLG_HXX

#ifndef _TABLE_HXX //autogen
#include <tools/table.hxx>
#endif
#ifndef _SOT_FORMATS_HXX
#include <sot/formats.hxx>
#endif
#ifndef _GLOBNAME_HXX //autogen
#include <tools/globname.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif

#ifndef INCLUDED_SO3DLLAPI_H
#include "so3/so3dllapi.h"
#endif

/********************** SvPasteObjectDialog ******************************
*************************************************************************/

class Window;
struct TransferableObjectDescriptor;


class SO3_DLLPUBLIC SvPasteObjectDialog
{
private:
	Table       	aSupplementTable;
	SvGlobalName	aObjClassName;
	String			aObjName;
	USHORT      	nAspect;
	BOOL        	bLink;

	SO3_DLLPRIVATE void        	SetDefault();
public:
				SvPasteObjectDialog();
				~SvPasteObjectDialog();

	void        Insert( SotFormatStringId nFormat, const String & rFormatName );

	void		SetObjName( const SvGlobalName & rClass, const String & rObjName )
				{
					aObjClassName = rClass;
					aObjName = rObjName;
				}

	ULONG       Execute( Window* pParent, const
						::com::sun::star::uno::Reference<
							::com::sun::star::datatransfer::XTransferable >
								& rxTransferable );
	ULONG 		Execute( Window* pParent,
						 const DataFlavorExVector& rFormats,
						 const TransferableObjectDescriptor& rDesc );
	
	ULONG 		Execute( Window* pParent,
						 TransferableDataHelper& aHelper);
	// do not use this function, it will be removed soon. use Execute( Window*, TransferableDataHelper&)
	// instead
	ULONG 		Execute( Window* pParent,
						const DataFlavorExVector& rFormats,
						 const TransferableObjectDescriptor& rDesc,
						 const TransferableDataHelper& aHelper);



	USHORT      GetAspect() const { return nAspect; }
	BOOL        ShouldLink() const { return bLink; }

public:

    static String GetSotFormatUIName( SotFormatStringId nId );
	static sal_Bool GetEmbeddedName(const TransferableDataHelper& rData,String& _rName,String& _rSource,SotFormatStringId& _nFormat);
};

#endif // _PASTEDLG_HXX
