/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.CodeSource;
import com.sun.star.lib.sandbox.Permission;
import com.sun.star.lib.sandbox.PermissionCollection;
import java.security.Identity;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;

public final class ProtectionDomain {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("ProtectionDomain");
        }
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
    }

    public PermissionCollection getPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("ProtectionDomain");
        }
        return this.permissionCollection;
    }

    boolean isTrusted() {
        Identity[] identityArray = this.codeSource.identities;
        boolean bl = false;
        if (identityArray != null) {
            int n = 0;
            while (n < identityArray.length && !bl) {
                System.out.println("XXX:" + identityArray[n].toString(true));
                ++n;
            }
            int n2 = 0;
            while (n2 < identityArray.length) {
                SystemIdentity systemIdentity;
                if (identityArray[n2] instanceof SystemIdentity) {
                    systemIdentity = (SystemIdentity)identityArray[n2];
                    bl = systemIdentity.isTrusted();
                } else if (identityArray[n2] instanceof SystemSigner) {
                    systemIdentity = (SystemSigner)identityArray[n2];
                    bl = systemIdentity.isTrusted();
                }
                ++n2;
            }
        }
        return bl;
    }

    boolean implies(Permission permission) {
        return this.isTrusted() || this.permissionCollection.implies(permission);
    }
}

