/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.Component;
import java.awt.Frame;
import java.io.PrintStream;
import stardiv.controller.ConsoleStream;
import stardiv.controller.DebugDialog;

public class Console {
    static String aOutput = Console.getVersion();
    static DebugDialog pDialog;
    static Frame pFrame;
    static ConsoleStream pErrStm;
    static ConsoleStream pOutStm;
    static PrintStream pSystemErr;
    static PrintStream pSystemOut;
    static boolean redirected;
    static String titel;

    public Console() {
        Console.showConsole(true);
    }

    public static synchronized void installConsole() {
        if (!redirected) {
            pSystemErr = System.err;
            pSystemOut = System.out;
            pErrStm = new ConsoleStream();
            System.setErr(new PrintStream(pErrStm));
            pOutStm = new ConsoleStream();
            System.setOut(new PrintStream(pOutStm));
            redirected = true;
        }
    }

    static String getVersion() {
        String string = new String();
        try {
            string = string + System.getProperty("java.vendor");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string = string + " (";
        try {
            string = string + System.getProperty("java.vendor.url");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string = string + ") -- JDK ";
        try {
            string = string + System.getProperty("java.version") + "\n";
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string = string + "\n";
        return string;
    }

    static void loadLibrary(String string) {
        System.loadLibrary(string);
    }

    static void printDebugPassword(String string) {
        titel = string != null ? "Java Console [ password: " + string + " ]" : "Java Console [ !! no debug agent found !! ]";
    }

    public static synchronized void showConsole(boolean bl) {
        if (bl) {
            if (pDialog == null) {
                if (pFrame == null) {
                    pFrame = new Frame();
                }
                pDialog = new DebugDialog(pFrame, titel);
            }
            pDialog.show();
            pDialog.setText(aOutput);
        } else if (pDialog != null) {
            ((Component)pDialog).setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        Console.installConsole();
        Console.showConsole(true);
    }

    static {
        redirected = false;
        titel = "Java Console";
    }
}

