/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;
import org.openoffice.xmerge.util.registry.RegistryException;

public final class ConverterInfoMgr {
    private static Vector converterInfoList = new Vector();

    public static void addPlugIn(Enumeration enumeration) throws RegistryException {
        while (enumeration.hasMoreElements()) {
            ConverterInfo converterInfo = (ConverterInfo)enumeration.nextElement();
            ConverterInfoMgr.addPlugIn(converterInfo);
        }
    }

    public static void addPlugIn(ConverterInfo converterInfo) throws RegistryException {
        if (converterInfo.getDisplayName() == null) {
            RegistryException registryException = new RegistryException("Converter must have valid name.");
            throw registryException;
        }
        if (converterInfo.getClassImpl() == null) {
            RegistryException registryException = new RegistryException("Converter must have valid class implementation specified.");
            throw registryException;
        }
        if (converterInfo.getOfficeMime() == null) {
            RegistryException registryException = new RegistryException("Converter must have valid office mime specified.");
            throw registryException;
        }
        if (!converterInfo.getDeviceMime().hasMoreElements()) {
            RegistryException registryException = new RegistryException("Converter must have valid device mime specified.");
            throw registryException;
        }
        Enumeration enumeration = converterInfoList.elements();
        while (enumeration.hasMoreElements()) {
            ConverterInfo converterInfo2 = (ConverterInfo)enumeration.nextElement();
            if (!converterInfo.getDisplayName().equals(converterInfo2.getDisplayName())) continue;
            RegistryException registryException = new RegistryException("Converter with specified display name already exists.");
            throw registryException;
        }
        Vector vector = converterInfoList;
        synchronized (vector) {
            converterInfoList.add(converterInfo);
        }
    }

    public static ConverterInfo findConverterInfo(String string, String string2) {
        if (string == null || !ConverterInfo.isValidOfficeType(string2)) {
            return null;
        }
        Enumeration enumeration = converterInfoList.elements();
        while (enumeration.hasMoreElements()) {
            ConverterInfo converterInfo = (ConverterInfo)enumeration.nextElement();
            String string3 = converterInfo.getOfficeMime();
            Enumeration enumeration2 = converterInfo.getDeviceMime();
            while (enumeration2.hasMoreElements()) {
                String string4 = (String)enumeration2.nextElement();
                if (!string.trim().equals(string4) || !string2.trim().equals(string3)) continue;
                return converterInfo;
            }
        }
        return null;
    }

    public static ConverterInfo[] findConverterInfoChain(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        ConverterInfo[] converterInfoArray = new ConverterInfo[2];
        Enumeration enumeration = converterInfoList.elements();
        while (enumeration.hasMoreElements()) {
            converterInfoArray[0] = (ConverterInfo)enumeration.nextElement();
            String string3 = converterInfoArray[0].getOfficeMime();
            Enumeration enumeration2 = converterInfoArray[0].getDeviceMime();
            while (enumeration2.hasMoreElements()) {
                String string4 = (String)enumeration2.nextElement();
                if (!string.trim().equals(string4)) continue;
                Enumeration enumeration3 = converterInfoList.elements();
                while (enumeration3.hasMoreElements()) {
                    converterInfoArray[1] = (ConverterInfo)enumeration3.nextElement();
                    String string5 = converterInfoArray[1].getOfficeMime();
                    Enumeration enumeration4 = converterInfoArray[1].getDeviceMime();
                    while (enumeration4.hasMoreElements()) {
                        String string6 = (String)enumeration4.nextElement();
                        if (!string2.trim().equals(string6) || !string3.equals(string5)) continue;
                        return converterInfoArray;
                    }
                }
            }
        }
        return null;
    }

    public static Enumeration getConverterInfoEnumeration() {
        return converterInfoList.elements();
    }

    public static void main(String[] stringArray) {
        ConverterInfoReader converterInfoReader = null;
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 32;
        boolean bl2 = false;
        while (!bl2) {
            Object object;
            Object object2;
            System.out.println("\nMenu:");
            System.out.println("(L)oad plug-ins from a jar file");
            System.out.println("(D)isplay name unload");
            System.out.println("(J)ar name unload");
            System.out.println("(F)ind ConverterInfo");
            System.out.println("(C)ind ConverterInfo chain");
            System.out.println("(V)iew plug-ins");
            System.out.println("(T)oggle Validation");
            System.out.println("(Q)uit\n");
            try {
                n = bufferedReader.readLine().toUpperCase().trim().charAt(0);
            }
            catch (Exception exception) {
                System.out.println("Invalid entry");
                System.out.println("Error msg: " + exception.getMessage());
                continue;
            }
            System.out.println("");
            if (n == 81) {
                bl2 = true;
                continue;
            }
            if (n == 76) {
                System.out.println("Enter path to jarfile: ");
                try {
                    object2 = bufferedReader.readLine().trim();
                    converterInfoReader = new ConverterInfoReader((String)object2, bl);
                }
                catch (RegistryException registryException) {
                    System.out.println("Cannot load plug-in ConverterFactory implementation.");
                    System.out.println("Error msg: " + registryException.getMessage());
                }
                catch (Exception exception) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + exception.getMessage());
                }
                if (converterInfoReader == null) continue;
                object2 = converterInfoReader.getConverterInfoEnumeration();
                try {
                    ConverterInfoMgr.addPlugIn((Enumeration)object2);
                }
                catch (Exception exception) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + exception.getMessage());
                }
                continue;
            }
            if (n == 84) {
                if (bl) {
                    System.out.println("Validation switched off");
                    bl = false;
                    continue;
                }
                System.out.println("Validation switched on");
                bl = true;
                continue;
            }
            if (n == 68 || n == 74) {
                if (n == 68) {
                    System.out.println("Enter display name: ");
                } else {
                    System.out.println("Enter path to jarfile: ");
                }
                try {
                    object2 = bufferedReader.readLine().trim();
                    boolean bl3 = false;
                    bl3 = n == 68 ? ConverterInfoMgr.removeByName((String)object2) : ConverterInfoMgr.removeByJar((String)object2);
                    if (bl3) {
                        System.out.println("Remove successful.");
                        continue;
                    }
                    System.out.println("Remove failed.");
                }
                catch (Exception exception) {
                    System.out.println("Error removing value from registry");
                    System.out.println("Error msg: " + exception.getMessage());
                }
                continue;
            }
            if (n == 70 || n == 67) {
                object2 = null;
                String string = null;
                if (n == 70) {
                    System.out.println("Enter device mime: ");
                } else {
                    System.out.println("Enter device from mime: ");
                }
                try {
                    object2 = bufferedReader.readLine().trim();
                }
                catch (Exception exception) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + exception.getMessage());
                }
                if (n == 70) {
                    System.out.println("Enter office mime: ");
                } else {
                    System.out.println("Enter device to mime: ");
                }
                try {
                    string = bufferedReader.readLine().trim();
                }
                catch (Exception exception) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + exception.getMessage());
                }
                if (n == 70) {
                    object = ConverterInfoMgr.findConverterInfo((String)object2, string);
                    if (object != null) {
                        System.out.println("    Found ConverterInfo");
                        System.out.println("    DisplayName  : " + object.getDisplayName());
                        continue;
                    }
                    System.out.println("    Did not find ConverterInfo");
                    continue;
                }
                object = ConverterInfoMgr.findConverterInfoChain((String)object2, string);
                if (object[0] != null && object[1] != null) {
                    System.out.println("    Found ConverterInfo Chain");
                    System.out.println("    DisplayName  : " + object[0].getDisplayName());
                    System.out.println("    DisplayName  : " + object[1].getDisplayName());
                    continue;
                }
                System.out.println("    Did not find ConverterInfo");
                continue;
            }
            if (n == 86) {
                object2 = ConverterInfoMgr.getConverterInfoEnumeration();
                int n2 = 0;
                while (object2.hasMoreElements()) {
                    System.out.println("");
                    System.out.println("  Displaying converter number " + n2);
                    object = (ConverterInfo[])object2.nextElement();
                    System.out.println("    DisplayName  : " + object.getDisplayName());
                    System.out.println("    JarFile      : " + object.getJarName());
                    System.out.println("    Description  : " + object.getDescription());
                    System.out.println("    Version      : " + object.getVersion());
                    System.out.println("    OfficeMime   : " + object.getOfficeMime());
                    Enumeration enumeration = object.getDeviceMime();
                    int n3 = 1;
                    while (enumeration.hasMoreElements()) {
                        System.out.println("    DeviceMime   : (#" + n3 + ") : " + (String)enumeration.nextElement());
                        ++n3;
                    }
                    if (n3 == 1) {
                        System.out.println("    DeviceMime   : None specified");
                    }
                    System.out.println("    Vendor       : " + object.getVendor());
                    System.out.println("    ClassImpl    : " + object.getClassImpl());
                    System.out.println("    XsltSerial   : " + object.getXsltSerial());
                    System.out.println("    XsltDeserial : " + object.getXsltDeserial());
                    System.out.println("    Serialize    : " + object.canSerialize());
                    System.out.println("    Deserialize  : " + object.canDeserialize());
                    System.out.println("    Merge        : " + object.canMerge());
                    ++n2;
                }
                if (n2 != 0) continue;
                System.out.println("No converters registered");
                continue;
            }
            System.out.println("Invalid input");
        }
    }

    public static boolean removeByJar(String string) {
        boolean bl = false;
        Enumeration enumeration = converterInfoList.elements();
        while (enumeration.hasMoreElements()) {
            ConverterInfo converterInfo = (ConverterInfo)enumeration.nextElement();
            if (!string.equals(converterInfo.getJarName())) continue;
            converterInfoList.remove(converterInfo);
            bl = true;
        }
        return bl;
    }

    public static boolean removeByName(String string) {
        boolean bl = false;
        Enumeration enumeration = converterInfoList.elements();
        while (enumeration.hasMoreElements()) {
            ConverterInfo converterInfo = (ConverterInfo)enumeration.nextElement();
            if (!string.equals(converterInfo.getDisplayName())) continue;
            converterInfoList.remove(converterInfo);
            bl = true;
        }
        return bl;
    }
}

