/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.NativeFrame;

public class Frame
extends java.awt.Frame
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    protected AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEventBroadcaster;

    protected Frame(XAccessibleComponent xAccessibleComponent) {
        this.initialize(xAccessibleComponent);
    }

    protected Frame(String string, XAccessibleComponent xAccessibleComponent) {
        super(string);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEventBroadcaster == null ? (class$com$sun$star$accessibility$XAccessibleEventBroadcaster = Frame.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster")) : class$com$sun$star$accessibility$XAccessibleEventBroadcaster), (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener((XAccessibleEventListener)new AccessibleFrameListener());
        }
    }

    public Component getInitialComponent() {
        return this.initialComponent;
    }

    public void setInitialComponent(Component component) {
        this.initialComponent = component;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
    }

    protected void postWindowEvent(int n) {
        this.eventQueue.postEvent(new WindowEvent(this, n));
    }

    protected void postComponentEvent(int n) {
        this.eventQueue.postEvent(new ComponentEvent(this, n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFrame();
            this.accessibleContext.setAccessibleName(this.getTitle());
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleFrame
    extends Frame.AccessibleAWTFrame {
        protected ComponentListener accessibleComponentHandler = null;
        protected WindowListener accessibleWindowHandler = null;
        protected ContainerListener accessibleContainerHandler = null;
        protected int propertyChangeListenerCount = 0;

        protected AccessibleFrame() {
            super(Frame.this);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleWindowHandler = new AccessibleWindowHandler();
                Frame.this.addWindowListener(this.accessibleWindowHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Frame.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Frame.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Frame.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Frame.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Frame.this.removeWindowListener(this.accessibleWindowHandler);
                this.accessibleWindowHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if ((Frame.this.getExtendedState() & 1) > 0) {
                accessibleStateSet.add(AccessibleState.ICONIFIED);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            try {
                return new Color(Frame.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(Frame.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return Frame.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return Frame.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return Frame.this.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return Frame.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Frame.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = Frame.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Frame.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = Frame.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Frame.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Frame.this.isFocusable();
        }

        public void requestFocus() {
            Frame.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleFrame.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleFrame.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleWindowHandler
        implements WindowListener {
            protected AccessibleWindowHandler() {
            }

            public void windowActivated(WindowEvent windowEvent) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleFrameListener
    implements XAccessibleEventListener {
        protected AccessibleFrameListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    if (bl) {
                        AccessibleObjectFactory.postWindowActivated(Frame.this);
                        break;
                    }
                    AccessibleObjectFactory.postWindowLostFocus(Frame.this);
                    break;
                }
                case 13: {
                    Frame.this.postWindowEvent(bl ? 203 : 204);
                    break;
                }
                case 30: {
                    Frame.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                String string = AnyConverter.toString((Object)object);
                Frame.this.setTitle(string);
                AccessibleContext accessibleContext = Frame.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                AccessibleContext accessibleContext = Frame.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext accessibleContext = Frame.this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 1: {
                    this.handleNameChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        AccessibleObjectFactory.removeChild(Frame.this, accessibleEventObject.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Frame.this, accessibleEventObject.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

