#pragma once

/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 * @link      http://war02.sourceforge.jp/
 */

#include "Motion.h"

using namespace System;
using namespace Collections::Generic;

namespace war02 {
namespace core {


    /**
     * [VID`NX
     */
    ref class MotionID
    {
    public:
        static const Int32 Normal = 1;
        static const Int32 Walk   = 2;
        static const Int32 Dash   = 3;
        static const Int32 Punch  = 4;
        static const Int32 Kick   = 5;
        static const Int32 Damage = 6;
        static const Int32 Jump   = 7;
    };

    /**
     * [V̈ꗗǗNX
     * @package war02.animEditor
     */
    ref class MotionCollection
    {
    public:
        static MotionCollection^ getInstance();
        Motion^ getMotion(Int32 id);
        Dictionary<Int32, Motion^>^ getMotionList();
        array<Motion^>^ getMotionArray();

    private:
        MotionCollection(void);
        static MotionCollection^ instance = nullptr;  ///NX̗B̃CX^X

    private:
        Dictionary<Int32, Motion^>^ motionList;  ///[VID̃[Ṽe[u
    };

} //namespace core end
} //namespace war02 end
