// $Id: CRequest.h,v 1.8 2003/04/23 09:20:56 ta_muto Exp $
// The class which manages the request from a browser.

#ifndef __wax_CRequest_h
#define __wax_CRequest_h

#include <common.h>
#include <collection.h>

namespace wax {
	class CParameterItem : public ICursor {
		xmlChar* name;
		xmlChar* value;
		xmlChar* origin;
		bool fixed;
	public:
		CParameterItem(const xmlChar* initName, const xmlChar* initValue, bool initFixed);
		~CParameterItem();
		
		const xmlChar* getName() const { return name; }
		const xmlChar* getValue() const { return value; }
		const xmlChar* getOriginalValue() const { return origin; }
		bool getFixed() const { return fixed; }
		
		void setOriginalValue(const xmlChar* newValue);
	private:
		xmlChar* quoteStrdup(const xmlChar* newValue);
	} ;
	
	class CRequest {
		xmlChar* userAgent;
		CCollection params;
		xmlDocPtr instanceData;
	public:
		CRequest();
		~CRequest();
		
		bool init();

		const xmlChar* getUserAgent() const { return userAgent; }
		const CCollection& getParams() const { return params; }
		
		CParameterItem* findParameter(const xmlChar* name);
	private:
		int parseParameter(char* paramString, bool isFinish = true);
		void escapeTokens(char* name, char* value);
		void escape(char* source);
		char AtoH(char c);
	} ;
}

#endif
