// $Id: collection.h,v 1.6 2003/05/10 06:46:42 ta_muto Exp $
// collection class.

#ifndef __wax_collection_h
#define __wax_collection_h

#include <common.h>

namespace wax {
	class ICursor {
		ICursor* next;
	public:
		ICursor() { next = NULL; }
		virtual ~ICursor();
		
		ICursor* getNext() const { return next; }
		void setNext(ICursor* newValue) { next = newValue; }
	} ;

	class CCollection {
		ICursor* head;
		ICursor* last;
		bool reference;
	public:
		CCollection() { head = NULL, last = NULL, reference = false; }
		~CCollection();
		
		ICursor* getHead() const { return head; }
		bool hasItem() const { return (head != NULL)? true: false; }
		
		void insertHead(ICursor* item) { insertAfter(head, item); }

		void insertAfter(ICursor* cursor, ICursor* item);
		void addItem(ICursor* item);
		
		void removeAll();

		void share(CCollection& base) { head = base.head, last = base.last, reference = true; }
	} ;
}

#endif
