// $Id: CInterXmlDB.h,v 1.7 2003/05/10 06:46:47 ta_muto Exp $
// Xml DB implemented class

#ifndef __wax_CInterXmlDB_h
#define __wax_CInterXmlDB_h

#include <common.h>
#include <xupdate/IXmlDB.h>
#include <CXmlLibs.h>
#include <CFileLiteracy.h>

namespace wax {
	class CInterXmlDB : public IXmlDB {
		xmlChar* connection;
		xmlDocPtr targetDoc;
		CXPathMacro* macro;
		CFileLiteracy* file;
	public:
		CInterXmlDB();
		~CInterXmlDB();
	
		bool open(const xmlChar* connect);
		void registerVariable(const xmlChar* name, const xmlChar* value);
		bool flush();
		void close();

		bool isMatch(const xmlChar* connect);
		bool select(const xmlChar* xpath);

		bool insertAfter(xmlDocPtr doc);
		bool insertBefore(xmlDocPtr doc);
		bool append(xmlDocPtr doc, const xmlChar* child);
		bool rename(const xmlChar* name);
		bool updateContent(xmlDocPtr doc);
		bool remove();
	} ;
}

#endif
