// $Id: CXmlSession.h,v 1.2 2003/04/23 09:20:57 ta_muto Exp $
// Xml DB Session Manager class

#ifndef __wax_CXmlSession_h
#define __wax_CXmlSession_h

#include <common.h>
#include <collection.h>
#include <xupdate/IXmlDB.h>

namespace wax {
	class CXmlSession {
		CCollection sessions;
		CCollection vars;
	public:
		CXmlSession();
		virtual ~CXmlSession();
		
		IXmlDB* getInstance(const xmlChar* connect);

		void setVariables(CCollection& initVars) { vars.share(initVars); }

		void commit();
		void rollback();
	protected:
		void add(IXmlDB* db) { sessions.addItem(db); }
		virtual IXmlDB* newInstance(const xmlChar* connect);
		virtual CXmlSession* clone();
	public:
		static CXmlSession* getSession();
		static void setSession(CXmlSession* mySession);
	} ;
}

#endif
