// $Id: CXUInsertAfter.cc,v 1.4 2003/05/10 06:46:51 ta_muto Exp $

#include <xupdate/CXUInsertAfter.h>
#include <xupdate/CXUActionBase.h>

wax::CXUInsertAfter::CXUInsertAfter(const xmlChar* initConnect)
{
	select = NULL;
	if(initConnect != NULL) {
		connect = xmlStrdup(initConnect);
	} else {
		connect = NULL;
	}
	instanceData = NULL;
}

wax::CXUInsertAfter::~CXUInsertAfter()
{
	if(select != NULL)	xmlFree(select);
	if(connect != NULL)	xmlFree(connect);
	if(instanceData != NULL)	xmlFreeDoc(instanceData);
}

bool wax::CXUInsertAfter::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	select = CXUActionBase::getSelect(cur);
	if(select == NULL)	return false;

	instanceData = CXUActionBase::parse(runenv, cur, vars, connect);
	if(connect == NULL) {
		IError::message(ERR_CONNECT);
		return false;
	}

	if(instanceData == NULL)	return false;
	return true;
}

bool wax::CXUInsertAfter::execute(CXmlSession* session)
{
	IXmlDB* db = session->getInstance(connect);
	if(db == NULL) {
		return false;
	}
	if(db->select(select) == false) {
		return false;
	}
	if(db->insertAfter(instanceData) == false) {
		return false;
	}
	return true;
}
