/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.infodb.commons.db.MetaDataManager;
import org.infodb.commons.db.SQLDML;
import org.infodb.commons.db.SQLLog;

public class SQLTransaction
extends SQLDML {
    private Connection conn;
    private PreparedStatement stmt;
    private boolean needClose;

    public SQLTransaction(Connection c) {
        this.conn = c;
        this.needClose = true;
    }

    public SQLTransaction(Connection c, boolean close) {
        this.conn = c;
        this.needClose = close;
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.needClose) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public SQLDML.FieldPair addColumn(String name, Object value) {
        int type = MetaDataManager.findColumnType(this.tableName, name);
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, null);
        fp.addParam(value, type);
        this.columns.add(fp);
        return fp;
    }

    public SQLDML.FieldPair addColumn(String name, Object value, int type) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, null);
        fp.addParam(value, type);
        this.columns.add(fp);
        return fp;
    }

    public SQLDML.FieldPair addColumnWithFunc(String name, String func) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, func);
        this.columns.add(fp);
        return fp;
    }

    public SQLDML.FieldPair addColumnWithFunc(String name, String func, Object param1, int type1) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, func);
        fp.addParam(param1, type1);
        this.columns.add(fp);
        return fp;
    }

    public SQLDML.FieldPair addColumnWithFunc(String name, String func, Object param1, int type1, Object param2, int type2) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, func);
        fp.addParam(param1, type1);
        fp.addParam(param2, type2);
        this.columns.add(fp);
        return fp;
    }

    public SQLDML.FieldPair addColumnWithFunc(String name, String func, Object param1, int type1, Object param2, int type2, Object param3, int type3) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, func);
        fp.addParam(param1, type1);
        fp.addParam(param2, type2);
        fp.addParam(param3, type3);
        this.columns.add(fp);
        return fp;
    }

    public boolean insert() throws SQLException {
        String sql = this.generateInsertSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
        this.paramSetting(this.stmt, 1);
        return this.stmt.execute();
    }

    public boolean update() throws SQLException {
        String sql = this.generateUpdateSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
        int index = this.paramSetting(this.stmt, 1);
        this.whereSetting(this.stmt, index);
        return this.stmt.execute();
    }

    public boolean delete() throws SQLException {
        String sql = this.generateDeleteSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
        this.whereSetting(this.stmt, 1);
        return this.stmt.execute();
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
    }
}

