/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class NamedSQL {
    private ArrayList<Object> params = new ArrayList();
    private String compiledSQL;

    public void compile(String sql, Map<String, Object> map) throws SQLException {
        this.params.clear();
        boolean singleQuote = false;
        boolean doubleQuote = false;
        StringBuffer sb = new StringBuffer("");
        int length = sql.length();
        for (int i = 0; i < length; ++i) {
            char ch = sql.charAt(i);
            if (singleQuote) {
                if (ch == '\'') {
                    singleQuote = false;
                }
            } else if (doubleQuote) {
                if (ch == '\"') {
                    doubleQuote = false;
                }
            } else if (ch == '\'') {
                singleQuote = true;
            } else if (ch == '\"') {
                doubleQuote = true;
            } else if (ch == ':' && i + 1 < length && Character.isJavaIdentifierStart(sql.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(sql.charAt(j)); ++j) {
                }
                String name = sql.substring(i + 1, j);
                i += name.length();
                if (map.containsKey(name)) {
                    Object obj = map.get(name);
                    if (obj instanceof Collection) {
                        boolean first = true;
                        Iterator<Object> iter = this.castToCollection(obj).iterator();
                        while (iter.hasNext()) {
                            this.params.add(iter.next());
                            if (!first) {
                                sb.append(",");
                            }
                            sb.append('?');
                            first = false;
                        }
                        continue;
                    }
                    sb.append('?');
                    this.params.add(map.get(name));
                    continue;
                }
                throw new SQLException("Could not find parameter name. [" + name + "]");
            }
            sb.append(ch);
        }
        this.compiledSQL = sb.toString();
    }

    private Collection<Object> castToCollection(Object obj) {
        return (Collection)obj;
    }

    public String getSQL() {
        return this.compiledSQL;
    }

    public ArrayList<Object> getParams() {
        return this.params;
    }
}

