/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infodb.commons.db.SQLLog;

public class SQLDirect {
    private Connection conn;
    private Statement stmt;
    private boolean needClose;

    public SQLDirect(Connection c) {
        this.conn = c;
        this.needClose = true;
    }

    public SQLDirect(Connection c, boolean close) {
        this.conn = c;
        this.needClose = close;
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.needClose) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQL(String sql) throws SQLException {
        long handler = SQLLog.sqllog(sql);
        this.stmt = this.conn.createStatement();
        try {
            boolean bl = this.stmt.execute(sql);
            return bl;
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQL(String sql, Object ... args) throws SQLException {
        long handler = SQLLog.sqllog(sql);
        PreparedStatement s = this.conn.prepareStatement(sql);
        this.stmt = s;
        int index = 1;
        for (Object obj : args) {
            if (obj == null) {
                SQLLog.paramlog(index, "NULL");
                s.setNull(index++, 0);
                continue;
            }
            SQLLog.paramlog(index, obj.toString());
            s.setObject(index++, obj);
        }
        try {
            boolean bl = s.execute();
            return bl;
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        long handler = SQLLog.sqllog(sql);
        this.stmt = this.conn.createStatement();
        try {
            ResultSet resultSet = this.stmt.executeQuery(sql);
            return resultSet;
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql, Object ... args) throws SQLException {
        long handler = SQLLog.sqllog(sql);
        PreparedStatement s = this.conn.prepareStatement(sql);
        this.stmt = s;
        int index = 1;
        for (Object obj : args) {
            if (obj == null) {
                SQLLog.paramlog(index, "NULL");
                s.setNull(index++, 0);
                continue;
            }
            SQLLog.paramlog(index, obj.toString());
            s.setObject(index++, obj);
        }
        try {
            ResultSet resultSet = s.executeQuery();
            return resultSet;
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }
}

