--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: dept; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dept (
    id integer NOT NULL,
    tel character varying(255),
    email character varying(255),
    created_date timestamp with time zone DEFAULT now(),
    updated_date timestamp with time zone DEFAULT now(),
    del_flag boolean DEFAULT false
);


ALTER TABLE public.dept OWNER TO postgres;

--
-- Name: dept_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dept_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dept_id_seq OWNER TO postgres;

--
-- Name: dept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dept_id_seq OWNED BY dept.id;


--
-- Name: mst_dept; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mst_dept (
    id integer NOT NULL,
    name character varying(255),
    created_date timestamp with time zone DEFAULT now(),
    updated_date timestamp with time zone DEFAULT now(),
    del_flag boolean DEFAULT false
);


ALTER TABLE public.mst_dept OWNER TO postgres;

--
-- Name: mst_dept_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE mst_dept_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mst_dept_id_seq OWNER TO postgres;

--
-- Name: mst_dept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE mst_dept_id_seq OWNED BY mst_dept.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dept ALTER COLUMN id SET DEFAULT nextval('dept_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY mst_dept ALTER COLUMN id SET DEFAULT nextval('mst_dept_id_seq'::regclass);


--
-- Data for Name: dept; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dept (id, tel, email, created_date, updated_date, del_flag) FROM stdin;
1	01-1111-1111	webinno1@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
2	02-1111-1111	webinno2@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
3	03-1111-1111	webinno3@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
4	04-1111-1111	webinno4@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
5	05-1111-1111	webinno5@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
6	06-1111-1111	webinno6@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
7	07-1111-1111	webinno7@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
8	08-1111-1111	webinno8@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
9	09-1111-1111	webinno9@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
10	10-1111-1111	webinno10@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
11	11-1111-1111	webinno11@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
12	12-1111-1111	webinno12@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
13	13-1111-1111	webinno13@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
14	14-1111-1111	webinno14@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
15	15-1111-1111	webinno15@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
16	16-1111-1111	webinno16@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
17	17-1111-1111	webinno17@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
18	18-1111-1111	webinno18@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
19	19-1111-1111	webinno19@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
20	20-1111-1111	webinno20@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
21	21-1111-1111	webinno21@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
22	22-1111-1111	webinno22@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
23	23-1111-1111	webinno23@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
24	24-1111-1111	webinno24@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
25	25-1111-1111	webinno25@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
26	26-1111-1111	webinno26@wao.com	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
\.


--
-- Name: dept_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dept_id_seq', 1, false);


--
-- Data for Name: mst_dept; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY mst_dept (id, name, created_date, updated_date, del_flag) FROM stdin;
1	web innovation div1.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
2	web innovation div2.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
3	web innovation div3.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
4	web innovation div4.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
5	web innovation div5.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
6	web innovation div6.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
7	web innovation div7.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
8	web innovation div8.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
9	web innovation div9.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
10	web innovation div10.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
11	web innovation div11.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
12	web innovation div12.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
13	web innovation div13.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
14	web innovation div14.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
15	web innovation div15.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
16	web innovation div16.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
18	web innovation div18.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
19	web innovation div19.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
20	web innovation div20.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
21	web innovation div21.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
22	web innovation div22.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
23	web innovation div23.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
24	web innovation div24.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
25	web innovation div25.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
26	web innovation div26.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	t
17	web innovation div17.	1971-07-13 00:00:00+09	1971-07-13 00:00:00+09	f
\.


--
-- Name: mst_dept_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('mst_dept_id_seq', 1, false);


--
-- Name: dept_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dept
    ADD CONSTRAINT dept_pkey PRIMARY KEY (id);


--
-- Name: mst_dept_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mst_dept
    ADD CONSTRAINT mst_dept_pkey PRIMARY KEY (id);


--
-- Name: dept_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY dept
    ADD CONSTRAINT dept_id_fkey FOREIGN KEY (id) REFERENCES mst_dept(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

