/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.action.sysapi;

import com.opensymphony.xwork2.ActionContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.action.AbstractAction;
import jp.co.headwaters.webappos.controller.cache.ImageDataCache;
import jp.co.headwaters.webappos.controller.cache.bean.ImageCacheBean;
import jp.co.headwaters.webappos.controller.enumation.StretchTypeEnum;
import jp.co.headwaters.webappos.controller.security.Cipher;
import jp.co.headwaters.webappos.controller.security.CipherFactory;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageAction
extends AbstractAction {
    private static final Log _logger = LogFactory.getLog(ImageAction.class);
    private String path;
    private Integer dw;
    private Integer dh;
    private String type;
    private StretchTypeEnum stretchType;

    public String execute() {
        block9: {
            block8: {
                if (this.path != null) break block8;
                _logger.warn((Object)MessageUtils.getString("warn.104", this.getLogMessage()));
                this.outputDefaultImage();
                return null;
            }
            this.stretchType = StretchTypeEnum.getStretchTypeByKey(this.type);
            Cipher cipher = CipherFactory.create("blowfish");
            this.path = cipher.decrypt(this.path);
            this.path = this.getUploadFilePath();
            if (this.isTargetExtension()) break block9;
            _logger.warn((Object)MessageUtils.getString("warn.107", this.getLogMessage()));
            this.outputDefaultImage();
            return null;
        }
        try {
            byte[] imageData = null;
            String cacheKey = String.valueOf(this.path) + "," + this.dw + "," + this.dh;
            ImageDataCache cache = ImageDataCache.getInstance();
            ImageCacheBean imageCache = cache.getImageData(cacheKey);
            imageData = imageCache != null ? imageCache.getImageData() : this.getImageBytes(this.path);
            if (imageData != null) {
                this.outputImage(imageData, this.path);
                ImageCacheBean tempImageCacheBean = new ImageCacheBean(cacheKey, imageData, this.getExpireDateTime());
                cache.addImageData(tempImageCacheBean);
            } else {
                _logger.warn((Object)MessageUtils.getString("warn.106", this.getLogMessage()));
                this.outputDefaultImage();
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                this.outputDefaultImage();
            }
            catch (IOException e1) {
                _logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return null;
    }

    private String getUploadFilePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getText("base.dir"));
        sb.append(this.path);
        return sb.toString();
    }

    private boolean isTargetExtension() {
        String target = ControllerUtils.getFileExtension(this.path);
        String[] stringArray = ControllerConstants.IMAGE_FILE_EXTENSION;
        int n = ControllerConstants.IMAGE_FILE_EXTENSION.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension.equalsIgnoreCase(target)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private byte[] getImageBytes(String path) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream os = null;
        try {
            BufferedImage image = null;
            bos = new ByteArrayOutputStream();
            os = new BufferedOutputStream(bos);
            File file = new File(path);
            image = ImageIO.read(file);
            image = this.resizeImage(image);
            ImageIO.write((RenderedImage)image, ControllerUtils.getFileExtension(path), os);
            ((BufferedOutputStream)os).flush();
            result = bos.toByteArray();
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return result;
    }

    private BufferedImage resizeImage(BufferedImage image) {
        BufferedImage resizedImage = image;
        if (this.dw != null && this.dh != null) {
            int orgWidth = image.getWidth();
            int orgHeight = image.getHeight();
            int width = this.dw;
            int height = this.dh;
            int x = 0;
            int y = 0;
            if (StretchTypeEnum.FILL.equals((Object)this.stretchType)) {
                resizedImage = new BufferedImage(width, height, image.getType());
                resizedImage.getGraphics().drawImage(image.getScaledInstance(width, height, 16), 0, 0, width, height, null);
            } else {
                double reduceRateHeight = 1.0;
                double reduceRateWidth = 1.0;
                if (this.dw != null) {
                    reduceRateWidth = (double)width / (double)orgWidth;
                }
                if (this.dh != null) {
                    reduceRateHeight = (double)height / (double)orgHeight;
                }
                if (StretchTypeEnum.UNIFORM.equals((Object)this.stretchType)) {
                    if (reduceRateWidth < reduceRateHeight) {
                        width = (int)((double)orgWidth * reduceRateWidth);
                        height = (int)((double)orgHeight * reduceRateWidth);
                    } else {
                        width = (int)((double)orgWidth * reduceRateHeight);
                        height = (int)((double)orgHeight * reduceRateHeight);
                    }
                    resizedImage = new BufferedImage(width, height, image.getType());
                    resizedImage.getGraphics().drawImage(image.getScaledInstance(width, height, 16), 0, 0, width, height, null);
                } else {
                    int tempWidth = 0;
                    int tempHeight = 0;
                    if (reduceRateWidth < reduceRateHeight) {
                        tempWidth = (int)Math.ceil((double)orgWidth * reduceRateHeight);
                        tempHeight = (int)Math.ceil((double)orgHeight * reduceRateHeight);
                    } else {
                        tempWidth = (int)Math.ceil((double)orgWidth * reduceRateWidth);
                        tempHeight = (int)Math.ceil((double)orgHeight * reduceRateWidth);
                    }
                    resizedImage = new BufferedImage(tempWidth, tempHeight, image.getType());
                    resizedImage.getGraphics().drawImage(image.getScaledInstance(tempWidth, tempHeight, 16), 0, 0, tempWidth, tempHeight, null);
                    if (reduceRateWidth < reduceRateHeight) {
                        x = ((int)((double)orgWidth * reduceRateHeight) - width) / 2;
                    } else {
                        y = ((int)((double)orgHeight * reduceRateWidth) - height) / 2;
                    }
                    resizedImage = resizedImage.getSubimage(x, y, width, height);
                }
            }
        }
        return resizedImage;
    }

    private long getExpireDateTime() {
        long expire = 3600000L;
        String setting = PropertyUtils.getProperty("image.cache.expire");
        if (!StringUtils.isEmpty((CharSequence)setting)) {
            expire = Long.parseLong(setting);
            expire *= 1000L;
        }
        long expireDate = System.currentTimeMillis() + expire;
        return expireDate;
    }

    private void outputImage(byte[] image, String path) throws IOException {
        if (image == null) {
            return;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(image, 0, image.length);
        this._response.setContentType(this.getContentType(path));
        this._response.setContentLength(byteOut.size());
        try (ServletOutputStream out = null;){
            out = this._response.getOutputStream();
            out.write(byteOut.toByteArray());
            out.flush();
        }
    }

    private void outputDefaultImage() throws IOException {
        String defaultImagePath = this.getNoImagePath();
        if (defaultImagePath != null) {
            this.outputImage(this.getImageBytes(defaultImagePath), defaultImagePath);
        }
    }

    private String getNoImagePath() {
        ActionContext ac = ActionContext.getContext();
        ServletContext sc = (ServletContext)ac.get("com.opensymphony.xwork2.dispatcher.ServletContext");
        return sc.getRealPath(this.getText("noimage.path"));
    }

    private String getContentType(String path) {
        String target = ControllerUtils.getFileExtension(path);
        if ("jpg".equalsIgnoreCase(target) || "jpeg".equalsIgnoreCase(target)) {
            return "image/jpeg";
        }
        if ("png".equalsIgnoreCase(target)) {
            return "image/png";
        }
        if ("gif".equalsIgnoreCase(target)) {
            return "image/gif";
        }
        if ("bmp".equalsIgnoreCase(target)) {
            return "image/x-bmp";
        }
        return null;
    }

    private String getLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("path=");
        sb.append(this.path);
        sb.append(",");
        sb.append("dw=");
        sb.append(this.dw);
        sb.append(",");
        sb.append("dh=");
        sb.append(this.dh);
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getDw() {
        return this.dw;
    }

    public void setDw(Integer dw) {
        this.dw = dw;
    }

    public Integer getDh() {
        return this.dh;
    }

    public void setDh(Integer dh) {
        this.dh = dh;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

