/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.ControllerConstants;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.UrlPatternBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import jp.co.headwaters.webappos.controller.utils.RegexUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingFilter
implements Filter {
    private static final Log _logger = LogFactory.getLog(RoutingFilter.class);
    private WebAppOSCache _webAppOSCache;

    public void init(FilterConfig config) throws ServletException {
        this._webAppOSCache = WebAppOSCache.getInstance();
        if (this._webAppOSCache == null || this._webAppOSCache.getUrlPatternMap().size() == 0) {
            throw new ServletException(MessageUtils.getString("err.000"));
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        String extension = ControllerUtils.getFileExtension(uri);
        if (extension != null) {
            chain.doFilter(request, response);
            return;
        }
        if (!uri.endsWith("/")) {
            uri = String.valueOf(uri) + "/";
        }
        String urlPattern = null;
        boolean isMatch = false;
        String actionName = null;
        if (RoutingFilter.isApi(uri)) {
            String[] stringArray = ControllerConstants.API_URL_PATTERNS;
            int n = ControllerConstants.API_URL_PATTERNS.length;
            int n2 = 0;
            while (n2 < n) {
                String target = stringArray[n2];
                urlPattern = RoutingFilter.getApiUrl(target);
                Pattern pattern = Pattern.compile(RegexUtils.getUrlPatternRegex(urlPattern));
                Matcher matcher = pattern.matcher(uri);
                if (matcher.find()) {
                    isMatch = true;
                    actionName = RoutingFilter.getApiActionName(urlPattern);
                    break;
                }
                ++n2;
            }
        } else {
            Map<String, UrlPatternBean> urlPatternMap = this._webAppOSCache.getUrlPatternMap();
            for (Map.Entry<String, UrlPatternBean> target : urlPatternMap.entrySet()) {
                Pattern pattern = Pattern.compile(target.getValue().getPattern());
                Matcher matcher = pattern.matcher(uri);
                if (!matcher.find()) continue;
                if (!AuthUtils.autoLogin(req, res)) {
                    res.sendRedirect(ControllerUtils.getRedirectUri(req));
                    return;
                }
                if (target.getValue().isAuthRequire() && !this.checkLogin(req, res)) {
                    return;
                }
                isMatch = true;
                request.setAttribute("_RESULT_NAME_", (Object)target.getValue().getResultName());
                urlPattern = target.getKey();
                actionName = target.getValue().getActionName();
                String authUrl = ControllerUtils.getRedirectUri(PropertyUtils.getProperty("auth.request.uri"));
                if (urlPattern.equalsIgnoreCase(authUrl) || urlPattern.equalsIgnoreCase((String)req.getSession().getAttribute("OAUTH_SUCCESS_URI"))) break;
                req.getSession().setAttribute("LOGIN_REDIRECT_URI", null);
                break;
            }
        }
        if (!isMatch) {
            _logger.error((Object)MessageUtils.getString("err.101", uri));
            res.sendError(404);
            return;
        }
        String[] params = null;
        ArrayList<String> paramNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[-_.!~*()a-zA-Z0-9%]+/\\(\\[\\^/\\]\\+\\)");
        Matcher matcher = pattern.matcher(urlPattern);
        while (matcher.find()) {
            params = matcher.group().split("/");
            paramNames.add(params[0]);
        }
        String forwardUri = RoutingFilter.getForwardUri(actionName, paramNames, uri);
        RequestDispatcher rd = request.getRequestDispatcher(forwardUri);
        rd.forward(request, response);
    }

    private static String getForwardUri(String actionName, List<String> paramNames, String uri) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(actionName);
        StringBuilder params = new StringBuilder();
        if (paramNames != null && paramNames.size() > 0) {
            String param = null;
            int beginIndex = 0;
            int endIndex = 0;
            for (String paramName : paramNames) {
                beginIndex = uri.indexOf("/" + paramName + "/") + paramName.length() + 2;
                param = uri.substring(beginIndex, endIndex = uri.indexOf("/", beginIndex));
                if (param == null || param.length() <= 0) continue;
                if (params.toString().length() > 0) {
                    params.append("&");
                }
                params.append(paramName);
                params.append("=");
                params.append(param);
            }
        }
        if (params.toString().length() > 0) {
            sb.append("?");
            sb.append(params.toString());
        }
        return sb.toString();
    }

    private static boolean isApi(String uri) {
        String[] paths = uri.split("/");
        String target = null;
        if (ControllerUtils.getContextMode()) {
            if (paths.length > 2) {
                target = paths[2];
            }
        } else if (paths.length > 1) {
            target = paths[1];
        }
        return "sysapi".equals(target);
    }

    private static String getApiUrl(String pattern) {
        StringBuilder sb = new StringBuilder();
        if (ControllerUtils.getContextMode()) {
            sb.append("/");
            sb.append(ControllerUtils.getContextName());
        }
        sb.append("/");
        sb.append("sysapi");
        sb.append(pattern);
        return sb.toString();
    }

    private static String getApiActionName(String uri) {
        uri = uri.substring(uri.indexOf("sysapi") + "sysapi".length() + 1);
        String[] paths = uri.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append("sysapi");
        sb.append("/");
        sb.append(uri.split("/")[0]);
        if (paths.length > 1) {
            sb.append("!");
            sb.append(uri.split("/")[1]);
        }
        return sb.toString();
    }

    private boolean checkLogin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HashMap user;
        String userId;
        boolean isLoggedin = false;
        HttpSession session = req.getSession();
        Object loginUser = session.getAttribute("LOGIN_USER");
        if (loginUser != null && loginUser instanceof Map && (userId = (String)(user = (HashMap)loginUser).get(AuthUtils.getAuthColumnName("id"))) != null) {
            isLoggedin = true;
        }
        if (!isLoggedin) {
            session.setAttribute("LOGIN_REDIRECT_URI", (Object)ControllerUtils.getRedirectUri(req));
            res.sendRedirect(ControllerUtils.getRedirectUri(PropertyUtils.getProperty("auth.request.uri")));
        }
        return isLoggedin;
    }
}

