/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.fuction;

import java.util.HashMap;
import java.util.Map;
import jp.co.headwaters.webappos.controller.cache.SystemConstantCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.CrudBean;
import jp.co.headwaters.webappos.controller.cache.bean.PagerBean;
import jp.co.headwaters.webappos.controller.cache.bean.SystemConstantBean;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PagingUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public abstract class AbstractFunction {
    protected Map<String, String[]> _requestParams;
    protected Map<String, Object> _resultMap;
    protected SqlSession _sqlSession;
    protected Map<String, Object> _httpSession;
    protected Map<String, Map<Integer, Integer>> _ids = new HashMap<String, Map<Integer, Integer>>();

    public void execute(Map<String, String[]> requestParams, Map<String, Object> resultMap, AbstractExecuteBean function) throws Exception {
        this._requestParams = requestParams;
        this._resultMap = resultMap;
        this.initialize();
        if (this._sqlSession == null) {
            this._sqlSession = DaoUtils.openSqlSession();
        }
        this.execute(function);
    }

    public void setSqlSession(SqlSession session) {
        this._sqlSession = session;
    }

    public void setHttpSession(Map<String, Object> session) {
        this._httpSession = session;
    }

    public void setIds(Map<String, Map<Integer, Integer>> ids) {
        this._ids = ids;
    }

    protected void initialize() throws Exception {
    }

    protected abstract void execute(AbstractExecuteBean var1) throws Exception;

    public String getParameter(String key) throws WebAppOSException {
        String value;
        block23: {
            value = null;
            if (key == null) {
                return null;
            }
            if (key.startsWith("_CONST")) {
                String[] keys = key.split("\\.");
                if (keys.length < 2) {
                    return null;
                }
                if (keys.length == 2) {
                    SystemConstantBean systemConstant = SystemConstantCache.getSystemConstant(keys[1]);
                    if (systemConstant == null) {
                        throw new WebAppOSException("err.001", "", keys[1]);
                    }
                    value = SystemConstantCache.getSystemConstant(keys[1]).getValue();
                } else {
                    SystemConstantBean systemConstant = SystemConstantCache.getSystemConstant(keys[1], keys[2]);
                    if (systemConstant == null) {
                        throw new WebAppOSException("err.001", keys[1], keys[2]);
                    }
                    value = SystemConstantCache.getSystemConstant(keys[1], keys[2]).getValue();
                }
            } else if (key.startsWith("_REQ")) {
                String[] keys = key.split("\\.");
                if (keys.length < 1) {
                    return null;
                }
                if (this._requestParams.get(keys[1]) != null) {
                    value = this._requestParams.get(keys[1])[0];
                }
            } else if (key.startsWith("_SES")) {
                Object loginUser;
                String[] keys = key.split("\\.");
                if (keys.length != 3) {
                    return null;
                }
                if ("LOGIN_USER".equalsIgnoreCase(keys[1]) && (loginUser = this._httpSession.get("LOGIN_USER")) != null && loginUser instanceof Map) {
                    String authKey = AuthUtils.getAuthColumnName(keys[keys.length - 1]);
                    value = String.valueOf(((Map)loginUser).get(authKey));
                }
            } else if (key.split("\\.").length == 3) {
                try {
                    Object map;
                    key = key.toUpperCase();
                    String[] keys = key.split("\\.");
                    if (keys[1].equalsIgnoreCase("_PAGER")) {
                        Object map2;
                        StringBuilder sb = new StringBuilder();
                        sb.append("_PAGER");
                        sb.append("__");
                        sb.append(keys[0].toUpperCase());
                        if (this._resultMap.containsKey(sb.toString()) && (map2 = this._resultMap.get(sb.toString())) instanceof Map) {
                            value = ((Map)map2).get(keys[2]).toString();
                        }
                        break block23;
                    }
                    if (!this._resultMap.containsKey(keys[0]) || !((map = this._resultMap.get(keys[0])) instanceof Map)) break block23;
                    if (!StringUtils.isEmpty((CharSequence)keys[1])) {
                        value = (String)((Map)map).get(ControllerUtils.getResultMapKey(keys[1], keys[2]));
                        break block23;
                    }
                    value = (String)((Map)map).get(keys[2]);
                }
                catch (Exception e) {
                    value = null;
                }
            } else {
                value = key;
            }
        }
        return value;
    }

    protected RowBounds createRowBounds(CrudBean function, Integer count) throws NumberFormatException, NotFoundException {
        RowBounds rowBounds = null;
        int offset = 0;
        int limit = 0;
        PagerBean pager = function.getPager();
        if (pager != null) {
            int pageNo = 0;
            String paramName = function.getPager().getParamName();
            pageNo = this._requestParams.get(paramName) != null && this._requestParams.get(paramName).length > 0 && !StringUtils.isEmpty((CharSequence)this._requestParams.get(paramName)[0]) ? Integer.parseInt(this._requestParams.get(paramName)[0]) : 1;
            PagingUtils pageInfo = new PagingUtils(this._resultMap, function.getResult(), count, pageNo, Integer.parseInt(pager.getPerPage()), Integer.parseInt(pager.getPagerCount()));
            offset = pageInfo.recordBeginNo - 1;
            limit = pageInfo.perPage;
        } else {
            if (!StringUtils.isEmpty((CharSequence)function.getOffset())) {
                offset = Integer.parseInt(function.getOffset());
            }
            if (!StringUtils.isEmpty((CharSequence)function.getLimit())) {
                limit = Integer.parseInt(function.getLimit());
            }
        }
        if (offset != 0 || limit != 0) {
            rowBounds = new RowBounds(offset, limit);
        }
        return rowBounds;
    }
}

