/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.fuction;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;

public class JavaMailer {
    protected final Pattern ADDRESS_PATTERN = Pattern.compile("(.+)?<(.+)>");
    protected String charset = "ISO-2022-JP";
    protected String host;
    protected String port;
    protected String username;
    protected String password;
    protected Integer connectiontimeout;
    protected Integer timeout;
    protected InternetAddress from;
    protected InternetAddress[] to;
    protected InternetAddress[] cc;
    protected InternetAddress[] bcc;
    protected String subject;
    protected String body;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setServerInfo(String host, String port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void setTimeout(Integer connectionTimeout, Integer sendTimeout) {
        this.connectiontimeout = connectionTimeout;
        this.timeout = sendTimeout;
    }

    public void setFrom(String address, String name) throws UnsupportedEncodingException, AddressException {
        this.from = StringUtils.isEmpty((CharSequence)name) ? new InternetAddress(address, name, this.charset) : new InternetAddress(address);
    }

    public void addTo(String addresses) throws AddressException, UnsupportedEncodingException {
        this.to = this.addInternetAddress(this.to, addresses);
    }

    public void addCc(String addresses) throws AddressException, UnsupportedEncodingException {
        this.cc = this.addInternetAddress(this.cc, addresses);
    }

    public void addBcc(String addresses) throws AddressException, UnsupportedEncodingException {
        this.bcc = this.addInternetAddress(this.bcc, addresses);
    }

    public void clearInternetAddress() {
        this.to = null;
        this.cc = null;
        this.bcc = null;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void send() throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.host);
        props.setProperty("mail.smtp.port", this.port);
        if (!StringUtils.isEmpty((CharSequence)this.username) && !StringUtils.isEmpty((CharSequence)this.password)) {
            props.setProperty("mail.smtp.auth", "true");
        }
        if (this.connectiontimeout != null) {
            props.put("mail.smtp.connectiontimeout", this.connectiontimeout);
        }
        if (this.timeout != null) {
            props.put("mail.smtp.timeout", this.timeout);
        }
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setRecipients(Message.RecipientType.TO, (Address[])this.to);
            if (this.cc != null) {
                message.setRecipients(Message.RecipientType.CC, (Address[])this.cc);
            }
            if (this.bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])this.bcc);
            }
            if (this.from != null) {
                message.setFrom((Address)this.from);
            }
            message.setSubject(this.subject, this.charset);
            message.setContent((Object)this.body, "text/html; charset=" + this.charset);
            message.saveChanges();
            if (!StringUtils.isEmpty((CharSequence)this.username) && !StringUtils.isEmpty((CharSequence)this.password)) {
                Transport transport = session.getTransport("smtp");
                transport.connect(this.username, this.password);
                transport.sendMessage((Message)message, message.getAllRecipients());
                transport.close();
            } else {
                Transport.send((Message)message);
                message.writeTo((OutputStream)System.out);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InternetAddress[] addInternetAddress(InternetAddress[] prop, String addresses) throws AddressException, UnsupportedEncodingException {
        String[] array;
        ArrayList<InternetAddress> tmpAddress = new ArrayList<InternetAddress>();
        if (prop != null && prop.length > 0) {
            tmpAddress.addAll(Arrays.asList(prop));
        }
        String[] stringArray = array = addresses.split(",");
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String one = stringArray[n2];
            Matcher m = this.ADDRESS_PATTERN.matcher(one);
            if (m.find()) {
                tmpAddress.add(new InternetAddress(m.group(2).trim(), m.group(1).trim(), this.charset));
            } else {
                tmpAddress.add(new InternetAddress(one.trim()));
            }
            ++n2;
        }
        return tmpAddress.toArray(new InternetAddress[1]);
    }
}

