/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.fuction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.CrudBean;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.LoadBean;
import jp.co.headwaters.webappos.controller.cache.bean.ProcedureArgBean;
import jp.co.headwaters.webappos.controller.cache.bean.ProcedureInfoBean;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

public class ProcedureFunction
extends AbstractFunction {
    @Override
    protected void execute(AbstractExecuteBean function) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        CrudBean crudFunction = (CrudBean)function;
        ProcedureInfoBean procedureInfo = WebAppOSCache.getInstance().getProcedureMap().get(crudFunction.getTarget().toLowerCase());
        this.executeProcedure(crudFunction, procedureInfo);
    }

    private void executeProcedure(CrudBean function, ProcedureInfoBean procedureInfo) throws WebAppOSException {
        String resultName = function.getResult();
        String mapperName = this.getMapperName(procedureInfo.getName());
        Map<String, Object> params = this.createParams(function, procedureInfo);
        List entityList = null;
        entityList = procedureInfo.getArgNum() == 0 ? this._sqlSession.selectList(mapperName) : this._sqlSession.selectList(mapperName, params);
        if (!DataTypeEnum.DATA_TYPE_VOID.equals((Object)procedureInfo.getRetType())) {
            if (!entityList.isEmpty()) {
                if (DataTypeEnum.DATA_TYPE_RECORD.equals((Object)procedureInfo.getRetType())) {
                    HashMap rootMap = new HashMap();
                    ArrayList resultList = new ArrayList();
                    rootMap.put(function.getTarget(), resultList);
                    this._resultMap.put(resultName, rootMap);
                    RowBounds rowBounds = null;
                    try {
                        rowBounds = this.createRowBounds(function, entityList.size());
                    }
                    catch (NotFoundException e) {
                        if (function instanceof LoadBean && ((LoadBean)function).isNotFooundError()) {
                            throw new NotFoundException();
                        }
                        this._resultMap.put(resultName, new ArrayList());
                        return;
                    }
                    if (rowBounds != null) {
                        int fromIndex = entityList.size() < rowBounds.getOffset() ? entityList.size() : rowBounds.getOffset();
                        int toIndex = entityList.size() < fromIndex + rowBounds.getLimit() ? entityList.size() : fromIndex + rowBounds.getLimit();
                        entityList = entityList.subList(fromIndex, toIndex);
                    }
                    int i = 0;
                    while (i < entityList.size()) {
                        HashMap record = new HashMap();
                        HashMap element = (HashMap)entityList.get(i);
                        for (Map.Entry obj : element.entrySet()) {
                            record.put(((String)obj.getKey()).toUpperCase(), obj.getValue());
                        }
                        resultList.add(record);
                        ++i;
                    }
                } else {
                    HashMap<String, String> record = new HashMap<String, String>();
                    if (procedureInfo.getOutNames().size() == 0) {
                        record.put(procedureInfo.getName().toUpperCase(), ConvertDateTypeUtils.convertDbTypeToString(entityList.get(0)));
                    } else {
                        record.put(procedureInfo.getOutNames().get(0).toUpperCase(), ConvertDateTypeUtils.convertDbTypeToString(entityList.get(0)));
                    }
                    this._resultMap.put(resultName, record);
                }
            } else {
                this.createRowBounds(function, 0);
                this._resultMap.put(resultName, new ArrayList());
                if (function instanceof LoadBean && ((LoadBean)function).isNotFooundError()) {
                    throw new NotFoundException();
                }
            }
        }
    }

    private String getMapperName(String target) {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("root.package"));
        sb.append('.');
        sb.append("mapper");
        sb.append('.');
        sb.append("ProcedureMapper");
        sb.append('.');
        sb.append(target);
        return sb.toString();
    }

    private Map<String, Object> createParams(CrudBean function, ProcedureInfoBean procedureInfo) throws WebAppOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!this.createParamFromCache(function, procedureInfo, params)) {
            return null;
        }
        if (function instanceof FunctionBean) {
            this.createParamFromRequest(function, procedureInfo, params);
        }
        return params;
    }

    private boolean createParamFromCache(CrudBean function, ProcedureInfoBean procedureInfo, Map<String, Object> params) throws WebAppOSException {
        if (function.getArgs() != null) {
            for (ProcedureArgBean arg : function.getArgs()) {
                String value = arg.getValue();
                if (!StringUtils.isEmpty((CharSequence)(value = this.getParameter(value)))) {
                    params.put(arg.getName().toLowerCase(), ConvertDateTypeUtils.convertStringToDbType(value, procedureInfo.getArgs().get(arg.getName().toLowerCase()).getDataType()));
                    continue;
                }
                params.put(arg.getName().toLowerCase(), null);
            }
        }
        return true;
    }

    private void createParamFromRequest(CrudBean function, ProcedureInfoBean procedureInfo, Map<String, Object> params) throws WebAppOSException {
        for (Map.Entry reqParam : this._requestParams.entrySet()) {
            String[] values = (String[])reqParam.getValue();
            String[] keys = ((String)reqParam.getKey()).split("__", 5);
            if (keys.length < 3 || !keys[0].equals(function.getResult()) || !"COL".equals(keys[1])) continue;
            params.put(keys[2].toLowerCase(), ConvertDateTypeUtils.convertStringToDbType(values[0], procedureInfo.getArgs().get(keys[2].toLowerCase()).getDataType()));
        }
    }
}

