/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.enumation.ServiceProviderEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.oauth.ConsumerProperties;
import jp.co.headwaters.webappos.controller.oauth.OAuthConsumer;
import jp.co.headwaters.webappos.controller.session.OAuthBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;

public abstract class AbstractOAuthClient
extends AbstractFunction {
    protected static final Log _logger = LogFactory.getLog(AbstractOAuthClient.class);
    protected ServiceProviderEnum provider;
    protected String resourceUrl;

    @Override
    protected void execute(AbstractExecuteBean function) throws Exception {
    }

    public abstract void oauth(HttpServletRequest var1, HttpServletResponse var2, OAuthBean var3) throws Exception;

    public abstract void callback(HttpServletRequest var1, HttpServletResponse var2, OAuthBean var3) throws Exception;

    public abstract void users(HttpServletRequest var1, HttpServletResponse var2, OAuthBean var3) throws Exception;

    protected String getContentType(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey() == null || !"content-type".equals(header.getKey().toLowerCase())) continue;
            return header.getValue();
        }
        return null;
    }

    public void disconnect(HttpServletRequest request, HttpServletResponse response, String provider, String userId) throws Exception {
        this.removeOAuthData(request, provider, userId);
    }

    public HashMap<String, Object> getUserData(SqlSession sqlSession, String provider, String uid) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), "_webappos_oauth_manager");
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("provider", provider);
            criteria.andEqualTo("uid", uid);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            if (entityList.size() == 1) {
                Object oauthManager = entityList.get(0);
                Method method = oauthManager.getClass().getMethod("getUserId", new Class[0]);
                SchemaColumnBean addressColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "id"));
                Object userId = ConvertDateTypeUtils.convertStringToDbType(String.valueOf(method.invoke(oauthManager, null)), addressColumn);
                String authTableName = PropertyUtils.getProperty("auth.table.name");
                mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod(), authTableName);
                example = new CommonExample();
                criteria = example.createCriteria();
                criteria.andEqualTo(String.valueOf(authTableName) + '.' + "id", userId);
                List user = sqlSession.selectList(mapperName, (Object)example);
                if (user.size() == 1) {
                    return DaoUtils.convertEntityToMap(user.get(0), true);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void removeOAuthData(HttpServletRequest request, String provider, String userId) throws WebAppOSException {
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession();
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            String mapperName = DaoUtils.getMapperName(CrudEnum.DELETE.getMethod(), "_webappos_oauth_manager");
            Object dbProvider = ConvertDateTypeUtils.convertStringToDbType("_webappos_oauth_manager", "provider", provider);
            Object dbUserId = ConvertDateTypeUtils.convertStringToDbType("_webappos_oauth_manager", "user_id", userId);
            criteria.andEqualTo("provider", dbProvider);
            criteria.andEqualTo("user_id", dbUserId);
            sqlSession.delete(mapperName, (Object)example);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                HashMap loginUser = (HashMap)httpSession.getAttribute("LOGIN_USER");
                Map<String, Object> newUser = AuthUtils.refreshLoginUserData(sqlSession, loginUser);
                httpSession.setAttribute("LOGIN_USER", newUser);
            }
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
    }

    protected String addParameter(String uri) throws MalformedURLException {
        StringBuilder sb = new StringBuilder(uri);
        OAuthConsumer consumer = ConsumerProperties.getConsumer(this.provider.getName());
        for (Map.Entry<String, Object> param : consumer.getParameters().entrySet()) {
            sb.append("&");
            sb.append(param.getKey());
            sb.append("=");
            sb.append(param.getValue());
        }
        return sb.toString();
    }

    protected String getCallbackUrl(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(requestURL.substring(0, requestURL.lastIndexOf("/")));
        sb.append("/auth/callback/");
        sb.append("sp");
        sb.append("/");
        sb.append(this.provider.getName());
        sb.append("/");
        return sb.toString();
    }

    protected void copyAll(InputStream from, OutputStream into) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = from.read(buffer, 0, buffer.length)) > 0) {
            into.write(buffer, 0, len);
        }
    }

    public void setProvider(ServiceProviderEnum provider) {
        this.provider = provider;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }
}

