/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.oauth.AbstractOAuthClient;
import jp.co.headwaters.webappos.controller.oauth.ConsumerProperties;
import jp.co.headwaters.webappos.controller.oauth.OAuthConsumer;
import jp.co.headwaters.webappos.controller.session.OAuthBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import org.apache.ibatis.session.SqlSession;

public class OAuthClient10aImpl
extends AbstractOAuthClient {
    private DefaultApi10a providerApi;

    public OAuthClient10aImpl(DefaultApi10a api) {
        this.providerApi = api;
    }

    @Override
    public void oauth(HttpServletRequest request, HttpServletResponse response, OAuthBean oAuthData) throws Exception {
        String providerName = oAuthData.getProviderName();
        OAuthConsumer consumer = ConsumerProperties.getConsumer(providerName);
        OAuth10aService service = (OAuth10aService)new ServiceBuilder().apiKey(consumer.getApiKey()).apiSecret(consumer.getApiSecret()).callback(this.getCallbackUrl(request)).build((BaseApi)this.providerApi);
        OAuth1RequestToken requestToken = service.getRequestToken();
        oAuthData.setRequestToken((Token)requestToken);
        String authorizationUrl = service.getAuthorizationUrl(requestToken);
        response.sendRedirect(this.addParameter(authorizationUrl));
    }

    @Override
    public void callback(HttpServletRequest request, HttpServletResponse response, OAuthBean oAuthData) throws Exception {
        String providerName = oAuthData.getProviderName();
        OAuthConsumer consumer = ConsumerProperties.getConsumer(providerName);
        OAuth10aService service = (OAuth10aService)new ServiceBuilder().apiKey(consumer.getApiKey()).apiSecret(consumer.getApiSecret()).callback(this.getCallbackUrl(request)).build((BaseApi)this.providerApi);
        String redirectUri = (String)request.getSession().getAttribute("LOGIN_REDIRECT_URI");
        OAuth1AccessToken accessToken = this.getAccessToken(request, service, oAuthData);
        if (accessToken == null) {
            _logger.warn((Object)MessageUtils.getString("err.500"));
            response.sendRedirect(oAuthData.getFailuretUri());
            return;
        }
        String uid = this.getUid(service, accessToken);
        if (uid == null) {
            response.sendRedirect(oAuthData.getFailuretUri());
            return;
        }
        String userId = oAuthData.getUserId();
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        httpSession = request.getSession(true);
        oAuthData.setUid(uid);
        oAuthData.setAccessToken((Token)accessToken);
        oAuthData.setUserId(userId);
        httpSession.setAttribute(OAuthBean.getKey(), (Object)oAuthData);
        httpSession.setAttribute("LOGIN_REDIRECT_URI", (Object)redirectUri);
        SqlSession sqlSession = null;
        try {
            HashMap<String, Object> user;
            sqlSession = DaoUtils.openSqlSession(false);
            if (oAuthData.getUserId() != null) {
                AuthUtils.registerOAuthData(sqlSession, providerName, oAuthData.getUserId(), uid);
            }
            if ((user = this.getUserData(sqlSession, providerName, uid)) == null || user.get(AuthUtils.getAuthColumnName("id")) == null) {
                response.sendRedirect(oAuthData.getNotfoundUri());
                return;
            }
            oAuthData.setUserId((String)user.get(AuthUtils.getAuthColumnName("id")));
            httpSession.setAttribute("LOGIN_USER", user);
            httpSession.setAttribute("OAUTH_SUCCESS_URI", (Object)oAuthData.getSuccessUri());
            if (oAuthData.isAutoLogin()) {
                AuthUtils.removeAutoLoginKey(request, response, sqlSession);
                AuthUtils.addAutoLoginKey(request, response, sqlSession, user);
            }
            DaoUtils.commit(sqlSession);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        response.sendRedirect(oAuthData.getSuccessUri());
    }

    @Override
    public void users(HttpServletRequest request, HttpServletResponse response, OAuthBean oAuthData) throws Exception {
        String providerName = oAuthData.getProviderName();
        OAuthConsumer consumer = ConsumerProperties.getConsumer(providerName);
        OAuth10aService service = (OAuth10aService)new ServiceBuilder().apiKey(consumer.getApiKey()).apiSecret(consumer.getApiSecret()).build((BaseApi)this.providerApi);
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, this.resourceUrl);
        service.signRequest(this.getAccessToken(oAuthData), oAuthRequest);
        Response oauthResponse = service.execute(oAuthRequest);
        response.setStatus(oauthResponse.getCode());
        response.setContentType(this.getContentType(oauthResponse.getHeaders()));
        Throwable throwable = null;
        Object var10_11 = null;
        try (InputStream in = oauthResponse.getStream();){
            ServletOutputStream out = response.getOutputStream();
            this.copyAll(in, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private OAuth1RequestToken getRequestToken(OAuthBean oAuthData) {
        OAuth1RequestToken requestToken = null;
        Token token = oAuthData.getRequestToken();
        if (token instanceof OAuth1RequestToken) {
            requestToken = (OAuth1RequestToken)token;
        }
        return requestToken;
    }

    private OAuth1AccessToken getAccessToken(HttpServletRequest request, OAuth10aService service, OAuthBean oAuthData) throws Exception {
        String resonseToken = request.getParameter("oauth_token");
        if (resonseToken == null) {
            return null;
        }
        OAuth1RequestToken requestToken = this.getRequestToken(oAuthData);
        String verifier = request.getParameter("oauth_verifier");
        OAuth1AccessToken accessToken = service.getAccessToken(requestToken, verifier);
        return accessToken;
    }

    private OAuth1AccessToken getAccessToken(OAuthBean oAuthData) {
        OAuth1AccessToken accessToken = null;
        Token token = oAuthData.getAccessToken();
        if (token instanceof OAuth1AccessToken) {
            accessToken = (OAuth1AccessToken)token;
        }
        return accessToken;
    }

    private String getUid(OAuth10aService service, OAuth1AccessToken accessToken) {
        Response oauthResponse;
        block5: {
            try {
                OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, this.resourceUrl);
                service.signRequest(accessToken, oAuthRequest);
                oauthResponse = service.execute(oAuthRequest);
                if (oauthResponse.getCode() != 200) break block5;
                ObjectMapper mapper = new ObjectMapper();
                try {
                    JsonNode node = (JsonNode)mapper.readValue(oauthResponse.getBody(), JsonNode.class);
                    return node.get("id").asText();
                }
                catch (Exception e) {
                    _logger.error((Object)MessageUtils.getString("err.501"), (Throwable)e);
                    return null;
                }
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.501"), (Throwable)e);
                return null;
            }
        }
        _logger.warn((Object)MessageUtils.getString("err.502", String.valueOf(oauthResponse.getCode())));
        return null;
    }
}

