/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import com.github.scribejava.apis.FacebookApi;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.builder.api.DefaultApi20;
import java.io.IOException;
import jp.co.headwaters.webappos.controller.enumation.ServiceProviderEnum;
import jp.co.headwaters.webappos.controller.oauth.AbstractOAuthClient;
import jp.co.headwaters.webappos.controller.oauth.OAuthClient10aImpl;
import jp.co.headwaters.webappos.controller.oauth.OAuthClient20Impl;

public abstract class OAuthClientFactory {
    public static AbstractOAuthClient create(String name) throws IOException {
        AbstractOAuthClient client = null;
        ServiceProviderEnum sp = ServiceProviderEnum.getServiceProvider(name);
        if (sp.equals((Object)ServiceProviderEnum.TWITTER)) {
            client = new OAuthClient10aImpl((DefaultApi10a)TwitterApi.Authenticate.instance());
            client.setResourceUrl("https://api.twitter.com/1.1/account/verify_credentials.json");
        } else if (sp.equals((Object)ServiceProviderEnum.FACEBOOK)) {
            client = new OAuthClient20Impl((DefaultApi20)FacebookApi.instance());
            client.setResourceUrl("https://graph.facebook.com/me");
        }
        client.setProvider(sp);
        return client;
    }
}

