/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.utils;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.security.Cipher;
import jp.co.headwaters.webappos.controller.security.CipherFactory;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;

public class ConvertDateTypeUtils {
    public static String convertDbTypeToString(Object obj) {
        if (obj == null) {
            return null;
        }
        String result = null;
        if (obj.getClass().toString().equals(Date.class.toString())) {
            SimpleDateFormat fomatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            result = fomatter.format((Date)obj);
        } else {
            result = obj.getClass().toString().equals(Boolean.class.toString()) ? (((Boolean)obj).booleanValue() ? "1" : "0") : String.valueOf(obj);
        }
        return result;
    }

    public static Object convertStringToDbType(String tableName, String columnName, String value) throws WebAppOSException {
        SchemaColumnBean schemaColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(tableName, columnName));
        return ConvertDateTypeUtils.convertStringToDbType(value, schemaColumn);
    }

    public static Object convertStringToDbType(String value, SchemaColumnBean schemaColumn) throws WebAppOSException {
        if (schemaColumn == null) {
            return null;
        }
        if (schemaColumn.getColumnComment() != null) {
            if (value == null && !StringUtils.isEmpty((CharSequence)schemaColumn.getColumnComment().getRandom())) {
                value = RandomStringUtils.randomAlphanumeric((int)Integer.parseInt(schemaColumn.getColumnComment().getRandom()));
            }
            if (!StringUtils.isEmpty((CharSequence)schemaColumn.getColumnComment().getCipher())) {
                Cipher cipher = CipherFactory.create(schemaColumn.getColumnComment().getCipher());
                return cipher.encrypt(value);
            }
        }
        return ConvertDateTypeUtils.convertStringToDbType(value, schemaColumn.getDataType().toLowerCase());
    }

    public static Object convertStringToDbType(String value, String dataType) throws WebAppOSException {
        if (value == null || dataType == null) {
            return null;
        }
        Object result = null;
        if (DataTypeEnum.DATA_TYPE_SMALLINT.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_INTEGER.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_BIGINT.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_NUMERIC.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_REAL.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_DOUBLE_PRECISION.getDataType().equals(dataType)) {
            result = ConvertDateTypeUtils.convertStringToNumber(value, dataType);
        } else if (DataTypeEnum.DATA_TYPE_CHARACTER_VARYING.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_CHARACTER.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_TEXT.getDataType().equals(dataType)) {
            result = value;
        } else if (DataTypeEnum.DATA_TYPE_TIMESTAMP_WITHOUT_TIME_ZONE.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_DATE.getDataType().equals(dataType)) {
            result = ConvertDateTypeUtils.convertStringToDate(value);
        } else if (DataTypeEnum.DATA_TYPE_BYTEA.getDataType().equals(dataType)) {
            result = value.getBytes();
        } else if (DataTypeEnum.DATA_TYPE_BOOLEAN.getDataType().equals(dataType)) {
            result = value.toString().equals("1") || value.toString().equals("t") ? Boolean.TRUE : Boolean.valueOf(value.toString());
        } else if (DataTypeEnum.DATA_TYPE_BIT.getDataType().equals(dataType) || DataTypeEnum.DATA_TYPE_BIT_VARYING.getDataType().equals(dataType)) {
            try {
                PGobject obj = new PGobject();
                obj.setType("bit");
                obj.setValue(value.toString());
                result = obj;
            }
            catch (SQLException e) {
                throw new WebAppOSException(e);
            }
        } else {
            throw new WebAppOSException("err.900");
        }
        return result;
    }

    public static Date convertStringToDate(String value) {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        value = ConvertDateTypeUtils.getDefualtPatternString(value);
        int yyyy = Integer.parseInt(value.substring(0, 4));
        int MM = Integer.parseInt(value.substring(5, 7));
        int dd = Integer.parseInt(value.substring(8, 10));
        int HH = Integer.parseInt(value.substring(11, 13));
        int mm = Integer.parseInt(value.substring(14, 16));
        int ss = Integer.parseInt(value.substring(17, 19));
        int SSS = Integer.parseInt(value.substring(20, 23));
        cal.clear();
        cal.set(yyyy, MM - 1, dd);
        cal.set(11, HH);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, SSS);
        return cal.getTime();
    }

    private static String getDefualtPatternString(String target) {
        if (StringUtils.isEmpty((CharSequence)target)) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String yyyy = null;
        String MM = "01";
        String dd = "01";
        String HH = "00";
        String mm = "00";
        String ss = "00";
        String SSS = "000";
        if (target.indexOf("/") == -1 && target.indexOf("-") == -1) {
            if (target.length() >= 4) {
                yyyy = target.substring(0, 4);
            }
            if (target.length() >= 6) {
                MM = target.substring(4, 6);
            }
            if (target.length() >= 8) {
                dd = target.substring(6, 8);
            }
            if (target.length() >= 10) {
                HH = target.substring(8, 10);
            }
            if (target.length() >= 12) {
                mm = target.substring(10, 12);
            }
            if (target.length() >= 14) {
                ss = target.substring(12, 14);
            }
            if (target.length() >= 17) {
                SSS = target.substring(14, 17);
            }
        } else {
            StringTokenizer token = new StringTokenizer(target, "_/-:. ");
            int i = 0;
            while (token.hasMoreTokens()) {
                String temp = token.nextToken();
                switch (i) {
                    case 0: {
                        if (temp.length() == 2) {
                            yyyy = String.format("20%s", temp);
                            break;
                        }
                        yyyy = temp;
                        break;
                    }
                    case 1: {
                        MM = String.format("%1$02d", Integer.parseInt(temp));
                        break;
                    }
                    case 2: {
                        dd = String.format("%1$02d", Integer.parseInt(temp));
                        break;
                    }
                    case 3: {
                        HH = String.format("%1$02d", Integer.parseInt(temp));
                        break;
                    }
                    case 4: {
                        mm = String.format("%1$02d", Integer.parseInt(temp));
                        break;
                    }
                    case 5: {
                        ss = String.format("%1$02d", Integer.parseInt(temp));
                        break;
                    }
                    case 6: {
                        SSS = String.format("%1$03d", Integer.parseInt(temp));
                    }
                }
                ++i;
            }
        }
        result.append(yyyy);
        result.append("/");
        result.append(MM);
        result.append("/");
        result.append(dd);
        result.append(" ");
        result.append(HH);
        result.append(":");
        result.append(mm);
        result.append(":");
        result.append(ss);
        result.append(".");
        result.append(SSS);
        return result.toString();
    }

    public static Number convertStringToNumber(String value, String dataType) {
        Number result = null;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (DataTypeEnum.DATA_TYPE_SMALLINT.getDataType().equals(dataType)) {
            result = Short.valueOf(value);
        } else if (DataTypeEnum.DATA_TYPE_INTEGER.getDataType().equals(dataType)) {
            result = Integer.valueOf(value);
        } else if (DataTypeEnum.DATA_TYPE_BIGINT.getDataType().equals(dataType)) {
            result = Long.valueOf(value);
        } else if (DataTypeEnum.DATA_TYPE_NUMERIC.getDataType().equals(dataType)) {
            result = new BigDecimal(value);
        } else if (DataTypeEnum.DATA_TYPE_REAL.getDataType().equals(dataType)) {
            result = Float.valueOf(value);
        } else if (DataTypeEnum.DATA_TYPE_DOUBLE_PRECISION.getDataType().equals(dataType)) {
            result = Double.valueOf(value);
        }
        return result;
    }
}

