/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;

public class PagingUtils {
    public Integer recordCount;
    public Integer perPage;
    public Integer recordBeginNo;
    public Integer recordEndNo;
    public ArrayList<String> pageNoList;
    public Integer pageNo;
    public Integer prevPageNo;
    public Integer nextPageNo;
    public Integer pagingBeginNo;
    public Integer pagingEndNo;
    public Integer maxPageNo;

    public PagingUtils(Map<String, Object> resultMap, String resultName, int recordCount, int pageNo, int limitPage, int pagingCount) throws NotFoundException {
        this.recordCount = recordCount;
        this.perPage = limitPage > 0 ? limitPage : 1;
        this.maxPageNo = (int)Math.ceil((double)this.recordCount.intValue() * 1.0 / (double)this.perPage.intValue());
        if (this.maxPageNo == 0) {
            this.maxPageNo = 1;
        }
        this.pageNo = pageNo < 1 ? 1 : pageNo;
        if (this.pageNo > this.maxPageNo) {
            throw new NotFoundException();
        }
        this.prevPageNo = this.pageNo - 1;
        this.nextPageNo = this.pageNo == this.maxPageNo ? Integer.valueOf(0) : Integer.valueOf(this.pageNo + 1);
        this.pagingBeginNo = this.pageNo - pagingCount <= 0 ? Integer.valueOf(1) : Integer.valueOf(this.pageNo - pagingCount);
        this.pagingEndNo = this.pagingBeginNo + pagingCount * 2 - 1;
        if (this.pagingEndNo > this.maxPageNo) {
            this.pagingEndNo = this.maxPageNo;
        }
        this.pageNoList = new ArrayList();
        int i = this.pagingBeginNo;
        while (i <= this.pagingEndNo) {
            this.pageNoList.add(String.valueOf(i));
            ++i;
        }
        Integer start = this.pageNo == 1 ? Integer.valueOf(1) : Integer.valueOf((this.pageNo - 1) * this.perPage + 1);
        Integer end = this.pageNo == this.maxPageNo ? Integer.valueOf(this.recordCount) : Integer.valueOf(this.pageNo * this.perPage);
        if (this.recordCount == 0) {
            start = 0;
            end = 0;
            this.pageNoList = new ArrayList();
            this.prevPageNo = 0;
            this.nextPageNo = 0;
        }
        this.recordBeginNo = start;
        this.recordEndNo = end;
        resultMap.put(PagingUtils.getPageInfoName(resultName), this.setPageInfo());
    }

    private static String getPageInfoName(String resultName) {
        StringBuilder sb = new StringBuilder();
        sb.append("_PAGER");
        sb.append("__");
        sb.append(resultName.toUpperCase());
        return sb.toString();
    }

    private Map<String, Object> setPageInfo() {
        HashMap<String, Object> pageInfo = new HashMap<String, Object>();
        pageInfo.put("RECORD_COUNT", this.recordCount);
        pageInfo.put("PER_PAGE", this.perPage);
        pageInfo.put("RECORD_BEGIN_NO", this.recordBeginNo);
        pageInfo.put("RECORD_END_NO", this.recordEndNo);
        pageInfo.put("PAGE_NO", this.pageNo);
        pageInfo.put("PREV_PAGE_NO", this.prevPageNo);
        pageInfo.put("NEXT_PAGE_NO", this.nextPageNo);
        pageInfo.put("PAGING_BEGIN_NO", this.pagingBeginNo);
        pageInfo.put("PAGING_END_NO", this.pagingEndNo);
        pageInfo.put("MAX_PAGE_NO", this.maxPageNo);
        pageInfo.put("PAGE_NO_LIST", this.pageNoList);
        return pageInfo;
    }
}

