/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.action;

import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.headwaters.webappos.controller.action.AbstractAction;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.SystemConstantCache;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.ActionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.LoadBean;
import jp.co.headwaters.webappos.controller.cache.bean.ResultBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.cache.bean.SystemConstantBean;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.exception.ConflictException;
import jp.co.headwaters.webappos.controller.exception.InvalidTokenException;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.fuction.FunctionFactory;
import jp.co.headwaters.webappos.controller.security.Cipher;
import jp.co.headwaters.webappos.controller.security.CipherFactory;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;

public class GenericAction
extends AbstractAction {
    private static final Log _logger = LogFactory.getLog(GenericAction.class);
    private Map<String, String[]> _requestParams;
    private Map<String, Object> _resultMap = new HashMap<String, Object>();
    private ActionBean _actionBean;
    private List<File> _uploadFiles;
    private Cipher _cipher = CipherFactory.create("blowfish");

    public String execute() throws Exception {
        try {
            SqlSession sqlSession;
            this._uploadFiles = new ArrayList<File>();
            this._requestParams = new HashMap<String, String[]>(this._request.getParameterMap());
            this.setResultMapFromRequestParams();
            String actionName = ActionContext.getContext().getName();
            String resultName = (String)this._request.getAttribute("_RESULT_NAME_");
            this._actionBean = WebAppOSCache.getInstance().getActionMap().get(actionName);
            if (this._actionBean == null || resultName == null) {
                throw new NotFoundException();
            }
            ExecuteBean submitExecuteInfo = null;
            ExecuteBean loadExecuteInfo = null;
            ResultBean result = null;
            String formId = null;
            if (this._requestParams != null && this._requestParams.get("_SYS_FORM_ID_") != null) {
                formId = this._requestParams.get("_SYS_FORM_ID_")[0];
            }
            if (!StringUtils.isEmpty(formId)) {
                submitExecuteInfo = this._actionBean.getSubmitExecuteMap().get(formId);
                if (submitExecuteInfo == null) {
                    throw new NotFoundException();
                }
                result = submitExecuteInfo.getResultInfo();
                loadExecuteInfo = this.getLoadExecute(resultName);
                if (loadExecuteInfo != null) {
                    result = loadExecuteInfo.getResultInfo();
                }
            } else {
                loadExecuteInfo = this.getLoadExecute(resultName);
                if (loadExecuteInfo != null) {
                    result = loadExecuteInfo.getResultInfo();
                }
            }
            if (result == null) {
                throw new NotFoundException();
            }
            HashMap<String, Map<Integer, Integer>> ids = new HashMap<String, Map<Integer, Integer>>();
            if (submitExecuteInfo != null) {
                sqlSession = null;
                try {
                    try {
                        if (submitExecuteInfo.getExecuteInfoList().size() > 0) {
                            sqlSession = DaoUtils.openSqlSession(false);
                            if (!this.uploadFiles()) {
                                this.removeUploadFiles();
                            }
                            int i = 0;
                            while (i < submitExecuteInfo.getExecuteInfoList().size()) {
                                FunctionBean info = (FunctionBean)submitExecuteInfo.getExecuteInfoList().get(i);
                                if (i == 0 && info.isTokenValidation() && !this.validateToken()) {
                                    throw new InvalidTokenException("err.901");
                                }
                                AbstractFunction function = FunctionFactory.create(info.getType());
                                function.setSqlSession(sqlSession);
                                function.setHttpSession(this._session);
                                function.setIds(ids);
                                function.execute(this._requestParams, this._resultMap, info);
                                if (info.getTarget() != null) {
                                    ids.put(ControllerUtils.getSchemaColumnKey(info.getTarget(), "id"), info.getId());
                                }
                                ++i;
                            }
                            DaoUtils.commit(sqlSession);
                        }
                    }
                    catch (Exception e) {
                        DaoUtils.rollback(sqlSession);
                        this.removeUploadFiles();
                        throw e;
                    }
                }
                finally {
                    DaoUtils.closeSqlSession(sqlSession);
                }
            }
            if (loadExecuteInfo != null) {
                sqlSession = null;
                try {
                    try {
                        if (loadExecuteInfo.getExecuteInfoList().size() > 0) {
                            sqlSession = DaoUtils.openSqlSession(false);
                            for (AbstractExecuteBean executeInfo : loadExecuteInfo.getExecuteInfoList()) {
                                LoadBean info = (LoadBean)executeInfo;
                                AbstractFunction function = FunctionFactory.create(info.getType());
                                function.setSqlSession(sqlSession);
                                function.setHttpSession(this._session);
                                function.execute(this._requestParams, this._resultMap, info);
                                ids.put(ControllerUtils.getSchemaColumnKey(info.getTarget(), "id"), info.getId());
                            }
                            DaoUtils.commit(sqlSession);
                        }
                    }
                    catch (Exception e) {
                        DaoUtils.rollback(sqlSession);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    DaoUtils.closeSqlSession(sqlSession);
                    throw throwable;
                }
                DaoUtils.closeSqlSession(sqlSession);
            }
            this.setResultMapFromConstant();
            _logger.debug((Object)("result:" + result.getName()));
            return result.getName();
        }
        catch (InvalidTokenException e) {
            throw e;
        }
        catch (ConflictException e) {
            throw e;
        }
        catch (NotFoundException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void setResultMapFromRequestParams() {
        if (!this._resultMap.containsKey("_REQ")) {
            this._resultMap.put("_REQ", new HashMap());
        }
        for (Map.Entry<String, String[]> entry : this._requestParams.entrySet()) {
            String[] keys = entry.getKey().split("__", 5);
            String[] values = entry.getValue();
            if (keys.length <= 2) {
                HashMap reqMap = (HashMap)this._resultMap.get("_REQ");
                if (values.length > 1) {
                    reqMap.put(entry.getKey().toUpperCase(), values);
                    continue;
                }
                if (values.length != 1) continue;
                reqMap.put(entry.getKey().toUpperCase(), values[0]);
                continue;
            }
            this._resultMap.put(entry.getKey(), values);
        }
    }

    private ExecuteBean getLoadExecute(String resultName) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this._actionBean.getHtmlPath())) {
            sb.append(this._actionBean.getHtmlPath());
            sb.append(ControllerUtils.getFileSparator());
        }
        sb.append(resultName);
        sb.append(".jsp");
        return this._actionBean.getLoadExecuteMap().get(sb.toString());
    }

    private void setResultMapFromConstant() {
        HashMap<String, String> constMap = new HashMap<String, String>();
        List<SystemConstantBean> viewConsts = SystemConstantCache.getSystemConstantList("VIEW");
        for (SystemConstantBean viewConst : viewConsts) {
            constMap.put(viewConst.getKey(), viewConst.getValue());
        }
        this._resultMap.put("_CONST", constMap);
    }

    private boolean uploadFiles() throws IOException {
        if (this._request instanceof MultiPartRequestWrapper) {
            MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
            if (multiWrapper.hasErrors()) {
                Collection errors = multiWrapper.getErrors();
                Iterator i = errors.iterator();
                while (i.hasNext()) {
                    this.addActionError((String)i.next());
                }
                return false;
            }
            Enumeration e = multiWrapper.getFileParameterNames();
            while (e.hasMoreElements()) {
                String inputValue = (String)e.nextElement();
                String[] fileNames = multiWrapper.getFileNames(inputValue);
                String[] fileSystemNames = multiWrapper.getFileSystemNames(inputValue);
                String[] contentTypes = multiWrapper.getContentTypes(inputValue);
                File[] files = multiWrapper.getFiles(inputValue);
                String[] uploadFileNames = new String[files.length];
                String[] keys = inputValue.split("__");
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (file == null) {
                        this.addActionError("Error uploading: " + multiWrapper.getFileNames(inputValue));
                        return false;
                    }
                    File uploadFile = this.saveFile(file, keys[0].toLowerCase(), fileSystemNames[i], fileNames[i]);
                    uploadFileNames[i] = this.getSaveFilePath(uploadFile);
                    ++i;
                }
                this._requestParams.put(inputValue, uploadFileNames);
                this._requestParams.put(String.valueOf(inputValue) + "_content_type", contentTypes);
            }
        }
        return true;
    }

    private File saveFile(File reqFile, String dest, String fileSystemName, String fileName) throws IOException {
        String destFilePath = this.getDestFilePath(dest, fileSystemName, fileName);
        _logger.debug((Object)destFilePath);
        File destFile = new File(destFilePath);
        FileUtils.copyFile((File)reqFile, (File)destFile);
        this._uploadFiles.add(destFile);
        return destFile;
    }

    private String getSaveFilePath(File uploadFile) {
        StringBuilder baseDir = new StringBuilder();
        baseDir.append(this.getText("base.dir"));
        if (!baseDir.toString().endsWith(ControllerUtils.getFileSparator())) {
            baseDir.append(ControllerUtils.getFileSparator());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ControllerUtils.getFileSparator());
        sb.append(uploadFile.getAbsolutePath().substring(baseDir.toString().length()));
        return sb.toString();
    }

    private void removeUploadFiles() {
        for (File file : this._uploadFiles) {
            file.delete();
        }
    }

    private String getDestFilePath(String dest, String fileSystemName, String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getText("base.dir"));
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        if (dest != null) {
            sb.append(dest);
        }
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        if (this.isLoggedIn()) {
            sb.append(this.getLoginUserInfo("id"));
        } else {
            sb.append("anon");
        }
        sb.append(ControllerUtils.getFileSparator());
        sb.append(ControllerUtils.removeFileExtension(fileSystemName));
        sb.append('.');
        sb.append(ControllerUtils.getFileExtension(fileName));
        return sb.toString();
    }

    public Map<String, Object> getResultMap() {
        return this._resultMap;
    }

    public void setResultMap(Map<String, Object> _resultMap) {
        this._resultMap = _resultMap;
    }

    public String eraseTag(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("<.+?>", "");
    }

    public String getValue(String key, String mapKey) {
        return this.getValue(this._resultMap, key, mapKey);
    }

    public String getEncodeValue(String key) throws UnsupportedEncodingException {
        String result = null;
        try {
            result = this._cipher.encrypt(this.getValue(this._resultMap, key, null, null));
        }
        catch (WebAppOSException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return URLEncoder.encode(result, "UTF-8");
    }

    public String getValue(String key, String defaultKey, String mapKey) {
        return this.getValue(this._resultMap, key, defaultKey, mapKey);
    }

    public String getValueWithDateFormat(String key, String pattern) {
        return this.getValueWithDateFormat(key, null, pattern);
    }

    public String getValueWithDateFormat(String key, String defaultKey, String pattern) {
        String value = this.getValue(key, defaultKey, null);
        if (value == null) {
            return null;
        }
        return this.getDateFormatValue(value, pattern);
    }

    public String getValueWithNumberFormat(String key, String pattern) {
        return this.getValueWithNumberFormat(key, null, pattern);
    }

    public String getValueWithNumberFormat(String key, String defaultKey, String pattern) {
        String value = this.getValue(key, defaultKey, null);
        if (value == null) {
            return null;
        }
        return this.getNumberFormatValue(value, DataTypeEnum.DATA_TYPE_NUMERIC.getDataType(), pattern);
    }

    public String getValue(Map<?, ?> map, String key, String mapKey) {
        return this.getValue(map, key, null, mapKey);
    }

    public String getEncodeValue(Map<?, ?> map, String key) throws UnsupportedEncodingException {
        String result = null;
        try {
            result = this._cipher.encrypt(this.getValue(map, key, null, null));
        }
        catch (WebAppOSException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return URLEncoder.encode(result, "UTF-8");
    }

    public String getValue(Map<?, ?> map, String key, String defaultKey, String mapKey) {
        String[] keys = key.split("\\.");
        String result = null;
        if ("_SES".equalsIgnoreCase(keys[0])) {
            if ("LOGIN_USER".equalsIgnoreCase(keys[1])) {
                return this.getLoginUserInfo(keys[keys.length - 1]);
            }
            if ("LOGIN_REDIRECT_URI".equalsIgnoreCase(keys[1]) && this._session.containsKey("LOGIN_REDIRECT_URI")) {
                return (String)this._session.get("LOGIN_REDIRECT_URI");
            }
        } else if (map.containsKey(keys[0])) {
            Object obj = map.get(keys[0]);
            if (obj instanceof Map) {
                result = this.getValue((Map)obj, key, 1);
            } else if (obj instanceof Object[]) {
                Object[] array = (Object[])obj;
                if (array.length == 1) {
                    result = String.valueOf(array[0]);
                }
            } else {
                result = String.valueOf(obj);
            }
        }
        if (result == null && defaultKey != null) {
            String[] defaultKeys = defaultKey.split("\\.");
            Object obj = this._resultMap.get(defaultKeys[0]);
            result = obj instanceof Map ? this.getValue((Map)obj, defaultKey, 1) : (obj != null ? String.valueOf(obj) : defaultKey);
        }
        if (!StringUtils.isEmpty((CharSequence)mapKey)) {
            result = this.getValueFromConstMap(result, mapKey);
        }
        return result;
    }

    private String getValueFromConstMap(String target, String mapKey) {
        String[] keys;
        SystemConstantBean systemConstant;
        String result = target;
        if (mapKey != null && mapKey.toUpperCase().startsWith("_CONST") && (systemConstant = SystemConstantCache.getSystemConstant((keys = mapKey.split("\\."))[1], keys[2])).getRealValue() instanceof Map) {
            HashMap map = (HashMap)systemConstant.getRealValue();
            result = (String)map.get(target);
        }
        return result;
    }

    public String getValueWithDateFormat(Map<?, ?> map, String key, String pattern) {
        return this.getValueWithDateFormat(map, key, null, pattern);
    }

    public String getValueWithDateFormat(Map<?, ?> map, String key, String defaultKey, String pattern) {
        String value = this.getValue(map, key, defaultKey, null);
        if (value == null) {
            return null;
        }
        return this.getDateFormatValue(value, pattern);
    }

    public String getValueWithNumberFormat(Map<?, ?> map, String key, String pattern) {
        return this.getValueWithNumberFormat(map, key, null, pattern);
    }

    public String getValueWithNumberFormat(Map<?, ?> map, String key, String defaultKey, String pattern) {
        SchemaColumnBean schemaColumn;
        String value = this.getValue(map, key, defaultKey, null);
        if (value == null) {
            return null;
        }
        String dataType = DataTypeEnum.DATA_TYPE_NUMERIC.getDataType();
        String[] keys = key.split("_");
        if (keys.length == 2 && (schemaColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(keys[0], keys[1]))) != null) {
            dataType = schemaColumn.getDataType();
        }
        return this.getNumberFormatValue(value, dataType, pattern);
    }

    private String getValue(Map<?, ?> map, String key, int depth) {
        String[] keys = key.split("\\.");
        if (keys.length < depth) {
            return null;
        }
        if (!map.containsKey(keys[depth])) {
            return null;
        }
        Object obj = map.get(keys[depth]);
        if (obj instanceof Map) {
            return this.getValue((Map)obj, key, ++depth);
        }
        return String.valueOf(obj);
    }

    private String getDateFormatValue(String value, String pattern) {
        try {
            if (pattern.toUpperCase().startsWith("_CONST")) {
                pattern = this.getValue(pattern.toUpperCase(), null, null);
            }
            SimpleDateFormat formatter = new SimpleDateFormat();
            formatter.applyPattern(pattern);
            return formatter.format(ConvertDateTypeUtils.convertStringToDate(value));
        }
        catch (Exception e) {
            _logger.warn((Object)MessageUtils.getString("warn.103", value), (Throwable)e);
            return value;
        }
    }

    private String getNumberFormatValue(String value, String dataType, String pattern) {
        try {
            if (pattern.toUpperCase().startsWith("_CONST")) {
                pattern = this.getValue(pattern.toUpperCase(), null, null);
            }
            DecimalFormat formatter = new DecimalFormat();
            formatter.applyPattern(pattern);
            return formatter.format(ConvertDateTypeUtils.convertStringToNumber(value, dataType));
        }
        catch (Exception e) {
            _logger.warn((Object)MessageUtils.getString("warn.103", value), (Throwable)e);
            return value;
        }
    }
}

