/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.action.sysapi;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.action.AbstractAction;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.enumation.FunctionEnum;
import jp.co.headwaters.webappos.controller.fuction.SendMailFunction;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.oauth.AbstractOAuthClient;
import jp.co.headwaters.webappos.controller.oauth.OAuthClientFactory;
import jp.co.headwaters.webappos.controller.session.OAuthBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;

public class AuthAction
extends AbstractAction {
    private static final Log _logger = LogFactory.getLog(AuthAction.class);

    public String oauth() throws Exception {
        this.authorization(null);
        return null;
    }

    public String callback() throws Exception {
        OAuthBean oAuthData = (OAuthBean)this._session.get(OAuthBean.getKey());
        String provider = oAuthData.getProviderName();
        AbstractOAuthClient client = OAuthClientFactory.create(provider);
        client.callback(this._request, this._response, oAuthData);
        return null;
    }

    public String users() throws Exception {
        String provider = this._request.getParameter("sp");
        OAuthBean oAuthData = (OAuthBean)this._session.get(OAuthBean.getKey());
        if (oAuthData == null) {
            this._response.setStatus(401);
            return null;
        }
        AbstractOAuthClient client = OAuthClientFactory.create(provider);
        client.users(this._request, this._response, oAuthData);
        return null;
    }

    public String connect() throws Exception {
        HashMap user = (HashMap)this._session.get("LOGIN_USER");
        if (user == null) {
            this._response.setStatus(401);
            return null;
        }
        String userId = (String)user.get(AuthUtils.getAuthColumnName("id"));
        if (userId == null) {
            this._response.setStatus(401);
            return null;
        }
        this.authorization(userId);
        return null;
    }

    public String disconnect() throws Exception {
        return null;
    }

    public String login() throws Exception {
        String id = this._request.getParameter("id");
        String pw = this._request.getParameter("pw");
        String auto = this._request.getParameter("auto_login");
        String succsessUri = this._request.getParameter("ok");
        String failuretUri = this._request.getParameter("noauth");
        String redirectUri = (String)this._session.get("LOGIN_REDIRECT_URI");
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)pw)) {
            this._response.sendRedirect(ControllerUtils.getRedirectUri(failuretUri));
            return null;
        }
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession();
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), PropertyUtils.getProperty("auth.table.name"));
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            String authTableName = PropertyUtils.getProperty("auth.table.name");
            String authIdColName = PropertyUtils.getProperty("auth.column.id");
            String authPwColName = PropertyUtils.getProperty("auth.column.password");
            Object dbId = ConvertDateTypeUtils.convertStringToDbType(id, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, authIdColName)));
            Object dbPw = ConvertDateTypeUtils.convertStringToDbType(pw, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, authPwColName)));
            criteria.andEqualTo(authIdColName, dbId);
            criteria.andEqualTo(authPwColName, dbPw);
            String condName = PropertyUtils.getProperty("auth.conds.names");
            String condOperator = PropertyUtils.getProperty("auth.conds.operators");
            String condValue = PropertyUtils.getProperty("auth.conds.values");
            if (condName != null && condValue != null && condOperator != null) {
                String[] condNames = condName.split(",");
                String[] condOperators = condOperator.split(",");
                String[] condValues = condValue.split(",");
                int i = 0;
                while (i < condNames.length) {
                    String name = condNames[i];
                    String operator = condOperators[i];
                    String value = condValues[i];
                    DaoUtils.createCriteria(null, authTableName, name, operator, new String[]{value}, criteria, 0);
                    ++i;
                }
            }
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            HashMap<String, Object> user = null;
            if (entityList.size() == 1) {
                user = DaoUtils.convertEntityToMap(entityList.get(0), true);
                HttpSession httpSession = this._request.getSession(false);
                if (httpSession != null) {
                    httpSession.invalidate();
                }
                httpSession = this._request.getSession(true);
                httpSession.setAttribute("LOGIN_USER", user);
            }
            if (user == null) {
                this._response.sendRedirect(ControllerUtils.getRedirectUri(failuretUri));
                return null;
            }
            redirectUri = redirectUri == null ? ControllerUtils.getRedirectUri(succsessUri) : ControllerUtils.getRedirectUri(redirectUri);
            if (!StringUtils.isEmpty((CharSequence)auto)) {
                AuthUtils.addAutoLoginKey(this._request, this._response, sqlSession, user);
            }
            DaoUtils.commit(sqlSession);
            this._response.sendRedirect(redirectUri);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        return null;
    }

    public String autologin() throws Exception {
        OAuthBean oAuthData = (OAuthBean)this._session.get(OAuthBean.getKey());
        String provider = oAuthData.getProviderName();
        String uid = oAuthData.getUid();
        AbstractOAuthClient client = OAuthClientFactory.create(provider);
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession();
            HashMap<String, Object> user = client.getUserData(sqlSession, provider, uid);
            if (user == null || user.get(AuthUtils.getAuthColumnName("id")) == null) {
                this._response.setStatus(401);
                return null;
            }
            oAuthData.setUserId((String)user.get(AuthUtils.getAuthColumnName("id")));
            this._session.put("LOGIN_USER", user);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        return null;
    }

    public String logout() throws Exception {
        try {
            AuthUtils.removeAutoLoginKey(this._request, this._response);
            HttpSession httpSession = this._request.getSession(false);
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this._response.sendRedirect("/");
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String resetpw() throws Exception {
        if (!this.validateToken()) {
            this._response.sendRedirect("/");
            return null;
        }
        String email = this._request.getParameter("email");
        String succsessUri = this._request.getParameter("ok");
        String notfoundUri = this._request.getParameter("nouser");
        if (StringUtils.isEmpty((CharSequence)email)) {
            this._response.sendRedirect(ControllerUtils.getRedirectUri(notfoundUri));
            return null;
        }
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession(false);
            String authTableName = PropertyUtils.getProperty("auth.table.name");
            String emailColName = PropertyUtils.getProperty("auth.column.email");
            String tokenColName = PropertyUtils.getProperty("auth.column.token");
            String mapperName = DaoUtils.getMapperName(CrudEnum.UPDATE.getMethod(), authTableName);
            HashMap<String, Object> daoParams = new HashMap<String, Object>();
            Object dbEmail = ConvertDateTypeUtils.convertStringToDbType(email, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, emailColName)));
            Object dbToken = ConvertDateTypeUtils.convertStringToDbType(null, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, tokenColName)));
            daoParams.put(ControllerUtils.snakeToCamel(tokenColName), dbToken);
            daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("record", daoParams);
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo(emailColName, dbEmail);
            updateMap.put("example", example);
            int result = sqlSession.update(mapperName, updateMap);
            if (result == 0) {
                this._response.sendRedirect(ControllerUtils.getRedirectUri(notfoundUri));
                return null;
            }
            mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), PropertyUtils.getProperty("auth.table.name"));
            example = new CommonExample();
            criteria = example.createCriteria();
            criteria.andEqualTo(emailColName, dbEmail);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            HashMap<String, Object> user = null;
            if (entityList.size() == 1) {
                user = DaoUtils.convertEntityToMap(entityList.get(0), true);
            }
            if (user == null) {
                this._response.sendRedirect(ControllerUtils.getRedirectUri(notfoundUri));
                DaoUtils.rollback(sqlSession);
            }
            FunctionBean bean = new FunctionBean();
            bean.setType(FunctionEnum.FUNCTION_SENDMAIL.getFunctionName());
            bean.setToIdColumnName(String.valueOf(authTableName) + '.' + "id");
            bean.setToAddressColumnName(String.valueOf(authTableName) + '.' + emailColName);
            bean.setToIds(new String[]{(String)user.get(ControllerUtils.getSchemaColumnKey(authTableName, "id"))});
            bean.setMethod("resetpassword".toUpperCase());
            SendMailFunction function = new SendMailFunction();
            function.setSqlSession(sqlSession);
            function.execute(null, null, bean);
            DaoUtils.commit(sqlSession);
            this._response.sendRedirect(succsessUri);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        return null;
    }

    public String clearAutoLogin() throws Exception {
        HashMap user = (HashMap)this._session.get("LOGIN_USER");
        if (user == null) {
            this._response.setStatus(401);
            return null;
        }
        String userId = (String)user.get(AuthUtils.getAuthColumnName("id"));
        if (userId == null) {
            this._response.setStatus(401);
            return null;
        }
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession(false);
            Object dbUserId = ConvertDateTypeUtils.convertStringToDbType(userId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_auto_login", "user_id")));
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("user_id", dbUserId);
            String mapperName = DaoUtils.getMapperName(CrudEnum.DELETE.getMethod(), "_webappos_auto_login");
            sqlSession.delete(mapperName, (Object)example);
            DaoUtils.commit(sqlSession);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        return null;
    }

    public String modifyId() throws Exception {
        if (!this.validateToken()) {
            this._response.sendRedirect("/");
            return null;
        }
        HashMap<String, Object> user = (HashMap<String, Object>)this._session.get("LOGIN_USER");
        String userId = (String)user.get(AuthUtils.getAuthColumnName("id"));
        String tempId = this._request.getParameter("temp_id");
        String succsessUri = this._request.getParameter("ok");
        String ngUri = this._request.getParameter("ng");
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession(false);
            String authTableName = PropertyUtils.getProperty("auth.table.name");
            String emailColName = PropertyUtils.getProperty("auth.column.email");
            Object dbEmail = ConvertDateTypeUtils.convertStringToDbType(tempId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, emailColName)));
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), authTableName);
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo(emailColName, dbEmail);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            if (entityList.size() > 0) {
                this._response.sendRedirect(ControllerUtils.getRedirectUri(ngUri));
                DaoUtils.rollback(sqlSession);
                return null;
            }
            String tempIdColName = PropertyUtils.getProperty("auth.column.temp_id");
            String tokenColName = PropertyUtils.getProperty("auth.column.token");
            mapperName = DaoUtils.getMapperName(CrudEnum.UPDATE.getMethod(), authTableName);
            HashMap<String, Object> daoParams = new HashMap<String, Object>();
            Object dbId = ConvertDateTypeUtils.convertStringToDbType(userId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, "id")));
            Object dbTempId = ConvertDateTypeUtils.convertStringToDbType(tempId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, tempIdColName)));
            Object dbToken = ConvertDateTypeUtils.convertStringToDbType(null, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, tokenColName)));
            daoParams.put(ControllerUtils.snakeToCamel(tempIdColName), dbTempId);
            daoParams.put(ControllerUtils.snakeToCamel(tokenColName), dbToken);
            daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("record", daoParams);
            example = new CommonExample();
            criteria = example.createCriteria();
            criteria.andEqualTo("id", dbId);
            updateMap.put("example", example);
            sqlSession.update(mapperName, updateMap);
            mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), PropertyUtils.getProperty("auth.table.name"));
            example = new CommonExample();
            criteria = example.createCriteria();
            criteria.andEqualTo("id", dbId);
            entityList = sqlSession.selectList(mapperName, (Object)example);
            user = null;
            if (entityList.size() == 1) {
                user = DaoUtils.convertEntityToMap(entityList.get(0), true);
            }
            if (user == null) {
                DaoUtils.rollback(sqlSession);
            }
            FunctionBean bean = new FunctionBean();
            bean.setType(FunctionEnum.FUNCTION_SENDMAIL.getFunctionName());
            bean.setToIdColumnName(String.valueOf(authTableName) + '.' + "id");
            bean.setToAddressColumnName(String.valueOf(authTableName) + '.' + tempIdColName);
            bean.setToIds(new String[]{(String)user.get(ControllerUtils.getSchemaColumnKey(authTableName, "id"))});
            bean.setMethod("modifyEmail".toUpperCase());
            SendMailFunction function = new SendMailFunction();
            function.setSqlSession(sqlSession);
            function.execute(null, null, bean);
            DaoUtils.commit(sqlSession);
            HttpSession httpSession = this._request.getSession(false);
            if (httpSession != null) {
                httpSession.invalidate();
            }
            this._response.sendRedirect(succsessUri);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        return null;
    }

    private void authorization(String userId) throws Exception {
        String provider = this._request.getParameter("sp");
        String succsessUri = this._request.getParameter("ok");
        String failuretUri = this._request.getParameter("noauth");
        String notfoundUri = this._request.getParameter("nouser");
        String auto = this._request.getParameter("auto_login");
        succsessUri = ControllerUtils.getRedirectUri(succsessUri);
        failuretUri = ControllerUtils.getRedirectUri(failuretUri);
        notfoundUri = ControllerUtils.getRedirectUri(notfoundUri);
        OAuthBean oAuthData = new OAuthBean();
        oAuthData.setSuccessUri(succsessUri);
        oAuthData.setFailuretUri(failuretUri);
        oAuthData.setNotfoundUri(notfoundUri);
        oAuthData.setProviderName(provider);
        oAuthData.setUserId(userId);
        oAuthData.setAutoLogin(!StringUtils.isEmpty((CharSequence)auto));
        this._session.put(OAuthBean.getKey(), oAuthData);
        AbstractOAuthClient client = OAuthClientFactory.create(provider);
        client.oauth(this._request, this._response, oAuthData);
    }
}

