/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.fuction;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.ConditionBean;
import jp.co.headwaters.webappos.controller.cache.bean.CrudBean;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.LoadBean;
import jp.co.headwaters.webappos.controller.cache.bean.RelationKeyBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.exception.ExecuteDeniedException;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.session.OAuthBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

public class CrudFunction
extends AbstractFunction {
    @Override
    protected void execute(AbstractExecuteBean function) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        int resultCount = 0;
        CrudBean crudFunction = (CrudBean)function;
        if (CrudEnum.SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod()) || CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) {
            resultCount = this.executeSelectByExample(crudFunction);
        } else if (CrudEnum.SELECT_BY_PK.getMethod().equals(function.getMethod())) {
            resultCount = this.executeSelectByPrimaryKey(crudFunction);
        } else if (CrudEnum.INSERT.getMethod().equals(function.getMethod())) {
            int count = this.getExecuteCount(crudFunction);
            int i = 0;
            while (i <= count) {
                resultCount += this.executeInsert(crudFunction, i);
                ++i;
            }
        } else if (CrudEnum.UPDATE.getMethod().equals(function.getMethod()) || CrudEnum.UPDATE_ALL.getMethod().equals(function.getMethod())) {
            int count = this.getExecuteCount(crudFunction);
            int i = 0;
            while (i <= count) {
                resultCount += this.executeUpdate(crudFunction, i);
                ++i;
            }
        } else if (CrudEnum.DELETE.getMethod().equals(function.getMethod())) {
            resultCount = this.executeDelete(crudFunction);
        }
        crudFunction.setResultCount(resultCount);
    }

    private int getExecuteCount(CrudBean function) {
        String[] param = (String[])this._requestParams.get(this.getExecuteCountName(function));
        if (param == null || param.length == 0) {
            return 0;
        }
        return Integer.parseInt(param[0]) - 1;
    }

    private String getExecuteCountName(CrudBean function) {
        StringBuilder sb = new StringBuilder();
        sb.append(function.getResult());
        sb.append("__");
        sb.append("COUNT");
        return sb.toString();
    }

    private int executeSelectByExample(CrudBean function) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        List entityList;
        block10: {
            ArrayList<HashMap<String, Object>> resultList;
            RowBounds rowBounds;
            CommonExample example;
            String mapperName;
            block9: {
                String resultName = function.getResult();
                String target = function.getTarget().split(",")[0];
                mapperName = DaoUtils.getMapperName(function.getMethod(), target);
                example = this.createExample(function, 0);
                if (example == null) {
                    this._resultMap.put(resultName, new ArrayList());
                    return 0;
                }
                example.setJoinTables(Arrays.asList(function.getTarget().toLowerCase().split(",")));
                String countMapperName = null;
                countMapperName = CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod().equalsIgnoreCase(function.getMethod()) ? DaoUtils.getMapperName(CrudEnum.COUNT_ALL.getMethod(), target) : DaoUtils.getMapperName(CrudEnum.COUNT.getMethod(), target);
                Integer count = (Integer)this._sqlSession.selectOne(countMapperName, (Object)example);
                if (count == 0) {
                    this.createRowBounds(function, 0);
                    if (function instanceof LoadBean && ((LoadBean)function).isNotFooundError()) {
                        throw new NotFoundException();
                    }
                    this._resultMap.put(resultName, new ArrayList());
                    return 0;
                }
                rowBounds = null;
                try {
                    rowBounds = this.createRowBounds(function, count);
                }
                catch (NotFoundException e) {
                    if (function instanceof LoadBean && ((LoadBean)function).isNotFooundError()) {
                        throw new NotFoundException();
                    }
                    return 0;
                }
                entityList = null;
                HashMap rootMap = new HashMap();
                resultList = new ArrayList<HashMap<String, Object>>();
                rootMap.put(target, resultList);
                this._resultMap.put(resultName, rootMap);
                if (!CrudEnum.SELECT_BY_EXAMPLE.getMethod().equals(function.getMethod())) break block9;
                entityList = rowBounds == null ? this._sqlSession.selectList(mapperName, (Object)example) : this._sqlSession.selectList(mapperName, (Object)example, rowBounds);
                int i = 0;
                while (i < entityList.size()) {
                    resultList.add(DaoUtils.convertEntityToMap(entityList.get(i), false));
                    ++i;
                }
                break block10;
            }
            if (!CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod().equals(function.getMethod())) break block10;
            entityList = this._sqlSession.selectList(mapperName, (Object)example);
            if (rowBounds != null) {
                int fromIndex = entityList.size() < rowBounds.getOffset() ? entityList.size() : rowBounds.getOffset();
                int toIndex = entityList.size() < fromIndex + rowBounds.getLimit() ? entityList.size() : fromIndex + rowBounds.getLimit();
                entityList = entityList.subList(fromIndex, toIndex);
            }
            int i = 0;
            while (i < entityList.size()) {
                resultList.add(DaoUtils.convertEntityToMap(entityList.get(i), true));
                ++i;
            }
        }
        return entityList.size();
    }

    private int executeSelectByPrimaryKey(CrudBean function) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        String resultName = function.getResult();
        String mapperName = DaoUtils.getMapperName(function.getMethod(), function.getTarget());
        CommonExample example = this.createExample(function, 0);
        if (example == null || example.getOredCriteria().size() == 0 || example.getOredCriteria().get(0).getCriteria().size() == 0) {
            throw new WebAppOSException("err.200");
        }
        Integer count = (Integer)this._sqlSession.selectOne(DaoUtils.getMapperName(CrudEnum.COUNT.getMethod(), function.getTarget()), (Object)example);
        if (count == 0) {
            if (function instanceof LoadBean && ((LoadBean)function).isNotFooundError()) {
                throw new NotFoundException();
            }
            this._resultMap.put(resultName, new HashMap());
            return 0;
        }
        if (count != 1) {
            throw new WebAppOSException();
        }
        List entityList = null;
        entityList = this._sqlSession.selectList(mapperName, (Object)example);
        this._resultMap.put(resultName, DaoUtils.convertEntityToMap(entityList.get(0), false));
        return entityList.size();
    }

    private int executeInsert(CrudBean function, int i) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        OAuthBean oAuthData;
        List<RelationKeyBean> importedKey;
        int result = 0;
        String mapperName = DaoUtils.getMapperName(function.getMethod(), function.getTarget());
        HashMap<String, Object> daoParams = new HashMap<String, Object>();
        this.createDaoParamFromCache(function, daoParams);
        this.createDaoParamFromRequest(function, daoParams, i);
        String fkColumnName = null;
        Map<String, List<RelationKeyBean>> importedKeys = WebAppOSCache.getInstance().getImportedKeys();
        if (importedKeys != null && (importedKey = importedKeys.get(function.getTarget().toLowerCase())) != null) {
            for (RelationKeyBean relation : importedKey) {
                fkColumnName = ControllerUtils.getSchemaColumnKey(relation.getPkTableName(), "id");
                if (!this._ids.containsKey(fkColumnName) || ((Map)this._ids.get(fkColumnName)).get(0) == null) continue;
                daoParams.put(ControllerUtils.snakeToCamel(fkColumnName.toLowerCase()), ((Map)this._ids.get(fkColumnName)).get(0));
            }
        }
        if (daoParams.size() == 0) {
            return 0;
        }
        daoParams.put(ControllerUtils.snakeToCamel("created_date"), new Timestamp(System.currentTimeMillis()));
        daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
        HashMap<String, HashMap<String, Object>> insertMap = new HashMap<String, HashMap<String, Object>>();
        insertMap.put("record", daoParams);
        result = this._sqlSession.insert(mapperName, insertMap);
        Object id = ((Map)insertMap.get("record")).get("id");
        function.putId(i, Integer.valueOf(id.toString()));
        if (function.getTarget().equalsIgnoreCase(PropertyUtils.getProperty("auth.table.name")) && (oAuthData = (OAuthBean)this._httpSession.get(OAuthBean.getKey())) != null && oAuthData.getProviderName() != null && oAuthData.getUid() != null) {
            oAuthData.setUserId(id.toString());
            AuthUtils.registerOAuthData(this._sqlSession, oAuthData.getProviderName(), oAuthData.getUserId(), oAuthData.getUid());
        }
        return result;
    }

    private int executeUpdate(CrudBean function, int i) throws WebAppOSException {
        int result = 0;
        String mapperName = DaoUtils.getMapperName(function.getMethod(), function.getTarget());
        HashMap<String, Object> daoParams = new HashMap<String, Object>();
        this.createDaoParamFromCache(function, daoParams);
        this.createDaoParamFromRequest(function, daoParams, i);
        if (daoParams.size() == 0) {
            return 0;
        }
        daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put("record", daoParams);
        CommonExample example = this.createExample(function, i);
        if (example == null || example.getOredCriteria().size() == 0 || example.getOredCriteria().get(0).getCriteria().size() == 0) {
            throw new WebAppOSException("err.202");
        }
        updateMap.put("example", example);
        result = this._sqlSession.update(mapperName, updateMap);
        if (function.getTarget().equalsIgnoreCase(PropertyUtils.getProperty("auth.table.name"))) {
            HashMap loginUser = (HashMap)this._httpSession.get("LOGIN_USER");
            Map<String, Object> newUser = AuthUtils.refreshLoginUserData(this._sqlSession, loginUser);
            this._httpSession.put("LOGIN_USER", newUser);
        }
        return result;
    }

    private int executeDelete(CrudBean function) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, WebAppOSException {
        String mapperName = DaoUtils.getMapperName(function.getMethod(), function.getTarget());
        CommonExample example = this.createExample(function, 0);
        if (example == null || example.getOredCriteria().size() == 0 || example.getOredCriteria().get(0).getCriteria().size() == 0) {
            throw new WebAppOSException("err.202");
        }
        return this._sqlSession.delete(mapperName, (Object)example);
    }

    private CommonExample createExample(CrudBean function, int i) throws WebAppOSException {
        CommonExample example = new CommonExample();
        CommonExample.Criteria criteria = example.createCriteria();
        String target = function.getTarget().split(",")[0];
        Map ids = (Map)this._ids.get(ControllerUtils.getSchemaColumnKey(target, "id"));
        if (ids != null && ids.size() > 0) {
            String col = String.valueOf(target) + '.' + "id";
            ArrayList<Object> paramList = new ArrayList<Object>();
            for (Integer id : ids.values()) {
                paramList.add(id);
            }
            criteria.andIn(col, paramList);
        }
        if (!this.createConditionFromCache(function, example, criteria)) {
            return null;
        }
        if (function instanceof FunctionBean) {
            this.createConditionFromRequest(function, example, criteria, i);
        }
        StringBuilder sb = new StringBuilder();
        String value = null;
        List<String> sortList = function.getSorts();
        if (sortList != null && sortList.size() > 0) {
            for (String sort : sortList) {
                value = this.getParameter(sort);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                value.replace(";", "");
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (value.endsWith("_")) {
                    sb.append(value.substring(0, value.length() - 1));
                    sb.append(" desc");
                    continue;
                }
                sb.append(value);
            }
            example.setOrderByClause(sb.toString());
        }
        return example;
    }

    private boolean createConditionFromCache(CrudBean function, CommonExample example, CommonExample.Criteria criteria) throws WebAppOSException {
        if (function.getConds() != null) {
            for (ConditionBean cond : function.getConds()) {
                String[] values = null;
                String value = cond.getValue();
                value = this.getParameter(value);
                if (cond.getColumnName().startsWith("_SES")) {
                    String[] keys = cond.getColumnName().split("\\.");
                    String target = null;
                    if (keys.length != 3) {
                        throw new ExecuteDeniedException("err.204");
                    }
                    if ("LOGIN_USER".equalsIgnoreCase(keys[1])) {
                        Object loginUser = this._httpSession.get("LOGIN_USER");
                        if (loginUser != null) {
                            String authKey;
                            if (loginUser instanceof Map && ((Map)loginUser).get(authKey = AuthUtils.getAuthColumnName(keys[keys.length - 1])) != null) {
                                target = String.valueOf(((Map)loginUser).get(authKey));
                            }
                            if (this.isExecutable(target, value, cond.getOperator())) continue;
                            throw new ExecuteDeniedException("err.204");
                        }
                    } else {
                        throw new ExecuteDeniedException("err.204");
                    }
                }
                values = new String[]{value};
                DaoUtils.createCriteria(function.getResult(), function.getTarget(), cond.getColumnName(), cond.getOperator(), values, criteria, 0);
            }
        }
        return true;
    }

    private void createConditionFromRequest(CrudBean function, CommonExample example, CommonExample.Criteria criteria, int i) throws WebAppOSException {
        for (Map.Entry param : this._requestParams.entrySet()) {
            String[] values = (String[])param.getValue();
            String[] keys = ((String)param.getKey()).split("__", 5);
            if (keys.length < 4 || !keys[0].equals(function.getResult()) || !"COND".equals(keys[1])) continue;
            this.createCriteria(keys, values, function, criteria, i);
        }
    }

    private boolean isExecutable(String target, String value, String operator) throws NotFoundException {
        if ("isnull".equals(operator)) {
            if (target == null) {
                return true;
            }
        } else if ("isnotnull".equals(operator)) {
            if (target != null) {
                return true;
            }
        } else if ("eq".equals(operator)) {
            if (target == null && value != null) {
                return false;
            }
            if (target == null && value == null) {
                return true;
            }
            if (target.equalsIgnoreCase(value)) {
                return true;
            }
        } else if ("nq".equals(operator)) {
            if (target == null && value != null) {
                return true;
            }
            if (target == null && value == null) {
                return false;
            }
            if (!target.equalsIgnoreCase(value)) {
                return true;
            }
        }
        return false;
    }

    private void createCriteria(String[] key, String[] values, CrudBean function, CommonExample.Criteria criteria, int i) throws WebAppOSException {
        String resultName = key[0];
        String target = key[2];
        String column = String.valueOf(target) + '.' + key[3];
        String operator = ((FunctionBean)function).getOperatorMap().get(String.valueOf(resultName) + '.' + column);
        DaoUtils.createCriteria(resultName, target, column, operator, values, criteria, i);
    }

    private void createDaoParamFromCache(CrudBean function, Map<String, Object> daoParams) throws WebAppOSException {
        if (function.getCols() != null) {
            for (ConditionBean col : function.getCols()) {
                String column = col.getColumnName();
                String value = col.getValue();
                value = this.getParameter(value);
                String[] names = column.split("\\.");
                column = names.length == 2 ? column.toLowerCase() : String.valueOf(function.getTarget().toLowerCase()) + '.' + column.toLowerCase();
                SchemaColumnBean schemaColumn = SchemaColumnCache.getSchemaColumn(column.replace(".", "_"));
                String daoParamKey = ControllerUtils.snakeToCamel(names[names.length - 1]);
                Object daoParamValue = ConvertDateTypeUtils.convertStringToDbType(value, schemaColumn);
                daoParams.put(daoParamKey, daoParamValue);
            }
        }
    }

    private void createDaoParamFromRequest(CrudBean function, Map<String, Object> daoParams, int i) throws WebAppOSException {
        for (Map.Entry param : this._requestParams.entrySet()) {
            String[] values = (String[])param.getValue();
            String[] keys = ((String)param.getKey()).split("__", 5);
            String daoParamKey = null;
            Object daoParamValue = null;
            if (keys.length < 3 || !keys[0].equals(function.getResult()) || !"COL".equals(keys[1])) continue;
            daoParamKey = ControllerUtils.snakeToCamel(keys[2]);
            SchemaColumnBean schemaColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(function.getTarget(), keys[2]));
            if (schemaColumn == null) continue;
            String value = null;
            value = values == null || values.length == 0 ? null : (values.length <= i ? null : (values[i] == null ? null : (values[i].length() == 0 ? "" : values[i])));
            daoParamValue = ConvertDateTypeUtils.convertStringToDbType(value, schemaColumn);
            daoParams.put(daoParamKey, daoParamValue);
        }
    }
}

