/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.fuction;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.SystemConstantCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.CrudBean;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.cache.bean.SystemConstantBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.enumation.FunctionEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.fuction.CrudFunction;
import jp.co.headwaters.webappos.controller.fuction.JavaMailer;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class SendMailFunction
extends AbstractFunction {
    protected final Pattern SUBJECT_PATTERN = Pattern.compile("^Subject:(.+)?(\\r\\n|\\r|\\n)");
    protected final Pattern TO_PATTERN = Pattern.compile("^To:(.+)?(\\r\\n|\\r|\\n)");
    protected final Pattern CC_PATTERN = Pattern.compile("^Cc:(.+)?(\\r\\n|\\r|\\n)");
    protected final Pattern BCC_PATTERN = Pattern.compile("^Bcc:(.+)?(\\r\\n|\\r|\\n)");
    protected JavaMailer _mailer;
    protected String _mailFromAddress;
    protected String _mailFromName;
    protected String _siteName;
    protected Map<String, Object> _params;
    protected Configuration _configuration;

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        Map<String, SystemConstantBean> mailConstants = SystemConstantCache.getSystemConstantMap("MAIL");
        if (mailConstants == null || mailConstants.size() == 0) {
            throw new WebAppOSException("err.300");
        }
        String charset = null;
        String host = null;
        String port = null;
        String userName = null;
        String password = null;
        String connectionTimeout = null;
        String timeout = null;
        if (!mailConstants.containsKey("CHARSET")) {
            throw new WebAppOSException("err.301", "CHARSET");
        }
        charset = mailConstants.get("CHARSET").getValue();
        if (!mailConstants.containsKey("HOST")) {
            throw new WebAppOSException("err.301", "HOST");
        }
        host = mailConstants.get("HOST").getValue();
        if (!mailConstants.containsKey("PORT")) {
            throw new WebAppOSException("err.301", "PORT");
        }
        port = mailConstants.get("PORT").getValue();
        if (mailConstants.containsKey("USERNAME")) {
            userName = mailConstants.get("USERNAME").getValue();
        }
        if (mailConstants.containsKey("PASSWORD")) {
            password = mailConstants.get("PASSWORD").getValue();
        }
        if (!mailConstants.containsKey("CONNECTIONTIMEOUT")) {
            throw new WebAppOSException("err.301", "CONNECTIONTIMEOUT");
        }
        connectionTimeout = mailConstants.get("CONNECTIONTIMEOUT").getValue();
        if (!mailConstants.containsKey("TIMEOUT")) {
            throw new WebAppOSException("err.301", "TIMEOUT");
        }
        timeout = mailConstants.get("TIMEOUT").getValue();
        if (!mailConstants.containsKey("FROMADDRESS")) {
            throw new WebAppOSException("err.301", "FROMADDRESS");
        }
        this._mailFromAddress = mailConstants.get("FROMADDRESS").getValue();
        if (!mailConstants.containsKey("FROMNAME")) {
            throw new WebAppOSException("err.301", "FROMNAME");
        }
        this._mailFromName = mailConstants.get("FROMNAME").getValue();
        if (!mailConstants.containsKey("SITENAME")) {
            throw new WebAppOSException("err.301", "SITENAME");
        }
        this._siteName = mailConstants.get("SITENAME").getValue();
        this._mailer = new JavaMailer();
        this._mailer.setCharset(charset);
        this._mailer.setServerInfo(host, port, userName, password);
        this._mailer.setTimeout(Integer.valueOf(connectionTimeout), Integer.valueOf(timeout));
        this._configuration = new Configuration();
        this._configuration.setDirectoryForTemplateLoading(new File(this.getMailTemplatePath()));
        this._configuration.setDefaultEncoding("utf-8");
        this._params = new HashMap<String, Object>();
    }

    private String getMailTemplatePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("webapps.path"));
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        sb.append("templates");
        return sb.toString();
    }

    @Override
    protected void execute(AbstractExecuteBean function) throws Exception {
        FunctionBean mailFunction = (FunctionBean)function;
        if (!FunctionEnum.FUNCTION_SENDMAIL.getFunctionName().equalsIgnoreCase(mailFunction.getType())) {
            throw new WebAppOSException();
        }
        HashMap<String, Object> mailParams = new HashMap<String, Object>();
        String templateName = mailFunction.getMethod();
        if (StringUtils.isEmpty((CharSequence)mailFunction.getToIdColumnName()) || StringUtils.isEmpty((CharSequence)mailFunction.getToAddressColumnName())) {
            this.addAddress(mailFunction);
            this.createMailParamMap(function.getResult(), mailParams);
            this.sendMail(templateName, mailParams);
        } else {
            String[] addressColumnInfo = mailFunction.getToAddressColumnName().split("\\.");
            String addressTalbeName = addressColumnInfo[0].toUpperCase();
            String addressColumnName = addressColumnInfo[1].toUpperCase();
            String[] ids = mailFunction.getToIds();
            if (ids == null && ((ids = this.getIdColParams(mailFunction)) == null || ids.length == 0)) {
                Map idmap = (Map)this._ids.get(ControllerUtils.getSchemaColumnKey(addressTalbeName, "id"));
                if (idmap != null && idmap.size() > 0) {
                    ids = new String[idmap.size()];
                    int i = 0;
                    while (i < ids.length) {
                        ids[i] = String.valueOf(idmap.get(i));
                        ++i;
                    }
                }
                if (ids == null || ids.length == 0) {
                    throw new WebAppOSException("err.302");
                }
            }
            SchemaColumnBean addressColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(addressTalbeName, "id"));
            ArrayList<Object> idList = new ArrayList<Object>();
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String val1 = stringArray[n2];
                for (String val2 : Arrays.asList(val1.split(","))) {
                    if (StringUtils.isEmpty((CharSequence)val2)) continue;
                    idList.add(ConvertDateTypeUtils.convertStringToDbType(val2, addressColumn));
                }
                ++n2;
            }
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), addressTalbeName);
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andIn("id", idList);
            List entityList = this._sqlSession.selectList(mapperName, (Object)example);
            int i = 0;
            while (i < entityList.size()) {
                mailParams = new HashMap();
                HashMap<String, Object> map = DaoUtils.convertEntityToMap(entityList.get(i), false);
                String address = (String)map.get(ControllerUtils.getResultMapKey(addressTalbeName, addressColumnName));
                this.addAddress(mailFunction);
                this.addTo(address);
                this.createMailParamMap(function.getResult(), mailParams);
                mailParams.put(addressTalbeName, map);
                this.sendMail(templateName, mailParams);
                ++i;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)function.getTarget())) {
            CrudBean insInfo = new CrudBean();
            insInfo.setMethod(CrudEnum.INSERT.getMethod());
            insInfo.setTarget(function.getTarget());
            insInfo.setResult(function.getResult());
            new CrudFunction().execute(this._requestParams, this._resultMap, insInfo);
        }
    }

    private String[] getIdColParams(FunctionBean function) {
        StringBuilder sb = new StringBuilder();
        sb.append(function.getResult());
        sb.append("__");
        sb.append("COL");
        sb.append("__");
        sb.append(function.getToIdColumnName().toUpperCase());
        return (String[])this._requestParams.get(sb.toString());
    }

    private void createMailParamMap(String resultName, Map<String, Object> mailParams) {
        if (this._requestParams == null) {
            return;
        }
        for (Map.Entry param : this._requestParams.entrySet()) {
            Object[] values = (String[])param.getValue();
            String[] key = ((String)param.getKey()).split("__", 3);
            String daoParamKey = null;
            String daoParamValue = null;
            if (!key[0].equals(resultName) || !"COL".equals(key[1])) continue;
            daoParamKey = key[2].toUpperCase();
            daoParamValue = StringUtils.join((Object[])values, (String)",");
            if (mailParams.containsKey(daoParamKey)) continue;
            mailParams.put(daoParamKey, daoParamValue);
        }
    }

    private void addAddress(FunctionBean function) throws AddressException, UnsupportedEncodingException {
        String[] values;
        SystemConstantBean systemConstant = null;
        if (function.getToList() != null) {
            for (String value : function.getToList()) {
                if (StringUtils.isEmpty((CharSequence)value) || (systemConstant = (values = value.split("\\.")).length == 1 ? SystemConstantCache.getSystemConstant(values[0]) : SystemConstantCache.getSystemConstant(values[0], values[1])) == null || StringUtils.isEmpty((CharSequence)systemConstant.getValue())) continue;
                this.addTo(systemConstant.getValue());
            }
        }
        if (function.getCcList() != null) {
            for (String value : function.getCcList()) {
                if (StringUtils.isEmpty((CharSequence)value) || (systemConstant = (values = value.split("\\.")).length == 1 ? SystemConstantCache.getSystemConstant(values[0]) : SystemConstantCache.getSystemConstant(values[0], values[1])) == null || StringUtils.isEmpty((CharSequence)systemConstant.getValue())) continue;
                this.addCc(systemConstant.getValue());
            }
        }
        if (function.getBccList() != null) {
            for (String value : function.getBccList()) {
                if (StringUtils.isEmpty((CharSequence)value) || (systemConstant = (values = value.split("\\.")).length == 1 ? SystemConstantCache.getSystemConstant(values[0]) : SystemConstantCache.getSystemConstant(values[0], values[1])) == null || StringUtils.isEmpty((CharSequence)systemConstant.getValue())) continue;
                this.addBcc(systemConstant.getValue());
            }
        }
    }

    public void sendMail(String templateName, Map<String, Object> obj) throws Exception {
        this._mailer.setFrom(this._mailFromAddress, this._mailFromName);
        if (this._resultMap != null) {
            this._params.putAll(this._resultMap);
        }
        this.assign("SITE_NAME", this._siteName);
        this._params.putAll(obj);
        this.fetch(templateName, this._params);
        this._mailer.send();
        this._mailer.clearInternetAddress();
    }

    public void setFrom(String address, String name) throws UnsupportedEncodingException, AddressException {
        this._mailer.setFrom(address, name);
    }

    public void addTo(String addresses) throws AddressException, UnsupportedEncodingException {
        this._mailer.addTo(addresses);
    }

    public void addCc(String addresses) throws AddressException, UnsupportedEncodingException {
        this._mailer.addCc(addresses);
    }

    public void addBcc(String addresses) throws AddressException, UnsupportedEncodingException {
        this._mailer.addBcc(addresses);
    }

    public void assign(String key, Object value) {
        this._params.put(key.toUpperCase(), value);
    }

    protected Template getTemplate(String templateName) throws IOException {
        StringBuilder sb = new StringBuilder(templateName);
        sb.append(".ftl");
        return this._configuration.getTemplate(sb.toString());
    }

    protected void fetch(String templateName, Map<String, Object> map) throws IOException, TemplateException, AddressException {
        Template template = this.getTemplate(templateName);
        map = ControllerUtils.toHtmlString(map);
        StringWriter out = new StringWriter();
        template.process(map, (Writer)out);
        String message = out.toString();
        Matcher m = this.SUBJECT_PATTERN.matcher(message);
        if (m.find()) {
            this._mailer.setSubject(m.group(1).trim());
            message = m.replaceFirst("");
        }
        if ((m = this.TO_PATTERN.matcher(message)).find()) {
            this.addTo(m.group(1));
            message = m.replaceFirst("");
        }
        if ((m = this.CC_PATTERN.matcher(message)).find()) {
            this.addCc(m.group(1));
            message = m.replaceFirst("");
        }
        if ((m = this.BCC_PATTERN.matcher(message)).find()) {
            this.addBcc(m.group(1));
            message = m.replaceFirst("");
        }
        if ((m = Pattern.compile("^(\\r\\n|\\r)+|(\\r\\n|\\r)+$").matcher(message)).find()) {
            message = m.replaceAll("");
        }
        message = message.replace('\uff0d', '\u2212').replace('\u2015', '\u2014').replace('\uff5e', '\u301c').replace('\u2225', '\u2016').replace('\uffe0', '\u00a2').replace('\uffe1', '\u00a3').replace('\uffe2', '\u00ac');
        this._mailer.setBody(message);
    }
}

