/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.enumation.ServiceProviderEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.fuction.AbstractFunction;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.oauth.ConsumerProperties;
import jp.co.headwaters.webappos.controller.oauth.OAuthConsumer;
import jp.co.headwaters.webappos.controller.session.OAuthBean;
import jp.co.headwaters.webappos.controller.utils.AuthUtils;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.MessageUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public abstract class AbstractOAuthClient
extends AbstractFunction {
    protected static final Log _logger = LogFactory.getLog(AbstractOAuthClient.class);
    protected ServiceProviderEnum provider;
    protected Api providerApi;
    protected String resourceUrl;

    @Override
    protected void execute(AbstractExecuteBean function) throws Exception {
    }

    public abstract void oauth(HttpServletRequest var1, HttpServletResponse var2, OAuthBean var3) throws Exception;

    public abstract Token getAccessToken(HttpServletRequest var1, OAuthService var2, OAuthBean var3) throws Exception;

    public void callback(HttpServletRequest request, HttpServletResponse response, OAuthBean oAuthData) throws Exception {
        String provider = oAuthData.getProviderName();
        OAuthConsumer consumer = ConsumerProperties.getConsumer(provider);
        OAuthService service = new ServiceBuilder().provider(this.providerApi).apiKey(consumer.getApiKey()).apiSecret(consumer.getApiSecret()).callback(this.getCallbackUrl(request)).build();
        String redirectUri = (String)request.getSession().getAttribute("LOGIN_REDIRECT_URI");
        Token accessToken = this.getAccessToken(request, service, oAuthData);
        if (accessToken == null) {
            _logger.warn((Object)MessageUtils.getString("err.500"));
            response.sendRedirect(oAuthData.getFailuretUri());
            return;
        }
        String uid = this.getUid(service, accessToken);
        if (uid == null) {
            response.sendRedirect(oAuthData.getFailuretUri());
            return;
        }
        String userId = oAuthData.getUserId();
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        httpSession = request.getSession(true);
        oAuthData.setUid(uid);
        oAuthData.setAccessToken(accessToken);
        oAuthData.setUserId(userId);
        httpSession.setAttribute(OAuthBean.getKey(), (Object)oAuthData);
        httpSession.setAttribute("LOGIN_REDIRECT_URI", (Object)redirectUri);
        SqlSession sqlSession = null;
        try {
            HashMap<String, Object> user;
            sqlSession = DaoUtils.openSqlSession(false);
            if (oAuthData.getUserId() != null) {
                AuthUtils.registerOAuthData(sqlSession, provider, oAuthData.getUserId(), uid);
            }
            if ((user = this.getUserData(sqlSession, provider, uid)) == null || user.get(AuthUtils.getAuthColumnName("id")) == null) {
                response.sendRedirect(oAuthData.getNotfoundUri());
                return;
            }
            oAuthData.setUserId((String)user.get(AuthUtils.getAuthColumnName("id")));
            httpSession.setAttribute("LOGIN_USER", user);
            httpSession.setAttribute("OAUTH_SUCCESS_URI", (Object)oAuthData.getSuccessUri());
            if (oAuthData.isAutoLogin()) {
                AuthUtils.removeAutoLoginKey(request, response, sqlSession);
                AuthUtils.addAutoLoginKey(request, response, sqlSession, user);
            }
            DaoUtils.commit(sqlSession);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
        response.sendRedirect(oAuthData.getSuccessUri());
    }

    public void users(HttpServletRequest request, HttpServletResponse response, OAuthBean oAuthData) throws Exception {
        String provider = oAuthData.getProviderName();
        OAuthConsumer consumer = ConsumerProperties.getConsumer(provider);
        OAuthService service = new ServiceBuilder().provider(this.providerApi).apiKey(consumer.getApiKey()).apiSecret(consumer.getApiSecret()).build();
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, this.resourceUrl);
        service.signRequest(oAuthData.getAccessToken(), oAuthRequest);
        Response oauthResponse = oAuthRequest.send();
        response.setStatus(oauthResponse.getCode());
        response.setContentType(this.getContentType(oauthResponse.getHeaders()));
        Throwable throwable = null;
        Object var10_11 = null;
        try (InputStream in = oauthResponse.getStream();){
            ServletOutputStream out = response.getOutputStream();
            this.copyAll(in, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getContentType(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey() == null || !"content-type".equals(header.getKey().toLowerCase())) continue;
            return header.getValue();
        }
        return null;
    }

    public void disconnect(HttpServletRequest request, HttpServletResponse response, String provider, String userId) throws Exception {
        this.removeOAuthData(request, provider, userId);
    }

    private String getUid(OAuthService service, Token accessToken) {
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, this.resourceUrl);
        service.signRequest(accessToken, oAuthRequest);
        Response oauthResponse = oAuthRequest.send();
        if (oauthResponse.getCode() == 200) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = (JsonNode)mapper.readValue(oauthResponse.getBody(), JsonNode.class);
                return node.get("id").asText();
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.501"), (Throwable)e);
                return null;
            }
        }
        _logger.warn((Object)MessageUtils.getString("err.502", String.valueOf(oauthResponse.getCode())));
        return null;
    }

    public HashMap<String, Object> getUserData(SqlSession sqlSession, String provider, String uid) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), "_webappos_oauth_manager");
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("provider", provider);
            criteria.andEqualTo("uid", uid);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            if (entityList.size() == 1) {
                Object oauthManager = entityList.get(0);
                Method method = oauthManager.getClass().getMethod("getUserId", new Class[0]);
                SchemaColumnBean addressColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "id"));
                Object userId = ConvertDateTypeUtils.convertStringToDbType(String.valueOf(method.invoke(oauthManager, null)), addressColumn);
                String authTableName = PropertyUtils.getProperty("auth.table.name");
                mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod(), authTableName);
                example = new CommonExample();
                criteria = example.createCriteria();
                criteria.andEqualTo(String.valueOf(authTableName) + '.' + "id", userId);
                List user = sqlSession.selectList(mapperName, (Object)example);
                if (user.size() == 1) {
                    return DaoUtils.convertEntityToMap(user.get(0), true);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void removeOAuthData(HttpServletRequest request, String provider, String userId) throws WebAppOSException {
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession();
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            String mapperName = DaoUtils.getMapperName(CrudEnum.DELETE.getMethod(), "_webappos_oauth_manager");
            Object dbProvider = ConvertDateTypeUtils.convertStringToDbType("_webappos_oauth_manager", "provider", provider);
            Object dbUserId = ConvertDateTypeUtils.convertStringToDbType("_webappos_oauth_manager", "user_id", userId);
            criteria.andEqualTo("provider", dbProvider);
            criteria.andEqualTo("user_id", dbUserId);
            sqlSession.delete(mapperName, (Object)example);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                HashMap loginUser = (HashMap)httpSession.getAttribute("LOGIN_USER");
                Map<String, Object> newUser = AuthUtils.refreshLoginUserData(sqlSession, loginUser);
                httpSession.setAttribute("LOGIN_USER", newUser);
            }
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
    }

    protected String addParameter(String uri) throws MalformedURLException {
        StringBuilder sb = new StringBuilder(uri);
        OAuthConsumer consumer = ConsumerProperties.getConsumer(this.provider.getName());
        for (Map.Entry<String, Object> param : consumer.getParameters().entrySet()) {
            sb.append("&");
            sb.append(param.getKey());
            sb.append("=");
            sb.append(param.getValue());
        }
        return sb.toString();
    }

    protected String getCallbackUrl(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(requestURL.substring(0, requestURL.lastIndexOf("/")));
        sb.append("/auth/callback/");
        sb.append("sp");
        sb.append("/");
        sb.append(this.provider.getName());
        sb.append("/");
        return sb.toString();
    }

    protected void copyAll(InputStream from, OutputStream into) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = from.read(buffer, 0, buffer.length)) > 0) {
            into.write(buffer, 0, len);
        }
    }

    public void setProvider(ServiceProviderEnum provider) {
        this.provider = provider;
    }

    public void setProviderApi(Api providerApi) {
        this.providerApi = providerApi;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }
}

