/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.co.headwaters.webappos.controller.oauth.OAuthConsumer;

public class ConsumerProperties {
    private static Properties _configuration = new Properties();
    private static Map<String, OAuthConsumer> _pool;

    private ConsumerProperties() {
    }

    public static void load() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (InputStream inputStream = ConsumerProperties.class.getClassLoader().getResourceAsStream("consumer.properties");){
            if (inputStream != null) {
                _configuration.load(inputStream);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        _pool = new HashMap<String, OAuthConsumer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OAuthConsumer getConsumer(String name) throws MalformedURLException {
        OAuthConsumer consumer;
        Map<String, OAuthConsumer> map = _pool;
        synchronized (map) {
            consumer = _pool.get(name);
            if (consumer == null) {
                consumer = ConsumerProperties.newConsumer(name);
                _pool.put(name, consumer);
            }
        }
        return consumer;
    }

    private static OAuthConsumer newConsumer(String name) throws MalformedURLException {
        OAuthConsumer consumer = new OAuthConsumer(name, _configuration.getProperty(String.valueOf(name) + ".apiKey"), _configuration.getProperty(String.valueOf(name) + ".apiSecret"));
        for (Map.Entry<Object, Object> prop : _configuration.entrySet()) {
            String propName = (String)prop.getKey();
            if (!propName.startsWith(String.valueOf(name) + ".params.")) continue;
            String c = propName.substring(name.length() + ".params.".length());
            consumer.setParameter(c, prop.getValue());
        }
        return consumer;
    }
}

