/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.oauth;

import java.io.IOException;
import jp.co.headwaters.webappos.controller.enumation.ServiceProviderEnum;
import jp.co.headwaters.webappos.controller.oauth.AbstractOAuthClient;
import jp.co.headwaters.webappos.controller.oauth.OAuthClient10aImpl;
import jp.co.headwaters.webappos.controller.oauth.OAuthClient20Impl;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.FacebookApi;
import org.scribe.builder.api.TwitterApi;

public abstract class OAuthClientFactory {
    public static AbstractOAuthClient create(String name) throws IOException {
        AbstractOAuthClient client = null;
        ServiceProviderEnum sp = ServiceProviderEnum.getServiceProvider(name);
        if (sp.equals((Object)ServiceProviderEnum.TWITTER)) {
            client = new OAuthClient10aImpl();
            client.setProviderApi((Api)new TwitterApi.Authenticate());
            client.setResourceUrl("https://api.twitter.com/1.1/account/verify_credentials.json");
        } else if (sp.equals((Object)ServiceProviderEnum.FACEBOOK)) {
            client = new OAuthClient20Impl();
            client.setProviderApi((Api)new FacebookApi());
            client.setResourceUrl("https://graph.facebook.com/me");
        }
        client.setProvider(sp);
        return client;
    }
}

