/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.security.Cipher;
import jp.co.headwaters.webappos.controller.security.CipherFactory;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.DaoUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;

public class AuthUtils {
    private static final Log _logger = LogFactory.getLog(AuthUtils.class);

    public static String getAuthColumnName(String columnName) {
        return ControllerUtils.getSchemaColumnKey(PropertyUtils.getProperty("auth.table.name"), columnName);
    }

    public static void registerOAuthData(SqlSession sqlSession, String provider, String userId, String uid) throws WebAppOSException {
        HashMap<String, Object> daoParams = new HashMap<String, Object>();
        CommonExample example = new CommonExample();
        CommonExample.Criteria criteria = example.createCriteria();
        String mapperName = DaoUtils.getMapperName(CrudEnum.COUNT.getMethod(), "_webappos_oauth_manager");
        Object dbProvider = ConvertDateTypeUtils.convertStringToDbType(provider, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "provider")));
        Object dbUserId = ConvertDateTypeUtils.convertStringToDbType(userId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "user_id")));
        Object dbUid = ConvertDateTypeUtils.convertStringToDbType(uid, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "uid")));
        criteria.andEqualTo("provider", dbProvider);
        criteria.andEqualTo("uid", dbUid);
        Integer count = (Integer)sqlSession.selectOne(mapperName, (Object)example);
        if (count != 0) {
            throw new WebAppOSException("err.504", dbProvider.toString(), dbUid.toString());
        }
        mapperName = DaoUtils.getMapperName(CrudEnum.INSERT.getMethod(), "_webappos_oauth_manager");
        daoParams.put(ControllerUtils.snakeToCamel("provider"), dbProvider);
        daoParams.put(ControllerUtils.snakeToCamel("user_id"), dbUserId);
        daoParams.put(ControllerUtils.snakeToCamel("uid"), dbUid);
        daoParams.put(ControllerUtils.snakeToCamel("created_date"), new Timestamp(System.currentTimeMillis()));
        daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
        HashMap<String, HashMap<String, Object>> insertMap = new HashMap<String, HashMap<String, Object>>();
        insertMap.put("record", daoParams);
        sqlSession.insert(mapperName, insertMap);
    }

    public static Map<String, Object> refreshLoginUserData(SqlSession sqlSession, Map<String, Object> loginUser) throws WebAppOSException {
        HashMap<String, Object> user = null;
        String authKey = AuthUtils.getAuthColumnName("id");
        if (loginUser == null) {
            return null;
        }
        String id = (String)loginUser.get(authKey);
        try {
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), PropertyUtils.getProperty("auth.table.name"));
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            String authTableName = PropertyUtils.getProperty("auth.table.name");
            Object dbId = ConvertDateTypeUtils.convertStringToDbType(id, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey(authTableName, "id")));
            criteria.andEqualTo("id", dbId);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            if (entityList.size() != 1) {
                throw new WebAppOSException("err.503");
            }
            user = DaoUtils.convertEntityToMap(entityList.get(0), true);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WebAppOSException("err.503");
        }
        return user;
    }

    public static boolean autoLogin(HttpServletRequest req, HttpServletResponse res) {
        block15: {
            SqlSession sqlSession;
            block16: {
                String userId;
                block14: {
                    HashMap user;
                    HttpSession session;
                    block13: {
                        sqlSession = null;
                        session = req.getSession(true);
                        Object autoLoginCheck = session.getAttribute("AUTO_LOGIN_CHECK");
                        if (autoLoginCheck == null || !(autoLoginCheck instanceof Boolean) || !((Boolean)autoLoginCheck).booleanValue()) break block13;
                        DaoUtils.closeSqlSession(sqlSession);
                        return true;
                    }
                    session.setAttribute("AUTO_LOGIN_CHECK", (Object)true);
                    userId = null;
                    Object loginUser = session.getAttribute("LOGIN_USER");
                    if (loginUser == null || !(loginUser instanceof Map) || (userId = (String)(user = (HashMap)loginUser).get(AuthUtils.getAuthColumnName("id"))) == null) break block14;
                    DaoUtils.closeSqlSession(sqlSession);
                    return true;
                }
                String key = null;
                Cookie[] cookies = req.getCookies();
                if (cookies != null) {
                    int i = 0;
                    while (i < cookies.length) {
                        if (cookies[i].getName().equals(PropertyUtils.getProperty("auth.autologin.cookie.name.key"))) {
                            key = cookies[i].getValue();
                        }
                        ++i;
                    }
                }
                if (key == null) break block15;
                sqlSession = DaoUtils.openSqlSession(false);
                HashMap<String, Object> user = AuthUtils.getUserDataByAutoLoginKey(sqlSession, key);
                if (user != null) {
                    userId = AuthUtils.removeAutoLoginKey(req, res, sqlSession);
                    HttpSession httpSession = req.getSession(false);
                    if (httpSession != null) {
                        httpSession.invalidate();
                    }
                    httpSession = req.getSession(true);
                    httpSession.setAttribute("LOGIN_USER", user);
                    AuthUtils.addAutoLoginKey(req, res, sqlSession, user);
                    break block16;
                }
                userId = AuthUtils.removeAutoLoginKey(req, res, null);
                DaoUtils.closeSqlSession(sqlSession);
                return false;
            }
            try {
                try {
                    DaoUtils.commit(sqlSession);
                }
                catch (Exception e) {
                    _logger.error((Object)e.getMessage(), (Throwable)e);
                    DaoUtils.closeSqlSession(sqlSession);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DaoUtils.closeSqlSession(sqlSession);
            }
        }
        return true;
    }

    public static void addAutoLoginKey(HttpServletRequest req, HttpServletResponse res, SqlSession sqlSession, HashMap<String, Object> user) throws WebAppOSException {
        String userId = (String)user.get(AuthUtils.getAuthColumnName("id"));
        String loginId = (String)user.get(AuthUtils.getAuthColumnName(PropertyUtils.getProperty("auth.column.email")));
        Cipher cipher = CipherFactory.create("smd5");
        String key = cipher.encrypt(String.valueOf(loginId) + RandomStringUtils.randomAlphanumeric((int)32));
        int expires = Integer.parseInt(PropertyUtils.getProperty("auth.autologin.cookie.expires"));
        Calendar cal = Calendar.getInstance();
        cal.add(5, expires);
        int expiry = (int)((cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L);
        AuthUtils.registerAutoLogin(sqlSession, userId, key, new Timestamp(cal.getTimeInMillis()));
        String cookieName = PropertyUtils.getProperty("auth.autologin.cookie.name.key");
        Cookie cookieId = new Cookie(cookieName, key);
        cookieId.setPath("/");
        cookieId.setMaxAge(expiry);
        res.addCookie(cookieId);
    }

    public static void removeAutoLoginKey(HttpServletRequest req, HttpServletResponse res) throws WebAppOSException {
        SqlSession sqlSession = null;
        try {
            sqlSession = DaoUtils.openSqlSession(false);
            AuthUtils.removeAutoLoginKey(req, res, sqlSession);
            DaoUtils.commit(sqlSession);
        }
        finally {
            DaoUtils.closeSqlSession(sqlSession);
        }
    }

    public static String removeAutoLoginKey(HttpServletRequest req, HttpServletResponse res, SqlSession sqlSession) throws WebAppOSException {
        String userId = null;
        String key = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(PropertyUtils.getProperty("auth.autologin.cookie.name.key"))) {
                    key = cookies[i].getValue();
                    cookies[i].setPath("/");
                    cookies[i].setMaxAge(0);
                    res.addCookie(cookies[i]);
                }
                ++i;
            }
        }
        if (key != null && sqlSession != null) {
            userId = AuthUtils.getUserId(sqlSession, key);
            AuthUtils.removeAutoLoginByKey(sqlSession, key);
        }
        return userId;
    }

    private static HashMap<String, Object> getUserDataByAutoLoginKey(SqlSession sqlSession, String key) throws NoSuchMethodException, SecurityException, WebAppOSException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), "_webappos_auto_login");
        CommonExample example = new CommonExample();
        CommonExample.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("login_key", key);
        criteria.andGreaterThan("expires_date", new Timestamp(System.currentTimeMillis()));
        List entityList = sqlSession.selectList(mapperName, (Object)example);
        if (entityList.size() == 1) {
            Object autoLoginItem = entityList.get(0);
            Method method = autoLoginItem.getClass().getMethod("getUserId", new Class[0]);
            SchemaColumnBean idColumn = SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_oauth_manager", "id"));
            Object userId = ConvertDateTypeUtils.convertStringToDbType(String.valueOf(method.invoke(autoLoginItem, null)), idColumn);
            String authTableName = PropertyUtils.getProperty("auth.table.name");
            mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod(), authTableName);
            example = new CommonExample();
            criteria = example.createCriteria();
            criteria.andEqualTo(String.valueOf(authTableName) + '.' + "id", userId);
            List user = sqlSession.selectList(mapperName, (Object)example);
            if (user.size() == 1) {
                return DaoUtils.convertEntityToMap(user.get(0), true);
            }
        }
        return null;
    }

    private static String getUserId(SqlSession sqlSession, String key) {
        try {
            String mapperName = DaoUtils.getMapperName(CrudEnum.SELECT_BY_EXAMPLE.getMethod(), "_webappos_auto_login");
            CommonExample example = new CommonExample();
            CommonExample.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("login_key", key);
            List entityList = sqlSession.selectList(mapperName, (Object)example);
            if (entityList.size() > 0) {
                Object autoLoginItem = entityList.get(0);
                Method method = autoLoginItem.getClass().getMethod("getUserId", new Class[0]);
                return String.valueOf(method.invoke(autoLoginItem, null));
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    private static void registerAutoLogin(SqlSession sqlSession, String userId, String key, Timestamp expires) throws WebAppOSException {
        Object dbUserId = ConvertDateTypeUtils.convertStringToDbType(userId, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_auto_login", "user_id")));
        Object dbKey = ConvertDateTypeUtils.convertStringToDbType(key, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_auto_login", "login_key")));
        String mapperName = DaoUtils.getMapperName(CrudEnum.INSERT.getMethod(), "_webappos_auto_login");
        HashMap<String, Object> daoParams = new HashMap<String, Object>();
        daoParams.put(ControllerUtils.snakeToCamel("user_id"), dbUserId);
        daoParams.put(ControllerUtils.snakeToCamel("login_key"), dbKey);
        daoParams.put(ControllerUtils.snakeToCamel("expires_date"), expires);
        daoParams.put(ControllerUtils.snakeToCamel("created_date"), new Timestamp(System.currentTimeMillis()));
        daoParams.put(ControllerUtils.snakeToCamel("updated_date"), new Timestamp(System.currentTimeMillis()));
        HashMap<String, HashMap<String, Object>> insertMap = new HashMap<String, HashMap<String, Object>>();
        insertMap.put("record", daoParams);
        sqlSession.insert(mapperName, insertMap);
    }

    private static void removeAutoLoginByKey(SqlSession sqlSession, String key) throws WebAppOSException {
        Object dbKey = ConvertDateTypeUtils.convertStringToDbType(key, SchemaColumnCache.getSchemaColumn(ControllerUtils.getSchemaColumnKey("_webappos_auto_login", "login_key")));
        CommonExample example = new CommonExample();
        CommonExample.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("login_key", dbKey);
        String mapperName = DaoUtils.getMapperName(CrudEnum.DELETE.getMethod(), "_webappos_auto_login");
        sqlSession.delete(mapperName, (Object)example);
    }
}

