/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class ControllerUtils {
    public static String getFileSparator() {
        return System.getProperty("file.separator");
    }

    public static String getSchemaColumnKey(String tableName, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(tableName.toUpperCase());
        sb.append("_");
        sb.append(columnName.toUpperCase());
        return sb.toString();
    }

    public static String getResultMapKey(String tableName, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(ControllerUtils.camelToSnake(tableName).toUpperCase());
        sb.append("_");
        sb.append(ControllerUtils.camelToSnake(columnName).toUpperCase());
        return sb.toString();
    }

    public static boolean getContextMode() {
        return Boolean.valueOf(PropertyUtils.getProperty("context.mode"));
    }

    public static String getContextName() {
        return PropertyUtils.getProperty("context.name");
    }

    public static String getRedirectUri(String uri) {
        StringBuilder sb = new StringBuilder();
        if (ControllerUtils.getContextMode()) {
            sb.append("/");
            sb.append(ControllerUtils.getContextName());
        }
        if (uri == null) {
            sb.append("/");
        } else {
            sb.append(uri);
        }
        return sb.toString();
    }

    public static String getRedirectUri(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        sb.append(req.getServletPath());
        StringBuilder params = new StringBuilder();
        if (req.getParameterMap() != null && req.getParameterMap().size() > 0) {
            for (Map.Entry param : req.getParameterMap().entrySet()) {
                String[] values = (String[])param.getValue();
                int i = 0;
                while (i < values.length) {
                    if (params.toString().length() > 0) {
                        params.append("&");
                    }
                    params.append((String)param.getKey());
                    params.append("=");
                    params.append(values[i]);
                    ++i;
                }
            }
        }
        if (params.toString().length() > 0) {
            sb.append("?");
            sb.append(params.toString());
        }
        return sb.toString();
    }

    public static String snakeToCamel(String target) {
        return ControllerUtils.snakeToCamel(target, false);
    }

    public static String snakeToCamel(String target, boolean firstCharacterUppercase) {
        Pattern p = Pattern.compile("_([a-z])");
        Matcher m = p.matcher(target.toLowerCase());
        StringBuffer sb = new StringBuffer(target.length());
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String camelToSnake(String target) {
        String convertedStr = target.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2");
        return convertedStr.toLowerCase();
    }

    public static String getFileExtension(String target) {
        if (target == null) {
            return null;
        }
        int point = target.lastIndexOf(".");
        if (point != -1) {
            return target.substring(point + 1);
        }
        return null;
    }

    public static String removeFileExtension(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return filename;
        }
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos == -1) {
            return filename;
        }
        if (lastDotPos == 0) {
            return filename;
        }
        return filename.substring(0, lastDotPos);
    }

    public static Map<String, Object> toHtmlString(Map<String, Object> obj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            if (entry.getValue() instanceof Map) {
                result.put(entry.getKey(), ControllerUtils.toHtmlString((Map)entry.getValue()));
                continue;
            }
            result.put(entry.getKey(), ControllerUtils.toHtmlString(ConvertDateTypeUtils.convertDbTypeToString(entry.getValue())));
        }
        return result;
    }

    public static String toHtmlString(String value) {
        String s = "";
        int i = 0;
        while (i < value.length()) {
            Character c = new Character(value.charAt(i));
            switch (c.charValue()) {
                case '<': {
                    s = s.concat("&lt;");
                    break;
                }
                case '>': {
                    s = s.concat("&gt;");
                    break;
                }
                case '\"': {
                    s = s.concat("&quot;");
                    break;
                }
                case '\'': {
                    s = s.concat("&#39;");
                    break;
                }
                default: {
                    s = s.concat(c.toString());
                }
            }
            ++i;
        }
        return s;
    }
}

