/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.controller.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jp.co.headwaters.webappos.controller.cache.SchemaColumnCache;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.exception.NotFoundException;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.model.AbstractEntity;
import jp.co.headwaters.webappos.controller.model.CommonExample;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.controller.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class DaoUtils {
    private SqlSessionFactory sessionFactory = this.createSqlSessionFactory();
    private static final Log _logger = LogFactory.getLog(DaoUtils.class);
    private static DaoUtils inst = new DaoUtils();

    private DaoUtils() {
    }

    private static SqlSessionFactory getSqlSessionFactory() {
        return DaoUtils.inst.sessionFactory;
    }

    private SqlSessionFactory createSqlSessionFactory() {
        SqlSessionFactory ssf = null;
        try {
            ssf = new SqlSessionFactoryBuilder().build(Resources.getResourceAsStream((String)"mybatis-config.xml"));
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ssf;
    }

    public static SqlSession openSqlSession() {
        return DaoUtils.openSqlSession(true);
    }

    public static SqlSession openSqlSession(boolean autoCommit) {
        return DaoUtils.getSqlSessionFactory().openSession(autoCommit);
    }

    public static void closeSqlSession(SqlSession session) {
        if (session != null) {
            session.rollback(true);
            session.close();
        }
        session = null;
    }

    public static void commit(SqlSession session) {
        if (session != null) {
            session.commit(true);
        }
    }

    public static void rollback(SqlSession session) {
        if (session != null) {
            session.rollback(true);
        }
    }

    public static String getMapperName(String method, String target) {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("root.package"));
        sb.append('.');
        sb.append("mapper");
        sb.append('.');
        sb.append(ControllerUtils.snakeToCamel(target, true));
        sb.append("Mapper");
        sb.append('.');
        sb.append(CrudEnum.getCrud(method).getStatementId());
        return sb.toString();
    }

    public static HashMap<String, Object> convertEntityToMap(Object obj, boolean isRecursive) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        HashMap<String, Object> recordMap = new HashMap<String, Object>();
        if (obj == null) {
            return null;
        }
        String key = null;
        Object value = null;
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("get") && !method.getName().equals("getClass") && (value = method.invoke(obj, new Object[0])) != null) {
                if (value instanceof List) {
                    if (isRecursive) {
                        List list = (List)value;
                        ArrayList<HashMap<String, Object>> multipleList = new ArrayList<HashMap<String, Object>>();
                        key = ControllerUtils.getResultMapKey(obj.getClass().getSimpleName(), ControllerUtils.camelToSnake(StringUtils.substringAfter((String)method.getName(), (String)"get")));
                        recordMap.put(key.toUpperCase(), multipleList);
                        int i = 0;
                        while (i < list.size()) {
                            multipleList.add(DaoUtils.convertEntityToMap(list.get(i), isRecursive));
                            ++i;
                        }
                    }
                } else if (value instanceof AbstractEntity) {
                    if (isRecursive) {
                        recordMap.putAll(DaoUtils.convertEntityToMap(value, isRecursive));
                    }
                } else {
                    key = ControllerUtils.getResultMapKey(obj.getClass().getSimpleName(), ControllerUtils.camelToSnake(StringUtils.substringAfter((String)method.getName(), (String)"get")));
                    recordMap.put(key.toUpperCase(), ConvertDateTypeUtils.convertDbTypeToString(value));
                }
            }
            ++n2;
        }
        return recordMap;
    }

    public static boolean isConflict(SqlSession sqlSession, SchemaColumnBean schemaColumn, Object value) throws WebAppOSException {
        String mapperName = DaoUtils.getMapperName(CrudEnum.COUNT.getMethod(), schemaColumn.getTableName());
        CommonExample example = new CommonExample();
        CommonExample.Criteria criteria = example.createCriteria();
        criteria.andEqualTo(schemaColumn.getColumnName(), value);
        Integer count = (Integer)sqlSession.selectOne(mapperName, (Object)example);
        return count > 0;
    }

    public static void createCriteria(String resultName, String target, String column, String operator, String[] values, CommonExample.Criteria criteria, int i) throws WebAppOSException {
        String col = null;
        String[] names = column.split("\\.");
        col = names.length == 2 ? column.toLowerCase() : String.valueOf(target.split(",")[0].toLowerCase()) + '.' + column.toLowerCase();
        SchemaColumnBean schemaColumn = SchemaColumnCache.getSchemaColumn(col.replace(".", "_"));
        Object value = null;
        if (!"isnull".equals(operator) && !"isnotnull".equals(operator) && StringUtils.isEmpty((CharSequence)values[i])) {
            return;
        }
        if ("isnull".equals(operator)) {
            criteria.andIsNull(col);
        } else if ("isnotnull".equals(operator)) {
            criteria.andIsNotNull(col);
        } else if ("eq".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andEqualTo(col, value);
        } else if ("nq".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andNotEqualTo(col, value);
        } else if ("gt".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andGreaterThan(col, value);
        } else if ("ge".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andGreaterThanOrEqualTo(col, value);
        } else if ("lt".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andLessThan(col, value);
        } else if ("le".equals(operator)) {
            value = ConvertDateTypeUtils.convertStringToDbType(values[i], schemaColumn);
            criteria.andLessThanOrEqualTo(col, value);
        } else if ("%like".equals(operator)) {
            criteria.andLike(col, "%" + values[i]);
        } else if ("%like%".equals(operator)) {
            criteria.andLike(col, "%" + values[i] + "%");
        } else if ("like%".equals(operator)) {
            criteria.andLike(col, String.valueOf(values[i]) + "%");
        } else if ("%notlike".equals(operator)) {
            criteria.andNotLike(col, "%" + values[i]);
        } else if ("%notlike%".equals(operator)) {
            criteria.andNotLike(col, "%" + values[i] + "%");
        } else if ("notlike%".equals(operator)) {
            criteria.andNotLike(col, String.valueOf(values[i]) + "%");
        } else if ("in".equals(operator)) {
            ArrayList<Object> paramList = new ArrayList<Object>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val1 = stringArray[n2];
                for (String val2 : Arrays.asList(val1.split(","))) {
                    if (StringUtils.isEmpty((CharSequence)val2)) continue;
                    paramList.add(ConvertDateTypeUtils.convertStringToDbType(val2.trim(), schemaColumn));
                }
                ++n2;
            }
            criteria.andIn(col, paramList);
        } else if ("notin".equals(operator)) {
            ArrayList<Object> paramList = new ArrayList<Object>();
            String[] stringArray = values;
            int n = values.length;
            int n3 = 0;
            while (n3 < n) {
                String val1 = stringArray[n3];
                for (String val2 : Arrays.asList(val1.split(","))) {
                    if (StringUtils.isEmpty((CharSequence)val2)) continue;
                    paramList.add(ConvertDateTypeUtils.convertStringToDbType(val2.trim(), schemaColumn));
                }
                ++n3;
            }
            criteria.andNotIn(col, paramList);
        } else {
            throw new NotFoundException("err.201", operator);
        }
    }
}

