/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator;

import java.io.File;
import java.io.IOException;
import jp.co.headwaters.webappos.generator.db.SystemTableLoader;
import jp.co.headwaters.webappos.generator.mybatis.ExtraMyBatisGenerator;
import jp.co.headwaters.webappos.generator.utils.FileUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import jp.co.headwaters.webappos.generator.web.JspGenerator;
import jp.co.headwaters.webappos.generator.web.PropertyGenerator;
import jp.co.headwaters.webappos.generator.web.StrutsXmlGenerator;
import jp.co.headwaters.webappos.generator.web.WebAppOSDatGenerator;
import jp.co.headwaters.webappos.generator.web.WebXmlGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.config.JDBCConnectionConfiguration;

public class Main {
    private static final Log _logger = LogFactory.getLog(Main.class);
    private static String _contextName = null;
    private static String _dbPassword = null;
    private static boolean _isFullBuild = true;

    public static void main(String[] args) {
        _logger.info((Object)"WEB APP OS generate start");
        try {
            if (!Main.validate(args)) {
                Main.exit(-1);
            }
            try {
                PropertyUtils.load();
            }
            catch (IOException e) {
                _logger.error((Object)MessageUtils.getString("err.001"), (Throwable)e);
                Main.exit(-2);
            }
            if (_isFullBuild) {
                JDBCConnectionConfiguration jDBCConnectionConfiguration;
                ExtraMyBatisGenerator myBatisGenerator;
                Main.clearOutputDirectory();
                if (!new PropertyGenerator().generate()) {
                    Main.exit(-3);
                }
                if (!(myBatisGenerator = new ExtraMyBatisGenerator()).generate(_dbPassword)) {
                    Main.exit(-4);
                }
                if (!new SystemTableLoader().load(jDBCConnectionConfiguration = myBatisGenerator.getConfiguration().getContext(GeneratorUtils.getContextName()).getJdbcConnectionConfiguration())) {
                    Main.exit(-5);
                }
            }
            if (!new JspGenerator(_isFullBuild).generate()) {
                Main.exit(-6);
            }
            if (!StrutsXmlGenerator.generate()) {
                Main.exit(-7);
            }
            if (!WebXmlGenerator.generate()) {
                Main.exit(-8);
            }
            if (!WebAppOSDatGenerator.generate()) {
                Main.exit(-9);
            }
            Main.exit(0);
        }
        catch (Exception e) {
            _logger.error((Object)MessageUtils.getString("err.900"), (Throwable)e);
            Main.exit(-99);
        }
    }

    public static String getContextName() {
        return _contextName;
    }

    private static void exit(int status) {
        _logger.info((Object)("WEB APP OS generate end status = " + status));
        System.exit(status);
    }

    private static boolean validate(String[] args) {
        if (args == null || args.length < 2) {
            return false;
        }
        _contextName = args[0];
        _dbPassword = args[1];
        if (args.length >= 3 && "diff".equalsIgnoreCase(args[2])) {
            _isFullBuild = false;
        }
        return true;
    }

    private static void clearOutputDirectory() {
        FileUtils.deleteFile(new File(GeneratorUtils.getOutputPath()));
        new File(GeneratorUtils.getOutputJspPath()).mkdirs();
        new File(GeneratorUtils.getOutputWebInfPath()).mkdir();
        new File(GeneratorUtils.getOutputSrcPath()).mkdir();
        new File(GeneratorUtils.getOutputPropertyPath()).mkdir();
        new File(GeneratorUtils.getOutputDatPath()).mkdir();
    }
}

