/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.ColumnCommentBean;
import jp.co.headwaters.webappos.controller.cache.bean.SchemaColumnBean;
import jp.co.headwaters.webappos.controller.cache.bean.SystemConstantBean;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.exception.WebAppOSException;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.ConvertDateTypeUtils;
import jp.co.headwaters.webappos.generator.utils.DataBaseUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.config.JDBCConnectionConfiguration;

public class SystemTableLoader {
    private static final Log _logger = LogFactory.getLog(SystemTableLoader.class);
    private static final String SELECT_SCHEMA_COLUMNS = "select * from _webappos_schema_columns order by table_name, column_name";
    private static final String SELECT_SYSTEM_CONSTANT = "select  coalesce(category,'') as category,   key,   value,   data_type,   display_order from   _webappos_system_constant order by category, display_order";

    public boolean load(JDBCConnectionConfiguration config) {
        if (!this.getSchemaColumn(config)) {
            return false;
        }
        return this.getSystemConstant(config);
    }

    private boolean getSchemaColumn(JDBCConnectionConfiguration config) {
        HashMap<String, SchemaColumnBean> schemaColumnMap = new HashMap<String, SchemaColumnBean>();
        WebAppOSCache.getInstance().setSchemaColumnMap(schemaColumnMap);
        ObjectMapper mapper = new ObjectMapper();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String key = null;
        try {
            try {
                connection = DataBaseUtils.getConnection(config);
                stmt = connection.createStatement();
                rs = stmt.executeQuery(SELECT_SCHEMA_COLUMNS);
                while (rs.next()) {
                    SchemaColumnBean schemaColumn = new SchemaColumnBean();
                    schemaColumn.setTableName(rs.getString("table_name"));
                    schemaColumn.setColumnName(rs.getString("column_name"));
                    schemaColumn.setNullable(rs.getBoolean("is_nullable"));
                    schemaColumn.setDataType(rs.getString("data_type"));
                    if (!StringUtils.isEmpty((CharSequence)rs.getString("column_comment"))) {
                        schemaColumn.setColumnComment((ColumnCommentBean)mapper.readValue(rs.getString("column_comment"), ColumnCommentBean.class));
                    }
                    schemaColumn.setUnique(rs.getBoolean("is_unique"));
                    key = ControllerUtils.getSchemaColumnKey(schemaColumn.getTableName(), schemaColumn.getColumnName());
                    schemaColumnMap.put(key, schemaColumn);
                }
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.103"), (Throwable)e);
                DataBaseUtils.closeResultSet(rs);
                DataBaseUtils.closeStatement(stmt);
                DataBaseUtils.closeConnection(connection);
                return false;
            }
        }
        catch (Throwable throwable) {
            DataBaseUtils.closeResultSet(rs);
            DataBaseUtils.closeStatement(stmt);
            DataBaseUtils.closeConnection(connection);
            throw throwable;
        }
        DataBaseUtils.closeResultSet(rs);
        DataBaseUtils.closeStatement(stmt);
        DataBaseUtils.closeConnection(connection);
        return true;
    }

    private boolean getSystemConstant(JDBCConnectionConfiguration config) {
        HashMap<String, Map<String, SystemConstantBean>> systemConstantMap = new HashMap<String, Map<String, SystemConstantBean>>();
        WebAppOSCache.getInstance().setSystemConstantMap(systemConstantMap);
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DataBaseUtils.getConnection(config);
                stmt = connection.createStatement();
                rs = stmt.executeQuery(SELECT_SYSTEM_CONSTANT);
                while (rs.next()) {
                    SystemConstantBean systemConstant = new SystemConstantBean();
                    systemConstant.setCategory(rs.getString("category"));
                    systemConstant.setKey(rs.getString("key"));
                    systemConstant.setValue(rs.getString("value"));
                    systemConstant.setDataType(rs.getString("data_type"));
                    systemConstant.setDisplayOrder(rs.getInt("display_order"));
                    this.setRealValue(systemConstant);
                    if (!systemConstantMap.containsKey(systemConstant.getCategory())) {
                        systemConstantMap.put(systemConstant.getCategory(), new HashMap());
                    }
                    ((Map)systemConstantMap.get(systemConstant.getCategory())).put(systemConstant.getKey(), systemConstant);
                }
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.104"), (Throwable)e);
                DataBaseUtils.closeResultSet(rs);
                DataBaseUtils.closeStatement(stmt);
                DataBaseUtils.closeConnection(connection);
                return false;
            }
        }
        catch (Throwable throwable) {
            DataBaseUtils.closeResultSet(rs);
            DataBaseUtils.closeStatement(stmt);
            DataBaseUtils.closeConnection(connection);
            throw throwable;
        }
        DataBaseUtils.closeResultSet(rs);
        DataBaseUtils.closeStatement(stmt);
        DataBaseUtils.closeConnection(connection);
        return true;
    }

    private void setRealValue(SystemConstantBean systemConstant) throws WebAppOSException {
        Cloneable realValue = null;
        if (!StringUtils.isEmpty((CharSequence)systemConstant.getValue())) {
            if (DataTypeEnum.DATA_TYPE_MAP.getDataType().equals(systemConstant.getDataType().toLowerCase())) {
                String[] array;
                HashMap<String, String> map = new HashMap<String, String>();
                String[] stringArray = array = systemConstant.getValue().split(",");
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    String[] value = e.split("=");
                    map.put(value[0], value[1]);
                    ++n2;
                }
                realValue = map;
            } else if (DataTypeEnum.DATA_TYPE_MAP.getDataType().equals(systemConstant.getDataType().toLowerCase())) {
                String[] array;
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray = array = systemConstant.getValue().split(",");
                int n = array.length;
                int n3 = 0;
                while (n3 < n) {
                    String e = stringArray[n3];
                    list.add(e);
                    ++n3;
                }
                realValue = list;
            } else {
                realValue = ConvertDateTypeUtils.convertStringToDbType(systemConstant.getValue(), systemConstant.getDataType());
            }
        }
        systemConstant.setRealValue(realValue);
    }
}

